/******************************************************************************
*
* dsPIC30F4011 	DSP Musicolour program 
* Author: 		Mauro Grassi Copyright (2008). All rights Reserved.
* Began: 		February 2008 
* Thanks to: 	Microchip, for the FFT/DSP library.
*
* 
*
* IMPORTANT RELEASE NOTES:
* 
* Please compile without automatic init of data space and level 1 optimization enabled! 
*
* Beware of blocking loops- this is real time sensitive software!
* - Compiling Instructions: 
* - Must use the following custom linker script definitions for the secure section -
*
* --* begin linker script additions *--
* 	programTop 	= 0x8000 ;
* 	secStart 	= 0x7600 ;
* 
* 	SECTIONS
* 	{
* 	.SecureSection secStart :
* 		{
*			*(.SecureSection);
*			. += programTop - .;
* 		} > program
*	}
*
* --* end linker script additions *--
*
* Version History, what started out on a breadboard... became... Ver 1.0- 13.00 alpha, then release then final release...
*
* Pre-Release Version:
* ver 1.0 began February 2008 (Mauro Grassi)
* ver 4.0 Mauro Grassi (last updated May 2008)
* 15 May 2008: changed software for TRIAC triggering to accomodate asymmetrical half cycles due to
* edge triggering of INT0 occurring at different levels ie. around 1.5V and 3.5V off the 7.5V secondary winding.
* ver 4.1 	Mauro Grassi (May 2008)
* 			- 	due to phase differences and asymmetries between half cycles, this new ver
* 		    	uses output compare interrupts in addition to the INT0 interrupt.
* ver 4.2   Mauro Grassi - streamlined the delay routines to be measured in ms.
* ver 6.0   - fixed frequency of mains calculations - asymmetric phase(s) again!
* ver 7.0   - fixed problem with DisW function (negative ints) and also much improved the frequency system
*           - the frequency system is much more exact and takes into account asymmetrical phase(s) of the
*		    - INT0 triggering for the MAINS_SYNC ie. INT0 triggers on edges but the trigger points are not symmetrical
*	    	 - resulting in cycles of about 8.5ms and 11.5ms for the mains (50Hz) and so the frequency measurements
*		    - are now done by taking into account evenly aligned phase periods (every second toggleLED())
* ver 1.0   - revert to new ver (beta)
* ver 1.7   - added screen brightness controls, by controlling the dead time.
* ver 1.8   - added TRIACs final phase calibration routines
* ver 2.0   - added output compare interrupts!
* ver 2.1   - added automatic Triac calibration as well as manual.
* ver 2.2   - added support for asymmetric triggering on two different phases (only used for calibration purposes)
* ver 3.0   - fixed phase1 to be only positive normally (ahead)
* ver 4.0   - improved Triac Stability by using SyncTmr2 to store max phase offset for each phase
* ver 5.0   - much improved Triac stability with support for piecewise linear output compare
* ver 6.0   - improved Timeouts and timing using 32 bit timer 4/5 and introduced adaptive pot controls
* ver 7.0   - added chaser objects
* ver 8.0   - added IR RC5 remote control decoding (optional)
* ver 8.4   - disabled nesting of interrupts because we are running out of memory for the stack.
* ver 8.5   - improved the transitions between digital and analog pot.
* ver 8.6   - added strobe mode for Output Chns.
* ver 8.7   - improved the strobe modes to maximum frequency (50Hz or equal to the line frequency).
* ver 8.8   - minor improvements.
* ver 8.9   - improved disW and disF routines
* ver 9.0   - improved performance with __builtin__ functions for integer division and modulus, etc.
* ver 9.1   - new font
* ver 9.2   - must improve the ADCInterrupt routine it is only fast enough for 8KHz at the moment.
* ver 9.3   - much improved disF and disW routines using the \ function.
* ver 9.4   - improved the ADC Interrupt to handle fixed fractional mixing of input chnns (floating point is not fast enough uses too much memory)
* ver 9.5   - added variable ADC sampling Frequency!
* ver 9.6   - improved critical sections.
* ver 9.7   - added flashing support in background, a few improvements to the Chaser system (non blocking delays) and support for Equalizer
* ver 9.8   - added ZV zero voltage switching mode and CONTINUOUS mode, as well as setBinLevels improvements
* ver 9.9   - persistent settings beta.
* ver 10.0  - persistent settings done.
* ver 10.20 - improved the main loop.
* ver 10.30 - improved the key presses to wake up the screen saver/ and the mainloop is almost done!
* ver 10.40 - detect silence. and took out the infinite while loops for adcBlock.
* ver 12.20 - added UART
* ver 12.30 - improved UART code for OVERRUN detection and rudimetary printstringUart etc...
* ver 12.35 - improved the display drivers so that the LEDS are only affected by DENABLE whereas display is affected by MENABLE and DENABLE
* ver 12.36 - added channel permutations
* ver 12.40 - finishing off the state machine/menu system now.
* ver 12.42 - minor improvements
* ver 12.43 - minor improvements
* ver 12.50 - finalised provisional machine state table
* ver 12.51 - improvements to state table
* ver 12.52 - improvements to dostate() etc
* ver 12.55 - added state machine stack! Note to Microchip: more RAM please.
* ver 12.60 - added USE_EXTENDED_MODE to get extra 1Kb of Stack space (otherwise you will get STKERRs) (this is used
*			- by the Menu system using the 1KB buffer normally used by ADC and FFT and disabling temporarily for Stack
* ver 12.61 - adding all states implementations...
* ver 12.6x - getting there- implementing menu system functions now.
*
* Change to Release Ver: 27 June 2008 Mauro Grassi.
*
* ver 1.00 - Release Ver 1.00
* ver 1.40 - serial re flashing now available and working.
* ver 2.50 - improvements to the UART added interrupts for receive, removed flashing support (running out of memory for stack)
* ver 3.46 - almost final form (fixed problem with EEPROM redirected RAM buffer for EEPROM to spectrum[0] instead of sigCmpx[0], because
*			 viewMode is saved during ADC acquire (the latter uses the sigCmpx buffer so all sorts of problems will arise).
*            make sure not to use the spectrum buffer when writing to EEPROM
* 			 This version saves viewMode in nonvolatile memory also. Implemented attack, decay, triggering and all the other
*			 remaining menus, improved the Channels>Mode submenu and the triggering Threshold too.
* ver 3.48 - added right, left and mic variable gains and menus for these under AUDIO>Left Gain, etc.
*		   - also improved the equalizer menu display...
* ver 3.60 - minor improvements and added the user mode implementations.
* ver 3.66 - saves fcy variable in EEPROM too.
* ver 3.80 - fixed a bug with the EEPROM writing routines, where interrupts were not properly disabled before erasing row.
*		   - also changed the setOutputLevel for the dimmer function (relevant when in STROBE mode).
* ver 3.82 - fixed the g, j, p, q and y letters (small) pushed them up.
*		   - also fixed the calibration routines (esp. the calibrateFCY routine to reset to FCY before calibrating again).
* ver 3.84 - slight modification to setoutputLevel (removed zeroing of the strobe counter when setting level for continuous changes.)
* ver 3.86 - enabled Fail safe clock monitor, dropped BOR level to 4.2V
* ver 4.02 - improved digital Pot action and added MOVEMENT THRESHOLD, etc. improved the remote control system.
* ver 4.09 - minor improvements including to remote control system. almost there. Changed the fast boot splash screen etc.
* ver 4.16 - made pulseError[x] an int rather than the DOUBLE it was. improved pot moves detection.
* ver 4.24 - further improvement to pot move detect and tuning ... disabled ir detection when rf6Mode != INPUT_REMOTE
*		   - removed rf6Mode from saved values in VariablePointers.
* ver 4.42 - fixed OSCCON(TUN) bits' persistence. Note: not all bits of OSCCON are non-volatile.
* ver 4.50 - improved mains detect, etc. 
* ver 4.52 - changed the screen brightness default from 0x00FF (maximum possible) to 0x00F0.
* ver 4.56 - slight fix to bug affecting digital pot.
* CHANGE TO FINAL RELEASE VERSION: August 8, 2008.
* Final Release ver 1.00 - this is the release version.
* Revision 1.00 - changed strobe field defs so that 0x4000 (bit 14=1 means strobing off)
* Revision 1.20 - fixed digital Pot routines and locking mechanisms much improved. Added ZV Threshold submenu. 
* Revision 1.22 - improved pot reading to average out values and update for a more stable pot reading.
* Revision 1.30 - fixed the silenceThreshold and ZVthreshold setting routines. Took out currentState from persistent settings list.
* Final Release Version 1.28 Revision 2.01 - made screenSaver and timeout persistent by adding to Variable Pointers, and changed
*				 the drawMessage screensaver to avoid scrolling. Improvement to resetScreenSaver function 
* Final Release Version 1.30 Revision 2.01 - added a new screen saver that displays the current chaser program drawChaser();
* Final Release Version 1.36 Revision 2.01 - added sameDimmerFunction to stateDimmer through sameChannelFunction in internalVaryChannels
*										   - this allows automatic dimming/full brightness attack
* Final Release Version 1.38 Revision 2.10 - improved testChannel Function and slightly modified CONTINUOUS_MODE algorithm in setoutpulevel
* Final Release Version 1.40 Revision 2.10 - added setTimeOut(0); to KEY1 and KEY3 handlers in internalSetandRun(...) to avoid problem with long
*				- timeouts for screensaver emulations in stateSetScreenSaver....
* Final Release Version 1.48 Revision 2.10 - added setQuiescentLevel to updateAllSettings... 
****************************************************************************************************************************/
#include <p30F4011.h>
#include <libpic30.h>
#include <math.h>
#include "dsp.h"
#include "fft.h"
#include "Musicolour.h"
#include "font.h"
#include "ir.h"
#include "secure.h"
/* Device configuration register macros for building the hex file */

#if (USE_EXTENDED_MODE==1)
	#define	UPPERMOST_SPLIM_VALUE	0x0FF8
#endif
// Notice that FCY is around 30MHz and TCY=1/FCY (this is the INSTRUCTION CLOCK RATE or MIPS)
// Other fuse bits:
_FOSC(CSW_ON_FSCM_OFF & FRC_PLL16); 	 	/* internal 7.37MHz RC with 16xPLL oscillator, Failsafe clock off, Clock Switching on */
_FWDT(WDT_OFF);            					/* Watchdog timer disabled */
_FBORPOR(PBOR_ON & BORV_42 & MCLR_EN);		/* Brown-out reset disabled, MCLR reset BOR level 4.2V (if enabled) */
_FGS(CODE_PROT_OFF);            		    /* Code protect disabled */
/**********************************************************************************************************************************
* Pin outs as follows:
* dsPIC30F4011 Pinouts
***********************************************************************************************************************************
Pin No.  	Pin Name   	Use
1          	MCLR		RESET
2          	AN0			ADC input for Settings Potentiometer
3          	AN1			ADC input MICROPHONE INPUT
4          	AN2			ADC input LEFT CHANNEL
5          	AN3			ADC input RIGHT CHANNEL
6		   	RB4			S1 input
7		   	RB5			S2 input
8		   	RB6			S3 input
9		   	RB7		    S4 input
10		   	RB8			S5 input
11		   	VDD			-
12		   	VSS			-
13         	OSC1		-
14		   	RC15		S6 input
15		   	RC13		S7 input
16		   	-			-
17		   	INT0		interrupt 0 for mains sync input
18 		   	OC2			output compare channel output 2
19		   	OC4			output compare channel output 4
20		   	VSS			-
21		   	VDD			-
22			OC3			output compare channel output 3
23			OC1			output compare channel output 1
24			RF6			LED frequency output configurable for testing purposes (toggleLED() function controls this pin) (this can also be an input for the remote control)
25			PGD			-
26			PGC         -
27			U2TX/RF5	-   
28			CN17		used to detect a key press from tactile switches    
29			RF1			for jumpers (output) should be high
30			RF0			for jumpers	(input)
31			VSS			-
32			VDD			-
33			RE5			cathode of LED (also pulled down to ground)
34			RE4			anode of LED on board 
35			RE3			Dot Matrix Display Shift Register(s) control CK1(rows)    (used to be cols)
36			RE2			Dot Matrix Display Shift Register(s) control G 		      (used to be rows)
37			RE1			Dot Matrix Display Shift Register(s) control CK2(columns) (used to be G)
38			RE0			Dot Matrix Display Shift Register(s) control SER		  (used to be SER)	
39			AVSS		-
40			AVDD		-
*******************************************************************************
Use of peripherals:
*******************************************************************************
Timer1: is used as a 16bit Timer to measure frequencies...
Timer2: is used for the output compare channels (ie phase control of TRIACs)
Timer3: is used to refresh the dot matrix display (screen refresh tick)
INT0: is used to get the sync of the mains, ie. detect zero crossings
*/
extern const unsigned char BigFont[];
extern const unsigned char SmallFont[];
extern fractcomplex sigCmpx[FFT_BLOCK_LENGTH*2] __attribute__ ((section (".ydata, data, ymemory"), aligned (FFT_BLOCK_LENGTH*2*2)));	
extern const fractcomplex twiddleFactors[FFT_BLOCK_LENGTH/2] __attribute__ ((space(auto_psv), aligned (FFT_BLOCK_LENGTH*2)));
//*****************************************************************************
// Global Variables
//*****************************************************************************
// Flash Subsystem Variables
char addressErrorFlag;
unsigned int addressErrorsR;
unsigned int addressErrorsW;
char addressErrorReporting;
unsigned long hexaddress;
unsigned int* hexpointer;
unsigned int hexbytes;
unsigned int hextotal;
unsigned long hexrowaddress;
unsigned long hexprotectMin;
unsigned long hexprotectMax;
unsigned long hexprotectedBytes;
// EEPROM Subsystem variables
int EPbuffer;
int EPaddress;
int temp, temp2;
DOUBLE ftemp;
int saved;
// Variables Associated with the Trigger System
long triggerThreshold;
int silenceThreshold;
long triggerCount;
int triggerMinFreq;
int triggerMaxFreq;
long rms;
char trigger;
// Variables for storing the interrupt status
int ie0,ie1,ie2;
// General System Variables
unsigned char stateStack[STATE_STACK_SIZE];
unsigned char stateStackError;
int stateStackIndex;
float fcy;										// the actual instruction frequency
//char internalPOR;								// for detecting the POR power on reset...
DOUBLE mainsFreq;								// mains frequency either 50 or 60 (in Hz) determined in real time automatically. 
int rf6Mode;									// controls the output at RF6 (for calibration purposes)
int currentChannel;								// used to modify settings holds the currently "selected" channel 
int chaserProgram;								// actual chaser program active.
int chaserTotal;								// total number of chasers
int mainMode;		    				
int viewMode;									// controls mainloop
int equalizerCoefficient[EQUALIZERS];
frequencyObject freqObj[PERIODS];
DOUBLE Cm, Cl;									// MIC input coefficient
unsigned int iC[INPUT_CHANNELS];
// For Screen saver Control and Timeout/Timing system
int intMasterTimer;								// internal 100ms timer just counts up
int ledOnTime;
int ledOnTimer;
int screenOnTime;
int screenOnTimeout;
int chaserTimeOut;
int screenOffTimeout;
int screenOnTimer;
long screenTimeOut;								// in 100ms units controls delay of screen savers etc
long intScreenTimer;							// internal timer
int intCountDownTimer;							// used for internal timeouts
int silenceCounter;
// For Finite state machine system
unsigned char currentState;						// for Finite State Machine
unsigned char newTransition;					// =1 if new transition was made 0 otherwise for Finite State Machine
// For phase control and Mains sync
int outputEnable;								// =0 output channel disabled 1=enabled 
												// bit		7			6			5			4			3			2			1			0
												//		   ch4(phase1)	ch3(phase1)	ch2(phase1)	ch1(phase1)	ch4(phase0)	ch3(phase0)	ch2(phase0)	ch1(phase0)
int phase;										// the current phase 0 or 1
int phaseMask;									// the current phase mask 0x0F or 0xF0
int maxPhaseOffset;								// used for phase control =((FCY/(T2PRESCALE*MAINS_FREQ*2)), max offset roughly equal to FCY/(T2PRESCALE*50*2) 
int maxBuffer[PHASES];
int pulseError[PHASES];
int phaseOffset[PHASES];						// the current correcting term for TMR2
int phase0;										// correcting term for phase 0
int phase1;										// correcting term for phase 1
int ocTrigger;									// whether channels are triggered and in which phase 0 or 1
char channelPermutation[OUTPUT_CHANNELS];
channel ch[OUTPUT_CHANNELS];					// for each output compare channel
// For controlling the Display
int displayEnable;								// =0 to enable display =1 to disable display
int updownShift;								// controls up and down shifting of display 
unsigned int display[DISPLAY_COLUMNS+1];		// columns bits 
//unsigned int flashing[DISPLAY_COLUMNS+1];		//
unsigned int flashing;							// for the LEDs
unsigned int oldisplay[DISPLAY_COLUMNS+1];		// buffer
char buffer[NUM_DIGITS+3];						//
int displayIndex;					// index for screen refreshing
int cursor;							// screen column cursor
int screenBrightness;				// the screen brightness (8 bits) 0x0000= least bright 0x00FF= most bright
int screenPeriodOn;					// affects the brightness (ON time)
int screenPeriodOff;				// affects the brightness (OFF time)
int screenFrequency;				// the desired refresh rate
// For Key input system
int lastTimeAdded[NUM_KEYS];		// updated by the screen refresh function for the two switches 
char keyBuffer[KEY_BUFFER_SIZE];	// keys pressed FIFO queue
int keyPtr;							// for keys pressed FIFO queue
int keyGetPtr;						// for keys pressed FIFO queue
int keyFull;				     	// number of keys in input key queue
char analogPotMode;					// =0 for normal operation =not 0 when using an external remote control for the pot value
int digitalPot;
// For ADC and FFT system control
int analogLock;							// set pot mask
int rawPotValue;						// the raw pot value
int oldPotValue;						// to detect movement of the potentiometer.
int avgPotValue;
int iavgPotValue;
int avgPotValueTimes;
fractcomplex *adcPtr;	 				// adcPtr points to the beginning of adc data if request pending 
int adcSampleIndex;						// global pointer to memory, used by ADC interrupt to fill 4 
char adcErr;							// adcErr!=0 if adc request flagged before previous request serviced! must be cleared by software once error serviced 
char adcReq;							// adcReq=1 if adc data is ready to be processed 0 otherwise, must be cleared by software when request serviced!
//int adcBlock;							// semaphore
char adcStatus;
unsigned int adcSamplingFreq;			// the selected sampling frequency...
int peakFrequencyBin = 0;				// Declare post-FFT variables to compute the 
unsigned int peakFrequency = 0;			// frequency of the largest spectral component 
// For Screen savers
//int x, y, ox, oy;						// used for screen savers
//int dx, dy;							// used for screen savers
int screenX, screenY;
int screenUpdate;						// used for screen savers
int screenTimes;						// used for screen savers
int screenSaver;
int zvThreshold;
long spectrum[DISPLAY_COLUMNS+1];		// holds spectrum column value , is multiplexed with EEPROM routines so must be at least 16 in length
DOUBLE micGain, leftGain, rightGain;
int writingMode;
int outputTimer;
int outputRate;
//
// Chaser Variables
int g1, g2, g3, iopc, idata, idata2;
chaserObject Chaser;
//*****************************************************************************
// Function Prototypes
//*****************************************************************************
//extern void defineDefaultRemoteControl(void);
void setOutputLevel(int, int, int);
int GetAllSettings(int);
int PutAllSettings(int);
void setQuiescentLevel(int, int, int);
void setTimeOut(int);
void stateInitial(int);
void displaySmallDecimal(int);
void stateMenu(int);
void emptyFunction(int);
void stateSetTriggerThreshold(int);
void stateSetSilenceThreshold(int);
void stateSetDisplayBrightness(int);
void stateSetDisplayFrequency(int);
void stateSetDisplayTimeOut(int);
void stateSetScreenSaver(int);
//
void stateSeeOutputEnable(int);
void stateSetOutputEnable(int);
void stateSeeCRC(int);
void stateSeeSamplingFrequency(int);
void stateSeeMainsFrequency(int);
void stateSeeADCFrequency(int);
void stateSeeScreenFrequency(int);
void stateSeeTriacsFrequency(int);
void stateSeeMainsDuty(int);
//void stateSeeADCDuty(int);
void stateSeeSPI(int);
//void stateSeeScreenDuty(int);
void stateSeeU1MODE(int);
void stateSeeU1STA(int);
//void stateSeeTriacsDuty(int);

void stateSeeFcy(int);
void stateSeeAccuracy(int);
//
void stateSeeOutputFrequency(int);
void stateSetOutputFrequency(int);
void stateSeeVersion(int);
//
void stateSeeTriggerMinFreq(int);
void stateSeeTriggerMaxFreq(int);
void stateSetTriggerMinFreq(int);
void stateSetTriggerMaxFreq(int);
//
void stateSeeBaudRate(int);
void stateSetSerialSettings(int);
void stateRC5Echo(int);
void stateSeeRemoteControl(int);
void stateDefineRemoteControl(int);
//
void stateSeeDetectedMainsFrequency(int);
//
void internalSeeSetADCFrequency(int);
void stateReset(int);
void stateMasterReset(int);
void stateSeeStartup(int);
void stateSetStartup(int);
void stateTuning(int);
void stateRF6(int);
void stateSetADCFrequency(int);
void stateLoadDefaults(int);
extern void stateSoftwareUpgrade(int);
extern void stateFastSoftwareUpgrade(int);
void stateTestOutputs(int);
void stateSaveSettings(int);
void stateRecallSettings(int);
//
void stateDimmer(int);
void stateQuiescent(int);
void stateCom(int);
void stateComHex(int);
//
void stateSetChannelGain(int);
void stateSetChannelMode(int);
void stateSetChannelMinFreq(int);
void stateSetChannelMaxFreq(int);
void stateSetChannelFreq(int);
void stateSetBalance(int);
void stateSeeBalanceValues(int);
void stateSetEqualizer(int);
void stateSetPermutation(int);
//
void stateSetDisplayDefaults(int);
void stateSetTriggerDefaults(int);
void stateSetSystemDefaults(int);
void stateSetChannelDefaults(int);
void stateSetAudioDefaults(int);
void stateSetOutputsDefaults(int);
void stateSetWritingMode(int);
int stateCalibration(int);
//
void stateSeeChaserMode(int);
void stateSetChaserMode(int);
void stateSetChaserProgram(int);
//
void stateSetChannelAttack(int);
void stateSetChannelDecay(int);
void stateTestChannel(int);
//
void stateAutoConfig(int);
void stateHighContrastConfig(int);
void stateStrobeConfig(int);
void stateChaserConfig(int);
//
void stateSeeRightGain(int);
void stateSeeLeftGain(int);
void stateSeeMicGain(int);
void stateSetRightGain(int);
void stateSetLeftGain(int);
void stateSetMicGain(int);
//
void stateSetZVThreshold(int);
//*****************************************************************************
// Finite State Machine Table
//*****************************************************************************
const state machineStates[] __attribute__((space(auto_psv)))={
// the Main Menus Start Here																																																					//
	{ CHANNEL_MENU_STATE,					"Channels",				&stateMenu,							KEY_PUSH_TRANSITION,	{ TRIGGER_MENU_STATE,					CHANNEL_MINFREQ_MENU_STATE,			RESERVED_MENU_STATE					} },
	{ TRIGGER_MENU_STATE,					"Trigger",				&stateMenu,							KEY_PUSH_TRANSITION,	{ CONSOLE_MENU_STATE,					SETTRIGGER_MINFREQ_MENU_STATE,		CHANNEL_MENU_STATE					} },
	{ CONSOLE_MENU_STATE,					"Console",				&stateMenu,							KEY_PUSH_TRANSITION,	{ OUTPUT_MENU_STATE,					DIMMER_MENU_STATE,					TRIGGER_MENU_STATE					} },
	{ OUTPUT_MENU_STATE,					"Output",				&stateMenu,							KEY_PUSH_TRANSITION,	{ AUDIO_MENU_STATE,						CHASER_MODE_MENU_STATE,				CONSOLE_MENU_STATE					} },
	{ AUDIO_MENU_STATE,						"Audio",				&stateMenu,							KEY_PUSH_TRANSITION,	{ SYSTEM_MENU_STATE,					EQUALIZER_MENU_STATE,				OUTPUT_MENU_STATE					} },
	{ SYSTEM_MENU_STATE,					"System",				&stateMenu,							KEY_PUSH_TRANSITION,	{ DISPLAY_MENU_STATE,					SEE_SOFTWARE_VERSION_STATE,			AUDIO_MENU_STATE					} },
	{ DISPLAY_MENU_STATE,					"Display",				&stateMenu,							KEY_PUSH_TRANSITION,	{ DEFAULTS_MENU_STATE,					SETDISPLAY_BRIGHTNESS_MENU_STATE,	SYSTEM_MENU_STATE					} }, 
	{ DEFAULTS_MENU_STATE,					"Defaults",				&stateMenu,							KEY_PUSH_TRANSITION,	{ ADVANCED_MENU_STATE,					LOAD_DEFAULTS_MENU_STATE,			DISPLAY_MENU_STATE					} },
	{ ADVANCED_MENU_STATE,					"Advanced",				&stateMenu,							KEY_PUSH_TRANSITION,	{ INFORMATION_MENU_STATE,				CALIBRATE_MENU_STATE,				DEFAULTS_MENU_STATE					} },
	{ INFORMATION_MENU_STATE,				"Information",			&stateMenu,							KEY_PUSH_TRANSITION,	{ RESERVED_MENU_STATE,					SEE_ADC_FREQ_STATE,					ADVANCED_MENU_STATE					} },
	{ RESERVED_MENU_STATE,					"Quick Setup",			&stateMenu,							KEY_PUSH_TRANSITION,	{ CHANNEL_MENU_STATE,					AUTO_CONFIG_MENU_STATE,				INFORMATION_MENU_STATE				} },	
// the Sub Menu States Start Here																																																				//
// The Display Sub Menus																																																						//
	{ SETDISPLAY_BRIGHTNESS_MENU_STATE,		"Brightness",			&stateMenu,							KEY_PUSH_TRANSITION,	{ SETDISPLAY_FREQUENCY_MENU_STATE,		SETDISPLAY_BRIGHTNESS_STATE, 		SETDISPLAY_DEFAULTS_MENU_STATE		} },
	{ SETDISPLAY_FREQUENCY_MENU_STATE,		"Frequency",			&stateMenu,							KEY_PUSH_TRANSITION,	{ SETDISPLAY_TIMEOUT_MENU_STATE,		SETDISPLAY_FREQUENCY_STATE, 		SETDISPLAY_BRIGHTNESS_MENU_STATE	} },
	{ SETDISPLAY_TIMEOUT_MENU_STATE,		"Timeout",				&stateMenu,							KEY_PUSH_TRANSITION,	{ SETDISPLAY_SCREENSAVER_MENU_STATE,	SETDISPLAY_TIMEOUT_STATE, 			SETDISPLAY_FREQUENCY_MENU_STATE		} },
	{ SETDISPLAY_SCREENSAVER_MENU_STATE,	"ScreenSaver",			&stateMenu,							KEY_PUSH_TRANSITION,	{ SETDISPLAY_DEFAULTS_MENU_STATE,		SETDISPLAY_SCREENSAVER_STATE, 		SETDISPLAY_TIMEOUT_MENU_STATE		} },
	{ SETDISPLAY_DEFAULTS_MENU_STATE,		"Display Defaults",		&stateMenu,							KEY_PUSH_TRANSITION,	{ SETDISPLAY_BRIGHTNESS_MENU_STATE,		SETDISPLAY_DEFAULTS_STATE, 			SETDISPLAY_SCREENSAVER_MENU_STATE	} },
	{ SETDISPLAY_BRIGHTNESS_STATE,			"",						&stateSetDisplayBrightness,			EMPTY_POP_TRANSITION,	{ SAME_STATE,							SAME_STATE,	 						SAME_STATE							} },
	{ SETDISPLAY_FREQUENCY_STATE,			"",						&stateSetDisplayFrequency,			EMPTY_POP_TRANSITION,	{ SAME_STATE,							SAME_STATE,	 						SAME_STATE							} },
	{ SETDISPLAY_TIMEOUT_STATE,				"",						&stateSetDisplayTimeOut,			EMPTY_POP_TRANSITION,	{ SAME_STATE,							SAME_STATE,	 						SAME_STATE							} },
	{ SETDISPLAY_SCREENSAVER_STATE,			"",						&stateSetScreenSaver,				EMPTY_POP_TRANSITION,	{ SAME_STATE,							SAME_STATE,	 						SAME_STATE							} },
	{ SETDISPLAY_DEFAULTS_STATE,			"",						&stateSetDisplayDefaults,			EMPTY_POP_TRANSITION,	{ SAME_STATE,							SAME_STATE,	 						SAME_STATE							} },
// The Information Sub Menus																																																					//
	{ SEE_ADC_FREQ_STATE,					"Adc(Hz):",				&stateSeeADCFrequency,				VIEW_TRANSITION,		{ SEE_MAINS_FREQ_STATE,					SAME_STATE,							SEE_CRC_STATE						} },
	{ SEE_MAINS_FREQ_STATE,					"Mains(Hz):",			&stateSeeMainsFrequency,			VIEW_TRANSITION,		{ SEE_SCREEN_FREQ_STATE,				SAME_STATE,							SEE_ADC_FREQ_STATE					} },
	{ SEE_SCREEN_FREQ_STATE,				"Screen(Hz):",			&stateSeeScreenFrequency,			VIEW_TRANSITION,		{ SEE_OC_TRIGGER_FREQ_STATE,			SAME_STATE,							SEE_MAINS_FREQ_STATE				} },
	{ SEE_OC_TRIGGER_FREQ_STATE,			"Triacs(Hz):",			&stateSeeTriacsFrequency,			VIEW_TRANSITION,		{ SEE_ADC_DUTY_STATE,					SAME_STATE,							SEE_SCREEN_FREQ_STATE				} },
	{ SEE_ADC_DUTY_STATE,					"Mains Duty(%):",		&stateSeeMainsDuty,					VIEW_TRANSITION,		{ SEE_MAINS_DUTY_STATE,					SAME_STATE,							SEE_OC_TRIGGER_FREQ_STATE			} },
	{ SEE_MAINS_DUTY_STATE,					"SPI1CON:",				&stateSeeSPI,						VIEW_TRANSITION,		{ SEE_SCREEN_DUTY_STATE,				SAME_STATE,							SEE_ADC_DUTY_STATE					} },
	{ SEE_SCREEN_DUTY_STATE,				"U1MODE:",				&stateSeeU1MODE,					VIEW_TRANSITION,		{ SEE_OC_TRIGGER_DUTY_STATE,			SAME_STATE,							SEE_MAINS_DUTY_STATE				} },
	{ SEE_OC_TRIGGER_DUTY_STATE,			"U1STA:",				&stateSeeU1STA,						VIEW_TRANSITION,		{ SEE_FCY_STATE,						SAME_STATE,							SEE_SCREEN_DUTY_STATE				} },
	{ SEE_FCY_STATE,						"Fcy(MHz):",			&stateSeeFcy,						VIEW_TRANSITION,		{ SEE_ACCURACY_STATE,					SAME_STATE,							SEE_OC_TRIGGER_DUTY_STATE			} },					
	{ SEE_ACCURACY_STATE,					"Error(%):",			&stateSeeAccuracy,					VIEW_TRANSITION,		{ SEE_DETECTED_STATE,					SAME_STATE,							SEE_FCY_STATE						} },
	{ SEE_DETECTED_STATE,					"Detected(Hz):",		&stateSeeDetectedMainsFrequency,	VIEW_TRANSITION,		{ SEE_CRC_STATE,						SAME_STATE,							SEE_ACCURACY_STATE					} }, 
	{ SEE_CRC_STATE,						"Check:",				&stateSeeCRC,						VIEW_TRANSITION,		{ SEE_ADC_FREQ_STATE,					SAME_STATE,							SEE_DETECTED_STATE					} },
// The Trigger Sub Menus																																																						//
	{ SETTRIGGER_MINFREQ_MENU_STATE,		"Min Freq(Hz):",		&stateSeeTriggerMinFreq,			VIEW_PUSH_TRANSITION,	{ SETTRIGGER_MAXFREQ_MENU_STATE,		SETTRIGGER_MINFREQ_STATE,			SETTRIGGER_DEFAULTS_MENU_STATE		} },
	{ SETTRIGGER_MAXFREQ_MENU_STATE,		"Max Freq(Hz):",		&stateSeeTriggerMaxFreq,			VIEW_PUSH_TRANSITION,	{ SETTRIGGER_THRESHOLD_MENU_STATE,		SETTRIGGER_MAXFREQ_STATE,			SETTRIGGER_MINFREQ_MENU_STATE		} },
	{ SETTRIGGER_THRESHOLD_MENU_STATE,		"Threshold",			&stateMenu,							KEY_PUSH_TRANSITION,	{ SETTRIGGER_DEFAULTS_MENU_STATE,		SETTRIGGER_THRESHOLD_STATE,			SETTRIGGER_MAXFREQ_MENU_STATE		} },
	{ SETTRIGGER_DEFAULTS_MENU_STATE,		"Trigger Defaults",		&stateMenu,							KEY_PUSH_TRANSITION,	{ SETTRIGGER_MINFREQ_MENU_STATE,		SETTRIGGER_DEFAULTS_STATE,			SETTRIGGER_THRESHOLD_MENU_STATE		} },
	{ SETTRIGGER_MINFREQ_STATE,				"",						&stateSetTriggerMinFreq,			EMPTY_POP_TRANSITION,	{ SAME_STATE,							SAME_STATE,							SAME_STATE							} },
	{ SETTRIGGER_MAXFREQ_STATE,				"",						&stateSetTriggerMaxFreq,			EMPTY_POP_TRANSITION,	{ SAME_STATE,							SAME_STATE,							SAME_STATE							} },	
	{ SETTRIGGER_THRESHOLD_STATE,			"",						&stateSetTriggerThreshold,			EMPTY_POP_TRANSITION,	{ SAME_STATE,							SAME_STATE,							SAME_STATE							} },
	{ SETTRIGGER_DEFAULTS_STATE,			"",						&stateSetTriggerDefaults,			EMPTY_POP_TRANSITION,	{ SAME_STATE,							SAME_STATE,							SAME_STATE							} },
// The Advanced Sub Menus																																																						//
	{ CALIBRATE_MENU_STATE,					"Calibration",		 	&stateMenu,							KEY_PUSH_TRANSITION,	{ WRITE_MODE_MENU_STATE,				CALIBRATE_STATE,					TUNING_MENU_STATE					} },
	{ WRITE_MODE_MENU_STATE,				"Write Mode",		 	&stateMenu,							KEY_PUSH_TRANSITION,	{ SOFTWARE_UPGRADE_MENU_STATE,			WRITE_MODE_STATE,					CALIBRATE_MENU_STATE				} },
	{ SOFTWARE_UPGRADE_MENU_STATE,			"Software Upgrade",	 	&stateMenu,							KEY_PUSH_TRANSITION,	{ PEEK_MENU_STATE,						SOFTWARE_UPGRADE_STATE,				WRITE_MODE_MENU_STATE				} },
	{ PEEK_MENU_STATE,						"Fast Flash",		 	&stateMenu,							KEY_PUSH_TRANSITION,	{ TUNING_MENU_STATE,					PEEK_STATE,							SOFTWARE_UPGRADE_MENU_STATE			} },	
	{ TUNING_MENU_STATE,					"Tune Oscillator",	 	&stateMenu,							KEY_PUSH_TRANSITION,	{ CALIBRATE_MENU_STATE,					TUNING_STATE,						PEEK_MENU_STATE						} },	
	{ CALIBRATE_STATE,						"",					 	(void*)&stateCalibration,			EMPTY_POP_TRANSITION,	{ SAME_STATE,							SAME_STATE,							SAME_STATE							} },
	{ WRITE_MODE_STATE,						"",		 				&stateSetWritingMode,				EMPTY_POP_TRANSITION,	{ SAME_STATE,							SAME_STATE,							SAME_STATE							} },
	{ SOFTWARE_UPGRADE_STATE,				"",					 	&stateSoftwareUpgrade,				EMPTY_POP_TRANSITION,	{ SAME_STATE,							SAME_STATE,							SAME_STATE							} },
	{ PEEK_STATE,							"",					 	&stateFastSoftwareUpgrade,			EMPTY_POP_TRANSITION,	{ SAME_STATE,							SAME_STATE,							SAME_STATE							} },
	{ TUNING_STATE,							"",					 	&stateTuning,						EMPTY_POP_TRANSITION,	{ SAME_STATE,							SAME_STATE,							SAME_STATE							} },
// The System Sub Menus																																																							//
	{ SEE_SOFTWARE_VERSION_STATE,			"Version:",				&stateSeeVersion,					VIEW_TRANSITION,		{ SETRS232_MENU_STATE,					SAME_STATE,							SETSYSTEM_DEFAULTS_MENU_STATE		} },
	{ SETRS232_MENU_STATE,					"Uart(bps):",			&stateSeeBaudRate,					VIEW_PUSH_TRANSITION,	{ DEFINE_REMOTE_MENU_STATE,				SETRS232_STATE,						SEE_SOFTWARE_VERSION_STATE			} },
	{ DEFINE_REMOTE_MENU_STATE,				"Remote Control:",		&stateSeeRemoteControl,				VIEW_PUSH_TRANSITION,	{ SETREMOTE_MENU_STATE,					DEFINE_REMOTE_STATE,				SETRS232_MENU_STATE					} },
	{ SETREMOTE_MENU_STATE,					"RC5 Echo",				&stateMenu,							KEY_PUSH_TRANSITION,	{ SETIRDA_MENU_STATE,					SETREMOTE_STATE,					DEFINE_REMOTE_MENU_STATE			} },
	{ SETIRDA_MENU_STATE,					"IrDa",					&stateMenu,							KEY_PUSH_TRANSITION,	{ TESTOUTPUTS_MENU_STATE,				SETIRDA_STATE,						SETREMOTE_MENU_STATE				} },
	{ TESTOUTPUTS_MENU_STATE,				"Test",					&stateMenu,							KEY_PUSH_TRANSITION,	{ DIAGNOSTICS_MENU_STATE,				TESTOUTPUTS_STATE,					SETIRDA_MENU_STATE					} },
	{ DIAGNOSTICS_MENU_STATE,				"Diagnostics",			&stateMenu,							KEY_PUSH_TRANSITION,	{ SEE_DETECTED_MAINS_FREQ_STATE,		DIAGNOSTICS_STATE,					TESTOUTPUTS_MENU_STATE				} },
	{ SEE_DETECTED_MAINS_FREQ_STATE,		"Detected Mains(Hz):",	&stateSeeDetectedMainsFrequency,	VIEW_TRANSITION,		{ STARTUP_MODE_MENU_STATE,				SAME_STATE,							DIAGNOSTICS_MENU_STATE				} },
	{ STARTUP_MODE_MENU_STATE,				"Startup:",				&stateSeeStartup,					VIEW_PUSH_TRANSITION,	{ RF6_MENU_STATE,						STARTUP_MODE_STATE,					SEE_DETECTED_MAINS_FREQ_STATE		} },
	{ RF6_MENU_STATE,						"RF6",					&stateMenu,							KEY_PUSH_TRANSITION,	{ RESET_MENU_STATE,						RF6_STATE,							STARTUP_MODE_MENU_STATE				} },
	{ RESET_MENU_STATE,						"Reset",				&stateMenu,							KEY_PUSH_TRANSITION,	{ SETSYSTEM_DEFAULTS_MENU_STATE,		RESET_STATE,						RF6_MENU_STATE						} },
	{ SETSYSTEM_DEFAULTS_MENU_STATE,		"System Defaults",		&stateMenu,							KEY_PUSH_TRANSITION,	{ SEE_SOFTWARE_VERSION_STATE,			SETSYSTEM_DEFAULTS_STATE,			RESET_MENU_STATE					} },
	{ SETRS232_STATE,						"",						&stateSetSerialSettings,			EMPTY_POP_TRANSITION,	{ SAME_STATE,							SAME_STATE,							SAME_STATE							} },
	{ SETREMOTE_STATE,						"",						&stateRC5Echo,						EMPTY_POP_TRANSITION,	{ SAME_STATE,							SAME_STATE,							SAME_STATE							} },
	{ DEFINE_REMOTE_STATE,					"",						&stateDefineRemoteControl,			EMPTY_POP_TRANSITION,	{ SAME_STATE,							SAME_STATE,							SAME_STATE							} },
	{ SETIRDA_STATE,						"",						&stateComHex,						EMPTY_POP_TRANSITION,	{ SAME_STATE,							SAME_STATE,							SAME_STATE							} },
	{ TESTOUTPUTS_STATE,					"",						&stateTestOutputs,					EMPTY_POP_TRANSITION,	{ SAME_STATE,							SAME_STATE,							SAME_STATE							} },
	{ DIAGNOSTICS_STATE,					"",						&stateMenu,							EMPTY_POP_TRANSITION,	{ SAME_STATE,							SAME_STATE,							SAME_STATE							} },
	{ STARTUP_MODE_STATE,					"",						&stateSetStartup,					EMPTY_POP_TRANSITION,	{ SAME_STATE,							SAME_STATE,							SAME_STATE							} },
	{ RF6_STATE,							"",						&stateRF6,							EMPTY_POP_TRANSITION,	{ SAME_STATE,							SAME_STATE,							SAME_STATE							} },
	{ RESET_STATE,							"",						&stateMasterReset,					EMPTY_POP_TRANSITION,	{ SAME_STATE,							SAME_STATE,							SAME_STATE							} },
	{ SETSYSTEM_DEFAULTS_STATE,				"",						&stateSetSystemDefaults,			EMPTY_POP_TRANSITION,	{ SAME_STATE,							SAME_STATE,							SAME_STATE							} },
// The Output Sub Menus																																																							//
	{ CHASER_MODE_MENU_STATE,				"Chaser Mode:",			&stateSeeChaserMode,				VIEW_PUSH_TRANSITION,	{ CHASER_PROGRAM_MENU_STATE,			CHASER_MODE_STATE,					SETOUTPUTS_DEFAULTS_MENU_STATE		} },
	{ CHASER_PROGRAM_MENU_STATE,			"Chaser Program",		&stateMenu,							KEY_PUSH_TRANSITION,	{ RATE_MENU_STATE,						CHASER_PROGRAM_STATE,				CHASER_MODE_MENU_STATE				} },
	{ RATE_MENU_STATE,						"Output Rate(Hz):",		&stateSeeOutputFrequency,			VIEW_PUSH_TRANSITION,	{ SILENCE_MENU_STATE,					RATE_STATE,							CHASER_PROGRAM_MENU_STATE			} },
	{ SILENCE_MENU_STATE,					"Silence Threshold",	&stateMenu,							KEY_PUSH_TRANSITION,	{ QUIESCENT_MENU_STATE,					SILENCE_STATE,						RATE_MENU_STATE						} },
	{ QUIESCENT_MENU_STATE,					"Quiescent Level",		&stateMenu,							KEY_PUSH_TRANSITION,	{ HIGH_CONTRAST_MENU_STATE,				QUIESCENT_STATE,					SILENCE_MENU_STATE					} },
	{ HIGH_CONTRAST_MENU_STATE,				"ZV Threshold",			&stateMenu,							KEY_PUSH_TRANSITION,	{ PERMUTE_MENU_STATE,					HIGH_CONTRAST_STATE,				QUIESCENT_MENU_STATE				} },
	{ PERMUTE_MENU_STATE,					"Logical Channels",		&stateMenu,							KEY_PUSH_TRANSITION,	{ OUTPUT_ENABLE_MENU_STATE,				PERMUTE_STATE,						HIGH_CONTRAST_MENU_STATE			} },	
	{ OUTPUT_ENABLE_MENU_STATE,				"Output Enable:",		&stateSeeOutputEnable,				VIEW_PUSH_TRANSITION,	{ SETOUTPUTS_DEFAULTS_MENU_STATE,		OUTPUT_ENABLE_STATE,				PERMUTE_MENU_STATE					} },
	{ SETOUTPUTS_DEFAULTS_MENU_STATE,		"Output Defaults",		&stateMenu,							KEY_PUSH_TRANSITION,	{ CHASER_MODE_MENU_STATE,				SETOUTPUTS_DEFAULTS_STATE,			OUTPUT_ENABLE_MENU_STATE			} },	
	{ CHASER_MODE_STATE,					"",						&stateSetChaserMode,				EMPTY_POP_TRANSITION_FOLLOWON,	{ SAME_STATE,					SAME_STATE,							SAME_STATE							} },
	{ CHASER_PROGRAM_STATE,					"",						&stateSetChaserProgram,				EMPTY_POP_TRANSITION,	{ SAME_STATE,							SAME_STATE,							SAME_STATE							} },
	{ RATE_STATE,							"",						&stateSetOutputFrequency,			EMPTY_POP_TRANSITION,	{ SAME_STATE,							SAME_STATE,							SAME_STATE							} },
	{ SILENCE_STATE,						"",						&stateSetSilenceThreshold,			EMPTY_POP_TRANSITION,	{ SAME_STATE,							SAME_STATE,							SAME_STATE							} },
	{ QUIESCENT_STATE,						"",						&stateQuiescent,					EMPTY_POP_TRANSITION,	{ SAME_STATE,							SAME_STATE,							SAME_STATE							} },
	{ HIGH_CONTRAST_STATE,					"",						&stateSetZVThreshold,				EMPTY_POP_TRANSITION,	{ SAME_STATE,							SAME_STATE,							SAME_STATE						} },
	{ PERMUTE_STATE,						"",						&stateSetPermutation,				EMPTY_POP_TRANSITION,	{ SAME_STATE,							SAME_STATE,							SAME_STATE							} },
	{ OUTPUT_ENABLE_STATE,					"",						&stateSetOutputEnable,				EMPTY_POP_TRANSITION_FOLLOWON,	{ SAME_STATE,					SAME_STATE,							SAME_STATE							} },
	{ SETOUTPUTS_DEFAULTS_STATE,			"",						&stateSetOutputsDefaults,			EMPTY_POP_TRANSITION,	{ SAME_STATE,							SAME_STATE,							SAME_STATE							} },
// The Audio Sub Menus																																																							//
	{ EQUALIZER_MENU_STATE,					"Equalizer",			&stateMenu,							KEY_PUSH_TRANSITION,	{ INPUT_BALANCE_MENU_STATE,				EQUALIZER_STATE,					SETAUDIO_DEFAULTS_MENU_STATE		} },
	{ INPUT_BALANCE_MENU_STATE,				"Balance:",				&stateSeeBalanceValues,				VIEW_PUSH_TRANSITION,	{ SETADC_FREQ_MENU_STATE,				INPUT_BALANCE_STATE,				EQUALIZER_MENU_STATE				} },
	{ SETADC_FREQ_MENU_STATE,				"Sampling(Hz):",		&stateSeeSamplingFrequency,			VIEW_PUSH_TRANSITION,	{ RIGHTGAIN_MENU_STATE,					SETADC_FREQ_STATE,					INPUT_BALANCE_MENU_STATE			} },
	{ RIGHTGAIN_MENU_STATE,					"Right Gain:",			&stateSeeRightGain,					VIEW_PUSH_TRANSITION,	{ LEFTGAIN_MENU_STATE,					RIGHTGAIN_STATE,					SETADC_FREQ_MENU_STATE				} },
	{ LEFTGAIN_MENU_STATE,					"Left Gain:",			&stateSeeLeftGain,					VIEW_PUSH_TRANSITION,	{ MICGAIN_MENU_STATE,					LEFTGAIN_STATE,						RIGHTGAIN_MENU_STATE				} },
	{ MICGAIN_MENU_STATE,					"Mic Gain:",			&stateSeeMicGain,					VIEW_PUSH_TRANSITION,	{ SETAUDIO_DEFAULTS_MENU_STATE,			MICGAIN_STATE,						LEFTGAIN_MENU_STATE					} },
	{ SETAUDIO_DEFAULTS_MENU_STATE,			"Audio Defaults",		&stateMenu,							KEY_PUSH_TRANSITION,	{ EQUALIZER_MENU_STATE,					SETAUDIO_DEFAULTS_STATE,			MICGAIN_MENU_STATE					} },
	{ EQUALIZER_STATE,						"",						&stateSetEqualizer,					EMPTY_POP_TRANSITION,	{ SAME_STATE,							SAME_STATE,							SAME_STATE							} },
	{ INPUT_BALANCE_STATE,					"",						&stateSetBalance,					EMPTY_POP_TRANSITION,	{ SAME_STATE,							SAME_STATE,							SAME_STATE							} },	
	{ SETADC_FREQ_STATE,					"",						&stateSetADCFrequency,				EMPTY_POP_TRANSITION,	{ SAME_STATE,							SAME_STATE,							SAME_STATE							} },
	{ RIGHTGAIN_STATE,						"",						&stateSetRightGain,					EMPTY_POP_TRANSITION,	{ SAME_STATE,							SAME_STATE,							SAME_STATE							} },
	{ LEFTGAIN_STATE,						"",						&stateSetLeftGain,					EMPTY_POP_TRANSITION,	{ SAME_STATE,							SAME_STATE,							SAME_STATE							} },
	{ MICGAIN_STATE,						"",						&stateSetMicGain,					EMPTY_POP_TRANSITION,	{ SAME_STATE,							SAME_STATE,							SAME_STATE							} },
	{ SETAUDIO_DEFAULTS_STATE,				"",						&stateSetAudioDefaults,				EMPTY_POP_TRANSITION,	{ SAME_STATE,							SAME_STATE,							SAME_STATE							} },
// The Channel Sub Menus																																																						//
	{ CHANNEL_MINFREQ_MENU_STATE,			"Min Freq",				&stateMenu,							KEY_PUSH_TRANSITION,	{ CHANNEL_MAXFREQ_MENU_STATE,			CHANNEL_MINFREQ_STATE,				SETCHANNEL_DEFAULTS_MENU_STATE				} },
	{ CHANNEL_MAXFREQ_MENU_STATE,			"Max Freq",				&stateMenu,							KEY_PUSH_TRANSITION,	{ CHANNEL_FREQ_MENU_STATE,				CHANNEL_MAXFREQ_STATE,				CHANNEL_MINFREQ_MENU_STATE			} },
	{ CHANNEL_FREQ_MENU_STATE,				"Freq",					&stateMenu,							KEY_PUSH_TRANSITION,	{ CHANNEL_GAIN_MENU_STATE,				CHANNEL_FREQ_STATE,					CHANNEL_MAXFREQ_MENU_STATE			} },
	{ CHANNEL_GAIN_MENU_STATE,				"Gain",					&stateMenu,							KEY_PUSH_TRANSITION,	{ CHANNEL_MODE_MENU_STATE,	 			CHANNEL_GAIN_STATE,					CHANNEL_FREQ_MENU_STATE				} },
	{ CHANNEL_MODE_MENU_STATE,				"Mode",					&stateMenu,							KEY_PUSH_TRANSITION,	{ CHANNEL_ATTACK_MENU_STATE,			CHANNEL_MODE_STATE,					CHANNEL_GAIN_MENU_STATE				} },		
	{ CHANNEL_ATTACK_MENU_STATE,			"Attack",				&stateMenu,							KEY_PUSH_TRANSITION,	{ CHANNEL_DECAY_MENU_STATE, 			CHANNEL_ATTACK_STATE,				CHANNEL_MODE_MENU_STATE				} },		
	{ CHANNEL_DECAY_MENU_STATE,				"Decay",				&stateMenu,							KEY_PUSH_TRANSITION,	{ CHANNEL_TEST_MENU_STATE, 				CHANNEL_DECAY_STATE,				CHANNEL_ATTACK_MENU_STATE			} },		
	{ CHANNEL_TEST_MENU_STATE,				"Test Channel",			&stateMenu,							KEY_PUSH_TRANSITION,	{ SETCHANNEL_DEFAULTS_MENU_STATE,		CHANNEL_TEST_STATE,					CHANNEL_DECAY_MENU_STATE			} },		
	{ SETCHANNEL_DEFAULTS_MENU_STATE,		"Channel Defaults",		&stateMenu,							KEY_PUSH_TRANSITION,	{ CHANNEL_MINFREQ_MENU_STATE,			SETCHANNEL_DEFAULTS_STATE,			CHANNEL_TEST_MENU_STATE				} },		
	{ CHANNEL_MINFREQ_STATE,				"",						&stateSetChannelMinFreq,			EMPTY_POP_TRANSITION,	{ SAME_STATE,							SAME_STATE,							SAME_STATE							} },
	{ CHANNEL_MAXFREQ_STATE,				"",						&stateSetChannelMaxFreq,			EMPTY_POP_TRANSITION,	{ SAME_STATE,							SAME_STATE,							SAME_STATE							} },
	{ CHANNEL_FREQ_STATE,					"",						&stateSetChannelFreq,				EMPTY_POP_TRANSITION,	{ SAME_STATE,							SAME_STATE,							SAME_STATE							} },
	{ CHANNEL_GAIN_STATE,					"",						&stateSetChannelGain,				EMPTY_POP_TRANSITION,	{ SAME_STATE,							SAME_STATE,							SAME_STATE							} },
	{ CHANNEL_MODE_STATE,					"",						&stateSetChannelMode,				EMPTY_POP_TRANSITION,	{ SAME_STATE,							SAME_STATE,							SAME_STATE							} },	
	{ CHANNEL_ATTACK_STATE,					"",						&stateSetChannelAttack,				EMPTY_POP_TRANSITION,	{ SAME_STATE,							SAME_STATE,							SAME_STATE							} },	
	{ CHANNEL_DECAY_STATE,					"",						&stateSetChannelDecay,				EMPTY_POP_TRANSITION,	{ SAME_STATE,							SAME_STATE,							SAME_STATE							} },	
	{ CHANNEL_TEST_STATE,					"",						&stateTestChannel,					EMPTY_POP_TRANSITION,	{ SAME_STATE,							SAME_STATE,							SAME_STATE							} },	
	{ SETCHANNEL_DEFAULTS_STATE,			"",						&stateSetChannelDefaults,			EMPTY_POP_TRANSITION,	{ SAME_STATE,							SAME_STATE,							SAME_STATE							} },	
// The Defaults Sub Menus																																																						//
	{ LOAD_DEFAULTS_MENU_STATE,				"Load Defaults",		&stateMenu,							KEY_PUSH_TRANSITION,	{ SAVE_SETTINGS_MENU_STATE, 			LOAD_DEFAULTS_STATE, 				AUTO_SAVE_MENU_STATE 				} },
	{ SAVE_SETTINGS_MENU_STATE,				"Save Settings",		&stateMenu,							KEY_PUSH_TRANSITION,	{ RECALL_SETTINGS_MENU_STATE,			SAVE_SETTINGS_STATE,				LOAD_DEFAULTS_MENU_STATE			} },
	{ RECALL_SETTINGS_MENU_STATE,			"Recall Settings",		&stateMenu,							KEY_PUSH_TRANSITION,	{ AUTO_SAVE_MENU_STATE,					RECALL_SETTINGS_STATE,				SAVE_SETTINGS_MENU_STATE			} },
	{ AUTO_SAVE_MENU_STATE,					"Reset",				&stateMenu,							KEY_PUSH_TRANSITION,	{ LOAD_DEFAULTS_MENU_STATE,				AUTO_SAVE_STATE,					RECALL_SETTINGS_MENU_STATE			} },
	{ LOAD_DEFAULTS_STATE,					"",						&stateLoadDefaults,					EMPTY_POP_TRANSITION,	{ SAME_STATE,							SAME_STATE,							SAME_STATE							} },
	{ SAVE_SETTINGS_STATE,					"",						&stateSaveSettings, 				EMPTY_POP_TRANSITION,	{ SAME_STATE,							SAME_STATE,							SAME_STATE							} },
	{ RECALL_SETTINGS_STATE,				"",						&stateRecallSettings,				EMPTY_POP_TRANSITION,	{ SAME_STATE,							SAME_STATE,							SAME_STATE							} },
	{ AUTO_SAVE_STATE,						"",						&stateReset,						EMPTY_POP_TRANSITION,	{ SAME_STATE,							SAME_STATE,							SAME_STATE							} },
// The Console Sub Menus																																																						//
	{ DIMMER_MENU_STATE,					"Dimmer",				&stateMenu,							KEY_PUSH_TRANSITION,	{ COM_MENU_STATE,						DIMMER_STATE,						COM_MENU_STATE						} },
	{ COM_MENU_STATE,						"Com",					&stateMenu,							KEY_PUSH_TRANSITION,	{ DIMMER_MENU_STATE,					COM_STATE,							DIMMER_MENU_STATE					} },
	{ DIMMER_STATE,							"",						&stateDimmer,						EMPTY_POP_TRANSITION,	{ SAME_STATE,							SAME_STATE,							SAME_STATE							} },
	{ COM_STATE,							"",						&stateCom,							EMPTY_POP_TRANSITION,	{ SAME_STATE,							SAME_STATE,							SAME_STATE							} },
// The Config Sub Menus
	{ AUTO_CONFIG_MENU_STATE,				"Auto",					&stateMenu,							KEY_PUSH_TRANSITION,	{ HIGH_CONTRAST_CONFIG_MENU_STATE,		AUTO_CONFIG_STATE,					CHASER_CONFIG_MENU_STATE			} },
	{ HIGH_CONTRAST_CONFIG_MENU_STATE,		"High Contrast",		&stateMenu,							KEY_PUSH_TRANSITION,	{ STROBE_CONFIG_MENU_STATE,				HIGH_CONTRAST_CONFIG_STATE,			AUTO_CONFIG_MENU_STATE				} },
	{ STROBE_CONFIG_MENU_STATE,				"Strobe",				&stateMenu,							KEY_PUSH_TRANSITION,	{ CHASER_CONFIG_MENU_STATE,				STROBE_CONFIG_STATE,				HIGH_CONTRAST_CONFIG_MENU_STATE		} },
	{ CHASER_CONFIG_MENU_STATE,				"Chaser",				&stateMenu,							KEY_PUSH_TRANSITION,	{ AUTO_CONFIG_MENU_STATE,				CHASER_CONFIG_STATE,				STROBE_CONFIG_MENU_STATE			} },
	{ AUTO_CONFIG_STATE,					"",						&stateAutoConfig,					EMPTY_POP_TRANSITION,	{ SAME_STATE,							SAME_STATE,							SAME_STATE							} },
	{ HIGH_CONTRAST_CONFIG_STATE,			"",						&stateHighContrastConfig,			EMPTY_POP_TRANSITION,	{ SAME_STATE,							SAME_STATE,							SAME_STATE							} },
	{ STROBE_CONFIG_STATE,					"",						&stateStrobeConfig,					EMPTY_POP_TRANSITION,	{ SAME_STATE,							SAME_STATE,							SAME_STATE							} },
	{ CHASER_CONFIG_STATE,					"",						&stateChaserConfig,					EMPTY_POP_TRANSITION,	{ SAME_STATE,							SAME_STATE,							SAME_STATE							} },
// the END_STATE must be last...																																																				//
	{ END_STATE, 							"", 					0,									EMPTY_POP_TRANSITION,	{ SAME_STATE, 							SAME_STATE, 						SAME_STATE							} }	};
//********************************************************************************************************************************************************************************************************************************************************************************************
// For Persistent Settings/EEPROM control
//***************************************************************************************************************************************************************************************************************************************************************************************
// Declare constants/coefficients/calibration data to be stored in DataEEPROM
int _EEDATA() arrayInDataEEPROM[1]={  0xFFFF };
//
// Declare variables to be stored in RAM
//*****************************************************************************
//*****************************************************************************
//*****************************************************************************
//*****************************************************************************
//*****************************************************************************
//*****************************************************************************
//*****************************************************************************
//*****************************************************************************
//*****************************************************************************
//*****************************************************************************
// Begin Code
//*****************************************************************************
//*****************************************************************************
// Miscellaneous Functions
//*****************************************************************************
void wait(void)
{
	asm("nop");
}

void emptyFunction(int y)
{
	asm("nop");
}

unsigned long getRandom(void)
{
	unsigned long n;
	n=(0x00007FFF & ((unsigned long)(TMR1+TMR2+TMR3+TMR4)));
	return n;
}

void
DelayMs(unsigned int dl)
{
	// delay is in ms (approx.)
#if (DEBUG==0)

	while(dl--){
			DELAY_STRING;
 			DELAY_STRING;
	}
#endif
}

void
DelayMsInt(unsigned int dl)
{
	if(keyFull<=0)DelayMs(dl); else DelayMs(DELAY_IF_KEY_PRESSED);
}

void setTimeOut(int u)
{
	intCountDownTimer=u;
}

int timeOut(void)
{
	if(intCountDownTimer>0)return FALSE; else return TRUE;
}

void blink(int times)
{
	int i;
	ERROR_LED=0;		// LED off
	DelayMs(BLINK_TIME_LONG);
	i=times;
	while(i>0)
	{
	ERROR_LED=1;
	DelayMs(BLINK_TIME);
	ERROR_LED=0;
	DelayMs(BLINK_TIME_LONG);
	i--;
	}
	DelayMs(BLINK_TIME);
	ERROR_LED=1;		// LED on
}

void clip(int *ptr, int minvalue, int maxvalue)
{
	if((*ptr)<minvalue)*ptr=minvalue; else if((*ptr)>maxvalue)*ptr=maxvalue;
}

unsigned long scaleShiftFromTo(unsigned long y, int frombits, int tobits)
{
	y=y<<tobits;
	y=y>>frombits;
	return y;
}

void unsignedclip(unsigned int *ptr, unsigned int minvalue, unsigned int maxvalue)
{
	if((*ptr)<minvalue)*ptr=minvalue; else if((*ptr)>maxvalue)*ptr=maxvalue;
}

void clipDouble(DOUBLE *ptr, DOUBLE minvalue, DOUBLE maxvalue)
{
	if((*ptr)<minvalue)*ptr=minvalue; else if((*ptr)>maxvalue)*ptr=maxvalue;
}

void changeValueModulo(int* ptr, int value, unsigned int modulo)
{
	if(modulo>0){
		if(value<0)*ptr=(int)(modulo-__builtin_modud(-value, modulo));
		else *ptr=(int)__builtin_modud(value, modulo);
	} else *ptr=0;	
}

int getMainMode(void)
{
	return ((mainMode>> MODE_BIT_SHIFT) & MODE_CLEAR);
}

void setMainMode(int xx)
{
	changeValueModulo(&xx, xx, 1+MODE_CLEAR);
	mainMode&=~(MODE_CLEAR<<MODE_BIT_SHIFT);
	mainMode|=(xx<<MODE_BIT_SHIFT);
}

//*********************************************************
// Chaser System
//*********************************************************
// The programming model is as follows
// Each channel has:
// IP				= 	instruction pointer		(16 bits)
// ACC				= 	accumulator 			(16 bits)
// CHANNEL			=   channel register		(16 bits)
// COUNTER			= 	counter					(16 bits)
// ATTACK			=  	attack register			(16 bits)
// DECAY			=   decay register			(16 bits)
// STACKP			= 	stack pointer			(16 bits)
// a small stack 	= 	8 bytes (4 levels)
// There are 3 global variables G1, G2, G3

int* fetchInstructionAndData(int* xip)
{
	int i;
	iopc=*xip;
	xip++;
	i=iopc & 0x0003;
	if(i==1){ idata=*xip++; } else if(i==2){ idata=*xip++; idata2=*xip++; }
	return xip;
}

int* decodeInstructionAndData(chaserObject* chobj)
{
	int* iip;
	int chm;

	chm=((mainMode>> MODE_CHASER_BIT_SHIFT) & MODE_CHASER_CLEAR);
	if(chobj->ip!=NULLP){
	iip=fetchInstructionAndData(chobj->ip);
	switch(iopc){

		case NOP:
			break;

		case OUTA:
			setOutputLevel(chobj->acc & 0x00FF, chobj->channel & 0x0003, CHASER_MODE);
			break;

		case OUTQA:
			setQuiescentLevel(chobj->acc & 0x00FF, chobj->channel & 0x0003, CHASER_MODE);
			break;

		case INA:
			break;

		case INQA:
			break;

		case GOTOP:
			iip=iip+idata;
			break;
		case LOADK16:
			chobj->counter=idata;
			break;
		case SETCH:
			chobj->channel=idata;
			break;
		case SETCH1:
			chobj->channel=0;
			break;
		case SETCH2:
			chobj->channel=1;
			break;
		case SETCH3:
			chobj->channel=2;
			break;
		case SETCH4:
			chobj->channel=3;
			break;
		case ATTACKTO:
			if((ch[chobj->channel].mode & CHASER_MODE)!=0){

			if(ch[chobj->channel].outputLevel<idata){
									iip=chobj->ip;
									if(chobj->attack<=0){
										chobj->attack=ch[chobj->channel & 0x0003].attack;
										setOutputLevel((ch[chobj->channel & 0x0003].outputLevel)+1, chobj->channel & 0x0003, CHASER_MODE);
									} else chobj->attack--;
			 }
			}
			break;

		case DECAYTO:
			if((ch[chobj->channel].mode & CHASER_MODE)!=0){
				if(ch[chobj->channel].outputLevel>idata){
									iip=chobj->ip;
									if(chobj->decay<=0){
										chobj->decay=ch[chobj->channel].decay;
										setOutputLevel((ch[chobj->channel].outputLevel)-1, chobj->channel, CHASER_MODE);
									} else chobj->decay--;
				}
			}
			break;

		case DECNZ:
				if(chobj->counter>0){ chobj->counter--; iip=iip+idata; }
				else { chobj->counter=0; }
			break;

		case LOADA16:
			chobj->acc=idata & 0xFFFF;
			break;

		case ADDA:
			chobj->acc+=idata;
			break;

		case ANDA:
			chobj->acc&=idata;
			break;

		case ORA:
			chobj->acc|=idata;
			break;

		case NOTA:
			chobj->acc=~(chobj->acc);
			break;

		case XORA:
			chobj->acc^=idata;
			break;

		case MOVAG1:
			g1=chobj->acc;
			break;

		case MOVAG2:
			g2=chobj->acc;
			break;

		case MOVAG3:
			g3=chobj->acc;
			break;

		case GETG1A:
			chobj->acc=g1;
			break;

		case GETG2A:
			chobj->acc=g2;
			break;

		case GETG3A:
			chobj->acc=g3;
			break;

		case SAWTOOTHA:
			break;

		case TRIANGLEA:
			break;

		case SQUAREA:
			break;

		case HALT:
			iip=NULLP;
			break;

		case CALL:
			break;

		case RETURN:
			break;
		
		case DELAYMS:
			// Note: DELAYMS is the only instruction that becomes NOP when running in TRIGGERED mode
			if(chm!=MODE_CHASER_TRIGGERED)
			{
			if(chaserTimeOut<0)
						{ 
						chaserTimeOut=idata; 
						iip=chobj->ip; 
						} 
						else 
						if(chaserTimeOut==0)
						{ chaserTimeOut--; }
			}
			break;
		case OUTL:
			setOutputLevel((idata>>8), CH1, CHASER_MODE);
			setOutputLevel((idata), CH2, CHASER_MODE);
			setOutputLevel((idata2>>8), CH3, CHASER_MODE);
			setOutputLevel((idata2), CH4, CHASER_MODE);
			break;
		case RANDOML:
			setOutputLevel(getRandom(), CH1, CHASER_MODE);
			setOutputLevel(getRandom(), CH2, CHASER_MODE);
			setOutputLevel(getRandom(), CH3, CHASER_MODE);
			setOutputLevel(getRandom(), CH4, CHASER_MODE);
			break;		
		default:
			break;
	}
	return iip; 
	} else return NULLP;
}

/*
void runProgram(chaserObject* chobj)
{
	chaserTimeOut=CHASER_TIMEOUT_INITIAL;
	while(chobj->ip!=NULLP)
	{
	chobj->ip=decodeInstructionAndData(chobj);
	}
}
*/

const int ChaserPrograms[] __attribute__((space(auto_psv), aligned(2)))=
{ 
	// Chaser Program 
	LOADK16, 0x0020, OUTL,	0xFF00, 0x0000, OUTL, 0x00FF, 0x0000, OUTL, 0x0000, 0xFF00, OUTL, 0x0000, 0x00FF, DECNZ, -14, HALT,
	// Chaser Program 
	LOADK16, 0x0020, OUTL,	0x0000, 0x00FF, OUTL, 0x0000, 0xFF00, OUTL, 0x00FF, 0x0000, OUTL, 0xFF00, 0x0000, DECNZ, -14, HALT,
	// Chaser Program 
	LOADK16, 0x0020, OUTL,	0xFFFF, 0x0000, OUTL, 0x0000, 0xFFFF, OUTL, 0x00FF, 0xFF00, OUTL, 0xFF00, 0x00FF, DECNZ, -14, HALT,
	// Chaser Program 
	LOADK16, 0x0020, OUTL,	0xFF00, 0x0000, OUTL, 0x00FF, 0x0000, OUTL, 0x0000, 0xFF00, OUTL, 0x0000, 0x00FF, DECNZ, -14, HALT,
	// Chaser Program
	LOADK16, 0x0020, OUTL,  0x00FF, 0xFFFF, OUTL, 0xFF00, 0xFFFF, OUTL, 0xFFFF, 0x00FF, OUTL, 0xFFFF, 0xFF00, DECNZ, -14, HALT,
	// Chaser Program
	LOADK16, 0x0020, OUTL,  0xFFFF, 0xFF00, OUTL, 0xFFFF, 0x00FF, OUTL, 0xFF00, 0xFFFF, OUTL, 0x00FF, 0xFFFF, DECNZ, -14, HALT,
	// Chaser Program
	LOADK16, 0x0020, OUTL,  0x0000, 0xFFFF, OUTL, 0xFFFF, 0x0000, OUTL, 0xFF00, 0x00FF, OUTL, 0x00FF, 0xFF00, DECNZ, -14, HALT,
	// Chaser Program
	LOADK16, 0x0020, RANDOML, DELAYMS, 0x0200, DECNZ, -5, HALT,
	// Chaser Program 
	HALT,
	// Chaser Program 
	HALT,
	// Chaser Program
	HALT,
	// The End
	END };

int *getChaserPointer(int *chaser_program_number)
{
	int i, j;
	int *p;

	changeValueModulo(chaser_program_number, *chaser_program_number, (chaserTotal-1));
	p=(int *)&ChaserPrograms[0];
	i=0;
	j=0;
	while(i!=END)
	{
	if(j==(*chaser_program_number))break;
	i=*p++;
	if(i==HALT)j++;
	}
	*chaser_program_number=j;
	return p;
}

void setChaserPointer(chaserObject *chobj, int program_number)
{
	chobj->acc=0;
	chobj->attack=DEFAULT_ATTACK;
	chobj->decay=DEFAULT_DECAY;
	chobj->channel=DEFAULT_OUTPUT_CHANNEL;
	chobj->counter=0;
	chobj->stackp=0;
	chobj->ip=getChaserPointer(&program_number);
	chobj->currentProgram=program_number;
}

void initChaserSystem(chaserObject *chobj)
{
	int i;
	int *p;
	p=(int *)&ChaserPrograms[0];
	i=0;
	chaserTotal=0;
	while(i!=END)
	{
	i=*p++;
	if(i==HALT)chaserTotal++;
	}
	setChaserPointer(chobj, chaserProgram);
}

int getChaserMode(void)
{
	return ((mainMode>> MODE_CHASER_BIT_SHIFT) & MODE_CHASER_CLEAR);
}

void setChaserMode(int xx)
{	
	// if the mode changes from OFF to any other mode, then we must reset Chaser object.
	changeValueModulo(&xx, xx, 1+MODE_CHASER_CLEAR);
	if((xx!=MODE_CHASER_OFF)&&((getChaserMode())==MODE_CHASER_OFF))setChaserPointer(&Chaser, chaserProgram);
	mainMode&=~(MODE_CHASER_CLEAR<<MODE_CHASER_BIT_SHIFT);
	mainMode|=(xx<<MODE_CHASER_BIT_SHIFT);
}

void setChaserProgram(int xx)
{
	changeValueModulo(&chaserProgram, xx, chaserTotal);	
	setChaserPointer(&Chaser, chaserProgram);
}

//*****************************************************************************
// EEPROM access functions
//*****************************************************************************
int readEEPROM(int address)
{
	// address is integer (ie word) address. EEPROM has 512 words or 1KByte.
	int *p;
    _prog_addressT EE_addr;
    /* initialize a variable to represent the Data EEPROM address */
    _init_prog_address(EE_addr, arrayInDataEEPROM);
	EE_addr+=(address<<1);
	/*Copy array "fooArrayinDataEE" from DataEEPROM to "fooArray2inRAM" in RAM*/
	disableAllInterrupts();
    _memcpy_p2d16((int *)&spectrum[0], EE_addr, 32);
	enableAllInterrupts();
    p=(int*)&spectrum[0];
	return *p;
}

int writeEEPROM(int address)
{
	_prog_addressT EE_addr;
  	_init_prog_address(EE_addr, arrayInDataEEPROM);
	EE_addr+=(address<<1);
	disableAllInterrupts();
	_erase_eedata(EE_addr, _EE_ROW);
	_wait_eedata();
    _write_eedata_row(EE_addr, (int *)&spectrum[0]);
	_wait_eedata();
	enableAllInterrupts();
	return readEEPROM(address);
}

int readEEPROMInt(int address)
{
	return readEEPROM(address);
}

int writeEEPROMInt(int address, int data)
{
	int *p;
	int a;

	a=0xFFFFFFF0 & address;
	readEEPROM(a);
	p=(int *)&spectrum[0];
	p+=(address & 0x000F);
	*p=data;
	writeEEPROM(a);
	return data;
}

void resetEEPROMAddressForGet(int addr)
{
	EPaddress=addr;
	EPbuffer=0;
}

void resetEEPROMAddressForPut(int addr)
{
	EPaddress=addr;
	EPbuffer=16;
	readEEPROM(EPaddress);
}

unsigned int getNextEEPROMInt(void)
{
	unsigned int *p;
	if(EPbuffer<=0)
	{
	readEEPROM(EPaddress);
	EPaddress+=16;
	EPbuffer=16;
	}
	EPbuffer--;
	p=(unsigned int*)&spectrum[0];
	p+=EPbuffer;
	return (*p);
}

void putNextEEPROMInt(unsigned int c)
{
	unsigned int *p;
	
	if(EPbuffer<=0)
	{
	writeEEPROM(EPaddress);
	EPaddress+=16;
	EPbuffer=16;
	}
	EPbuffer--;
	p=(unsigned int*)&spectrum[0];
	p+=EPbuffer;
	*p=c;
}

void ClosePut(void)
{
	while(EPbuffer!=15)putNextEEPROMInt(0);
}

//*****************************************************************************
// LED Dot Matrix Display Drivers
//*****************************************************************************
const unsigned int barConvert[] __attribute__((space(auto_psv), aligned(2)))=
        {  0x0000,0x0001,0x0003,0x0007,0x000F,0x001F,0x003F,0x007F,0x00FF,0x01FF,0x03FF,0x07FF,0x0FFF,0x1FFF,0x3FFF,0x7FFF	};

int convertToBar(unsigned int xx, int bits)
{
		// xx is a value from 0x0000 to 0xFFFF
		// gets converted to a bar value from 0x00 to 0x7F
		unsigned long u;
		int i;

		u=(unsigned long)xx;
		if(bits<4)bits=4; else if(bits>16)bits=16;
		u=(u<<4);
		u=(u>>bits);
		if((u>=0)&&(u<=15))i=u; else if(u<0)i=0; else if(u>15)i=15;		
		return barConvert[i];
}

void putXY(int xx, int yy)
{
	if((xx>=0)&&(xx<DISPLAY_COLUMNS)&&(yy>=0)&&(yy<DISPLAY_ROWS)){
		display[xx]^=(1<<yy);
	}
}

void putoXY(int xx, int yy)
{
	if((xx>=0)&&(xx<DISPLAY_COLUMNS)&&(yy>=0)&&(yy < DISPLAY_ROWS)){
		oldisplay[xx]^=(1<<yy);
	}
}

int getXY(int xx, int yy)
{
	if((xx>=0)&&(xx<DISPLAY_COLUMNS)&&(yy>=0)&&(yy<DISPLAY_ROWS)){
		if((display[xx]&(1<<yy))==0)return 0; else return 1;
	} else return 0;
}

void sendcolumn(unsigned int c)
{
	unsigned int i;
	while(cursor>(DISPLAY_COLUMNS-1)){
		BlankScreen();
		for(i=0;i<DISPLAY_COLUMNS-1;i++){
			display[i]=display[i+1];		// shift left...
			}
		UnBlankScreen();
		DelayMsInt(SCROLL_DELAY);
		cursor--;
		}
	if(cursor>=0){ display[cursor]&=0xFF00; display[cursor++]|=(0x00FF & c); } else cursor++;
}

void printcharDots(int ptr, int font, int maxcols, int mode)
{
	int i, m;
	unsigned char c;

		m=cursor;
		if(ptr<0)ptr=FULL_BYTE+ptr;
		if(font==BIG_FONT){ 
			clip(&ptr, BIG_FONT_MIN, BIG_FONT_MAX);
			ptr-=BIG_FONT_MIN;
			i=6; 
			}
			else 
			{ 
			clip(&ptr, SMALL_FONT_MIN, SMALL_FONT_MAX);
			ptr-=SMALL_FONT_MIN;
			i=4;
			}
		ptr=__builtin_muluu(ptr, i);
		i--;
		while(((maxcols!=0)&&(m<maxcols)&&(i>=0))||((maxcols==0)&&(i>=0)))
		{
		switch(mode){
				//case TO_FLASHING:
				//	if((m<DISPLAY_COLUMNS)&&(m>=0)){ 
				//		if(font==BIG_FONT)flashing[m]=BigFont[i+ptr]; else flashing[m]=SmallFont[i+ptr];
				//	}
				//	break;
				case TO_SCREEN:
				default:
					if(font==BIG_FONT)c=(BigFont[i+ptr]); else c=(SmallFont[i+ptr]);
					if((c & CHAR_BLANKING)==0)sendcolumn(c);
					break;
		}
		i--; 
		m++;
		}
}

void clearUpTo(int start, int limit)
{
	BlankScreen();
	while((start<limit)&&(start<DISPLAY_COLUMNS))
	{
	display[start++]=DISPLAY_OFF;
	//flashing[start++]=FLASH_OFF;
	}
	UnBlankScreen();
}

void printstringDots(char *p, int font, int maxcols)
{
// with horizontal scrolling... up to maxcols columns output if maxcols=0 just print out till the end...
	while((*p)!=0)printcharDots(*p++, font, maxcols, TO_SCREEN);
}

void printflashingDots(char *p, int font, int fromcol, int tocol, unsigned int upshift)
{
	updownShift=upshift;
	if((*p)!=0)cursor=fromcol;
	while((*p)!=0)printcharDots(*p++, font, tocol, TO_FLASHING);
}

int printITOA(unsigned int xx, int blanking, int decimal, int mode)
{
		// unsigned integers from 0 to 65535
		// blanking=0 implies zero blanking
		// decimal=   number of digits before the decimal to be printed if 0 then do not print a decimal point (blanking stops after the decimal)
		int i, j;
		unsigned long ux;
		char c;
		
		ux=(unsigned long)xx;
		j=NUM_DIGITS;
		for(i=NUM_DIGITS-1; i>=0; i--)
		{
		c=(char)(0x0030+(0x000F&(__builtin_modud((unsigned long)ux,10))));
		ux=(unsigned long)__builtin_divud(ux,10);
		if((j+1)==decimal){ buffer[j--]='.'; }
		buffer[j--]=c;
		}
		buffer[NUM_DIGITS+1]=0;
		j=j+1;
		if(blanking==0)while((buffer[j]==0x30)&&(j<NUM_DIGITS))j++;
		if(mode==0)if((j>0)&&(buffer[j]=='.'))j--;
		return j;
}

void disWDotsdecimal(unsigned int xx, int font, int blanking)
{
		int i;
		i=printITOA(xx, blanking, 0, font);
		printstringDots(&buffer[i], font, 0);
}

void disWDotsdecimalLimited(unsigned int xx, int font, int blanking, int maxcols)
{
		int i;
		i=printITOA(xx, blanking, 0, font);
		printstringDots(&buffer[i], font, maxcols);
}

void disWDotsdecimalSigned(int xx, int font, int blanking)
{
	char c[2];
	if(xx<0){ c[0]='-'; xx=-xx; } else c[0]='+';
	c[1]=0x00;
	printstringDots(&c[0],font, 0);
	disWDotsdecimal((unsigned int)xx, font, blanking);
}

const DOUBLE MultiplierF[6] __attribute__((space(auto_psv), aligned(2)))={ 1.0, 10.0, 100.0, 1000.0, 10000.0, 100000.0 };

int printFDecimalNoRounding(DOUBLE f, int numdec, int mode)
{
		clip(&numdec, 0, NUM_DIGITS);
		f=f * MultiplierF[numdec];
		return printITOA(f, 0, (NUM_DIGITS+1)-numdec, mode);
}

int printFDecimal(DOUBLE f, int numdec, int mode)
{
		clip(&numdec, 0, NUM_DIGITS);
		f=0.5 + f * MultiplierF[numdec];
		return printITOA(f, 0, (NUM_DIGITS+1)-numdec, mode);
}

int numberOfDecimalDigits(DOUBLE xx)
{
	// returns the number of decimal digits to print xx (0-65535)
	if(xx==0.0)return 0;
	else if(xx<10.0)return 1; 
	else if(xx<100.0)return 2; 
	else if(xx<1000.0)return 3; 
	else if(xx<10000.0)return 4; 
	else if(xx<100000.0)return 5;
	else if(xx<1000000.0)return 6;
	else return 7;
}

char convertToUnit(int exp)
{
	if(exp==0)return ' '; else if(exp==3)return 'K'; else if(exp==6)return 'M'; else if(exp==9)return 'G'; else return '.';
}

int printEngineering(DOUBLE f, int totaldigits, int* p, unsigned char extrachar, int mode)
{
		// displays a frequency in totaldigits digits space
		// makes the necessary unit conversions
		// unsigned integers from 0 to 65535
		// totaldigits=1 (for decimal point) + numdec + mantissa digits...
		// mode=0 include the unit mode=1 do not include the unit
		int i, e;

		clip(&totaldigits, 0, NUM_DIGITS+1);
		i=totaldigits-numberOfDecimalDigits(f)-2+mode;	// mode-2 is for the decimal point and unit
		e=0;
		while(i<0){
			f=f/10.0; 
			i++; 
			e++;
		}
		// now i is the number of decimals to request and e is the exponent
		// but we need to keep going with the exponent until it is a multiple of 3!
		while((__builtin_modud(e, 3))!=0)
		{
			f=f/10.0;
			e++;
			i++;
		}
		if(f<1.0){ e-=3; i-=3; f=f*1000.0; }
		*p=e;
		i=printFDecimalNoRounding(f, i, 0);
		if(e!=0){
			if(mode==0)
			{ 	buffer[NUM_DIGITS+1]=convertToUnit(e);
				buffer[NUM_DIGITS+2]=0;
			} else 
			{
				buffer[NUM_DIGITS+1]=0;
			}
		} else {
			if(i>0){
				i--;
				buffer[i]=extrachar;
				}
				buffer[NUM_DIGITS+1]=0;		
		}
		return i;
}

int disEngineering(DOUBLE ff, int totaldigits, int font, int maxcols, unsigned char extrachar, int mode)
{
	int i, j;
	// mode=0 include unit, mode=1 do not include unit
	if(ff!=0.0)
	{ 
		i=printEngineering(ff, totaldigits, &j, extrachar, mode);
		printstringDots(&buffer[i], font, maxcols);
		clearUpTo(cursor, maxcols);
	} else
	{
	j=0;
	buffer[j++]=extrachar;
	while(j<totaldigits)
	{
	buffer[j++]='0';
	}
	buffer[j]=0;
	printstringDots(&buffer[0], font, maxcols);
	}
	return TRUE;
}

void disFDotsdecimal(DOUBLE f, int numdec, int font, int maxcols)
{
	int i;
	i=printFDecimal(f, numdec, font);
	printstringDots(&buffer[i], font, maxcols);
}

void disFUart(DOUBLE f, int numdec)
{
		int i;
		i=printFDecimal(f, numdec, 0);
		printstringUart(&buffer[i]);
}


void disFDotsdecimalSigned(DOUBLE f, int numdec, int font, int maxcols)
{
	if(f<0.0){	printstringDots("-",font,maxcols); f=-f; } else printstringDots("+",font,maxcols);
	disFDotsdecimal(f, numdec, font, maxcols);
}

char dispFix(int g)
{
		g&=0x000F;
		if(g>9)g+=0x0007;
		g+=0x0030;
		return g;
}

void disADots(int b, int font)
{
	char str[3];
	str[0]=dispFix(b>>4);
	str[1]=dispFix(b);
	str[2]=0;
	printstringDots(&str[0], font, 0);
}

void disWDots(int xx, int font)
{
		disADots(xx>>8, font);
		disADots(xx, font);
}

/*
void loadShiftRegister(unsigned int b, int colnum)
{
	int i;
	unsigned int t;

	t=b;
	PORTEbits.GBIT=1;		// G enable off...
	FOUR_NOPS;
	PORTEbits.CK1BIT=1;		// CK (rows)=1
	FOUR_NOPS;
	PORTEbits.CK2BIT=1;		// CK (cols)=1
	FOUR_NOPS;
if(colnum==0){
		PORTEbits.RE0=0;
		FOUR_NOPS;
		PORTEbits.CK2BIT=0;
		FOUR_NOPS;
		PORTEbits.CK2BIT=1;
		FOUR_NOPS;
		PORTEbits.RE0=1;
		FOUR_NOPS;	
		PORTEbits.CK2BIT=0;
		FOUR_NOPS;
		PORTEbits.CK2BIT=1;
		FOUR_NOPS;
	}
	else
	{
		PORTEbits.RE0=1;
		FOUR_NOPS;
		PORTEbits.CK2BIT=0;
		FOUR_NOPS;
		PORTEbits.CK2BIT=1;
		FOUR_NOPS;
	}
	for(i=0; i<8; i++)
	{
	if ((t & 0x0080)==0)
		{
		PORTEbits.RE0=0;
		} else
		{
		PORTEbits.RE0=1;
		}
		FOUR_NOPS;
		PORTEbits.CK1BIT=0;		// clock
		FOUR_NOPS;
		PORTEbits.CK1BIT=1;		// clock
		FOUR_NOPS;
		t=t<<1;
		}
		FOUR_NOPS;
		PORTEbits.CK1BIT=0;		// clock
		FOUR_NOPS;
		PORTEbits.CK1BIT=1;		// clock
		FOUR_NOPS;
	if(displayEnable==ONENABLE)PORTEbits.GBIT=0;
}
*/

//void flashSet(unsigned int var)
//{
//	int i;
//
//	BlankScreen();
//	for(i=0; i<DISPLAY_COLUMNS; i++)flashing[i]=var;
//	UnBlankScreen();
//}

void clearDisplay(int y)
{
	int i;
	BlankScreen();
	for(i=0;i<DISPLAY_COLUMNS;i++)
	{
	display[i]=y;
	//flashing[i]=FLASH_OFF;
	}
	cursor=0;
	UnBlankScreen();
}

void clearDisplayScrolling(void)
{
	int i;
	
	for(i=0; i<DISPLAY_COLUMNS; i++)display[i]&=0x007F;
	for(i=0; i<8; i++){ DelayMsInt(UPDOWN_DELAY); updownShift--; }
	clearDisplay(DISPLAY_OFF);
}

void setScreenParameters(int bright, int freqq)
{
	// Sets the brightness bright=0 (least) 0xFF (most)
	// Sets the screen refresh close to freqq (Hz)
	// the screen Frequency is = 1/ (16*period16) , where:
	// period16= timeon + timeoff				, where:
	// timeon= T3PRESCALE * screenPeriodOn / fcy    , and:
	// timeoff= T3PRESCALE * screenPeriodOff /fcy   , so:
	// p16= T3PRESCALE*(SON+SOFF)/fcy=1/(16freqq)   , so:
	// SON+SOFF= (fcy/16freqq)/T3PRESCALE
	DOUBLE f, p16;
	
	clip(&bright, 0, 255);
	clip(&freqq,  0, 255);	
	screenFrequency=freqq;
	screenBrightness=bright;
	f=(DOUBLE)freqq/255.0;
	f=(SCREEN_FREQ_MIN + f*(SCREEN_FREQ_MAX-SCREEN_FREQ_MIN));
	freqq=(int)f;
	clip(&freqq, (int)SCREEN_FREQ_MIN, (int)SCREEN_FREQ_MAX);
	p16=(((fcy/T3PRESCALE)/(DISPLAY_COLUMNS+1))/(DOUBLE)freqq)-SCREEN_ON_MIN-SCREEN_OFF_MIN;			// p16 is the total son + soff for the periods
	f=(DOUBLE)bright;
	f=f/255.0;
	f=f*p16;
	screenPeriodOn=SCREEN_ON_MIN+f;
	screenPeriodOff=SCREEN_OFF_MIN+p16-f;
}

void displayBar(int xx, int mod)
{
	int i, j, k;
	k=0x000F & (rawPotValue>>6);
	updownShift=0;
	clip(&xx, 0, 255);
	j=0x000F &(xx>>4);
	display[0]=0x003E;
	for(i=1; i<15; i++){
		if(i>j)display[i]=0x0014; else if(i<j)display[i]=0x001C; else display[i]=0x3E;
	}
	if(mod==0)
	{	if(k<15)display[k]|=0x0060;
		if((k-1)>=0)display[k-1]|=0x0040;	
		if((k+1)<15)display[k+1]|=0x0040;
		if(k<15)display[k]|=0x0040;
	}
	display[14]=0x3E;
}

/*
void displayThreeFlashing(char *p1, char* p2, char* p3, int sel)
{
		flashSet(FLASH_OFF);
		if(sel==0)
		{
		flashing[0]=0;
		printflashingDots(p1, 1, 1, DISPLAY_COLUMNS, 1);
		}
		else if(sel==1)
		{
		flashing[5]=0;
		printflashingDots(p2, 1, 6, DISPLAY_COLUMNS, 1);
		} else if(sel==2)
		{
		flashing[10]=0;
		printflashingDots(p3, 1, 11, DISPLAY_COLUMNS, 1);
		}
}

void flashColumns(int start, int end)
{
	int i;
	for(i=0; i<DISPLAY_COLUMNS; i++)
		{
		if((i>=start)&&(i<=end))
		{
		flashing[i]=FLASH_ON;
		} else flashing[i]=FLASH_OFF;
		}
}

void displayThreeBars(int cm, int cl, int cr, int bits)
{
	BlankScreen();
	display[0]=convertToBar(cm, bits);
	display[1]=display[0];
	display[2]=display[0];
	display[3]=display[0];
	display[4]=display[0];
	display[5]=convertToBar(cl, bits);
	display[6]=display[5];
	display[7]=display[5];
	display[8]=display[5];
	display[9]=display[5];
	display[10]=convertToBar(cr, bits);
	display[11]=display[10];
	display[12]=display[10];
	display[13]=display[10];
	display[14]=display[10];
	UnBlankScreen();
}
*/

void shiftUpLine(void)
{
	int i;

	BlankScreen();
	for(i=0; i<DISPLAY_COLUMNS;i++){
		display[i]=display[i]<<8;
		display[i]&=0xFF00;
	}
	UnBlankScreen();
}

void initDisplay(void)
{
	screenFrequency=SCREEN_FREQ_DEFAULT;
	screenBrightness=SCREEN_BRIGHTNESS;
	stateSetDisplayDefaults(0);
	displayEnable|=DENABLE;
	UnBlankScreen();
	clearDisplay(DISPLAY_OFF);
	displayIndex=0;
	updownShift=0;
	// first set up Timer 3
	TMR3=0x0000;			// clear T3
	PR3=0x0001;				// the period (safe)
	setScreenParameters(screenBrightness, screenFrequency);
	T3CON=0x8030;			// control register setup to run off system clock at frequency FCY divided by 256 prescaler
	// and now enable the interrupt!
	IFS0bits.T3IF=0;
	IPC1|=(T3IPRI << 12); 	// select priority 5 for T3 interrupt
	IEC0bits.T3IE=1;		// enable T3 Interrupt!
}

//*****************************************************************************
// Keys pressed FIFO functions
//*****************************************************************************
#if (REMOTE_CONTROL==0)

void addKey(int xx, int analog_pot_mode)
{
	if((xx<=MAXKEY)&&(xx>=MINKEY)){ 
		if(keyFull<KEY_BUFFER_SIZE){
			keyBuffer[keyPtr]=(char)xx;
			keyPtr++;
			if(keyPtr>=KEY_BUFFER_SIZE)keyPtr=0;
			keyFull++;
			lastTimeAdded[xx]=intMasterTimer;
		}
	}
	analogPotMode=0;
}
#else

void addKey(int xx, int analog_pot_mode)
{
	if((xx<=MAXKEY)&&(xx>=MINKEY)){ 
		if(keyFull<KEY_BUFFER_SIZE){
			keyBuffer[keyPtr]=(char)xx;
			keyPtr++;
			if(keyPtr>=KEY_BUFFER_SIZE)keyPtr=0;
			keyFull++;
			lastTimeAdded[xx]=intMasterTimer;
		}
	} 
	else
	{ 
		if(xx==KEYUP){
			if(analogPotMode==0){ digitalPot=avgPotValue; analogPotMode=1; }
			if(digitalPot<=(0x03FF-DIGITAL_POT_DELTA))digitalPot+=DIGITAL_POT_DELTA; else if(digitalPot<0x03FF)digitalPot++;
		} else
		if(xx==KEYDOWN){
			if(analogPotMode==0){ digitalPot=avgPotValue; analogPotMode=1; }
			if(digitalPot>=DIGITAL_POT_DELTA)digitalPot-=DIGITAL_POT_DELTA; else if(digitalPot>0)digitalPot--;
		}
	}
}
#endif
//*****************************************************************************
// Crucial Hardware Access Functions including Interrupts
//*****************************************************************************
void waitForUpdated(int mm)
{
	setTimeOut(WAIT_FOR_UPDATED_TIMEOUT);
	freqObj[mm].updated=0;
	while((!timeOut())&&(freqObj[mm].updated==0))wait();
}

void updateFreqObj(int mm)
{
	DOUBLE f, g, h;
	
	f=freqObj[mm].period[2]-freqObj[mm].period[0];
	if(f<0.0)f=-f;
	if(f>1.0){
		g=freqObj[mm].period[2]-freqObj[mm].period[1];
		h=(100.0*g)/f;
		f=(fcy/(f*T1PRESCALE));
		freqObj[mm].freq=(freqObj[mm].freq+f)/2.0;
		freqObj[mm].duty=(freqObj[mm].duty+h)/2.0;
		freqObj[mm].posperiod=(freqObj[mm].posperiod+((1000.0*T1PRESCALE*g)/fcy))/2.0;
		freqObj[mm].updated=1;
		 }
	freqObj[mm].freqIndex=0;
}

void toggleLED(int mm)
{
	int u, c;
	c=(freqObj[mm].freqIndex & 0x0003);
	freqObj[mm].freqIndex++;
	if(mm==rf6Mode){ u=PORTF; PORTF=(u^0x40); }
	freqObj[mm].period[c]=TMR1;
	if(freqObj[mm].freqIndex >= FREQ_DELAY)updateFreqObj(mm);
}

void resetScreenSaver(void)
{
	intScreenTimer=screenTimeOut;
	if((displayEnable & DENABLE)==0)
	{ 
	displayEnable|=DENABLE; 
	setTimeOut(0); 
	}
}

void __attribute__((interrupt,auto_psv)) _T5Interrupt(void)
{
	intMasterTimer++;
	if(silenceCounter>0)silenceCounter--;
	if(intCountDownTimer>0)intCountDownTimer--;
	if(intScreenTimer>0)intScreenTimer--; else { displayEnable&=~DENABLE; }
	if(ledOnTimer>0)ledOnTimer--;
	if(screenOnTimer>0)screenOnTimer--;
	if(chaserTimeOut>0)chaserTimeOut--;
	if(ledOnTimer<=0){
		if(ledOnTime==0){
			ledOnTimer=LED_ON_TIMEOUT;
			ledOnTime=1;
		} else
		{
			ledOnTimer=LED_OFF_TIMEOUT;
			ledOnTime=0;
		}			
	}
	if(screenOnTimer<=0){
		if(screenOnTime==0){
			screenOnTimer=screenOnTimeout;
			screenOnTime=1;
		} else
		{
			screenOnTimer=screenOffTimeout;
			screenOnTime=0;
		}			
	}
	TMR5=0;						// NB: Timer 5 is not critical but around 100ms intervals.
	IFS1bits.T5IF=0;
}

#if (REMOTE_CONTROL!=0)
	// this is used for the remote control
void __attribute__((interrupt,auto_psv)) _T4Interrupt(void)
{
		int i, j;
		if(outputTimer>0)outputTimer--;
		if(ir_rdy!=0)
		{	
			i=translateIRCode(ir_code);
			if((i>=MINKEY)&&(i<=MAXKEY))j=intMasterTimer-lastTimeAdded[i]; else j=KEY_HOLD_TIME;
			if(j<0)j=j+FULL_INT;
			if(j>=KEY_HOLD_TIME){
						if((displayEnable & DENABLE)!=0)addKey(i, 1);
						resetScreenSaver();
						}
			TMR4=0;
			ir_rdy=0;
		} else if(rf6Mode==INPUT_REMOTE)ir_receive();
		IFS1bits.T4IF=0;
}
#endif

void __attribute__((interrupt,auto_psv)) _T3Interrupt(void)
{
	// this interrupt is used to refresh the display
	int i; 
	unsigned int u, v;

	displayIndex=displayIndex & 0x001F;
	if(displayIndex==0)toggleLED(SCREEN_REFRESH); 

	if((displayIndex & 0x0001)==0){
			v=displayIndex>>1;
			if(v<DISPLAY_COLUMNS){	
				if(updownShift!=0){
						if(updownShift>0)u=(display[v]<<updownShift); else u=(display[v]>>(-updownShift));
				}
			else
			{
			//if(screenOnTime==0)u=(~(flashing[v]>>8)&flashing[v])|((flashing[v]>>8)&display[v]);	else u=display[v];
			u=display[v];
			} 
		} else	{	
	if(ledOnTime==0)u=LEDS & ~FLASHING; else u=LEDS;	}
	//loadShiftRegister(u, v);
		PORTEbits.GBIT=1;		// G enable off...
		FOUR_NOPS;
		PORTEbits.CK1BIT=1;		// CK (rows)=1
		FOUR_NOPS;
		PORTEbits.CK2BIT=1;		// CK (cols)=1
		FOUR_NOPS;
		if(v==0){
			PORTEbits.RE0=0;
			FOUR_NOPS;
			PORTEbits.CK2BIT=0;
			FOUR_NOPS;
			PORTEbits.CK2BIT=1;
			FOUR_NOPS;
			PORTEbits.RE0=1;
			FOUR_NOPS;	
			PORTEbits.CK2BIT=0;
			FOUR_NOPS;
			PORTEbits.CK2BIT=1;
			FOUR_NOPS;
			}
			else
			{
			PORTEbits.RE0=1;
			FOUR_NOPS;
			PORTEbits.CK2BIT=0;
			FOUR_NOPS;
			PORTEbits.CK2BIT=1;
			FOUR_NOPS;
			}
		for(i=0; i<8; i++)
		{
		if ((u & 0x0080)==0)
			{
			PORTEbits.RE0=0;
			} else
			{
			PORTEbits.RE0=1;
			}
			FOUR_NOPS;
			PORTEbits.CK1BIT=0;		// clock
			FOUR_NOPS;
			PORTEbits.CK1BIT=1;		// clock
			FOUR_NOPS;
			u=u<<1;
			}
			FOUR_NOPS;
			PORTEbits.CK1BIT=0;		// clock
			FOUR_NOPS;
			PORTEbits.CK1BIT=1;		// clock
			FOUR_NOPS;
	if(displayIndex==0x001E)
		{ 
		PR3=LED_ON_PERIOD; 
		if((displayEnable & DENABLE)!=0)PORTEbits.GBIT=0;
		}
		else 
		{
		PR3=screenPeriodOn; 		// screen brightness does not affect the LEDS!
		if((displayEnable & MENABLE)!=0)PORTEbits.GBIT=0;
		}
	}
	else
	{ 						
	// otherwise we are in a dead time!
	if(displayIndex==0x001F)PR3=SCREEN_OFF_MIN; else PR3=screenPeriodOff; 	// screen brightness does not affect the LEDS!
	PORTEbits.GBIT=1;		// G enable off
	}
	displayIndex++;
	displayIndex=displayIndex & 0x001F;
	TMR3=0x0000;
	IFS0bits.T3IF=0;
	// done!	
}

void __attribute__((interrupt,auto_psv)) _OC1Interrupt(void)
{

	toggleLED(OC1_TRIGGER);
	ocTrigger|=(0x0011 & phaseMask);
	IFS0bits.OC1IF=0;
}

void __attribute__((interrupt,auto_psv)) _OC2Interrupt(void)
{
	
	//toggleLED(OC2_TRIGGER);
	ocTrigger|=(0x0022 & phaseMask);
	IFS0bits.OC2IF=0;
}

void __attribute__((interrupt,auto_psv)) _OC3Interrupt(void)
{
	
	//toggleLED(OC3_TRIGGER);
	ocTrigger|=(0x0044 & phaseMask);
	IFS1bits.OC3IF=0;
}

void __attribute__((interrupt,auto_psv)) _OC4Interrupt(void)
{
	//toggleLED(OC4_TRIGGER);
	ocTrigger|=(0x0088 & phaseMask);
	IFS1bits.OC4IF=0;
}

void __attribute__((interrupt,auto_psv)) _INT0Interrupt(void)
{
// this is the external INT0 interrupt service routine used
// to synchronise with the mains...
// it is called approximately every time there is a zero crossing, ie. at 100/120 Hz frequency
// used to synchronise TMR2 with the mains waveform
	int i;

	toggleLED(MAINS_SYNC);
	i=INTCON2;
	INTCON2=i^0x0001;								// toggle trigger edge polarity
	i=(i & 0x0001);									// i indicates half cycle index now
	if(i==0){
		if(phase0<PHASE0_MIN)phase0=PHASE0_MIN;
		if(phase0>PHASE0_MAX)phase0=PHASE0_MAX;
		if(phase0>=0)phaseOffset[1]=(T2PERIOD_DEFAULT-phase0); else phaseOffset[1]=-phase0;
		phaseMask=PHASE0_MASK;
		maxBuffer[1]+=TMR2-pulseError[1];
		TMR2=phaseOffset[1];
		maxBuffer[1]=maxBuffer[1]>>1;
		phase=0;
	}
	else
	{
		if(phase1<PHASE1_MIN)phase1=PHASE1_MIN;
		if(phase1>PHASE1_MAX)phase1=PHASE1_MAX;
		if(phase1>=0)phaseOffset[0]=(T2PERIOD_DEFAULT-phase1); else phaseOffset[0]=-phase1;
		phaseMask=PHASE1_MASK;
		maxBuffer[0]+=TMR2-pulseError[0];
		TMR2=phaseOffset[0];
		maxBuffer[0]=maxBuffer[0]>>1;
		phase=1;
		
	}
	IFS0bits.INT0IF=0;
}

void __attribute__((interrupt,auto_psv)) _T2Interrupt(void)
{
	// this is called when TMR2 expires or is reset to 0
	int val;

	ocTrigger&=(~phaseMask);
	if((outputEnable & phaseMask & 0x0011)!=0){

		if((ch[(unsigned int)channelPermutation[0]].mode & (DIRECT_MODE | CONTINUOUS_MODE))!=0){

			if((ch[(unsigned int)channelPermutation[0]].outputChannel[phase])<ch[(unsigned int)channelPermutation[0]].quiescentCurrent)val=(ch[(unsigned int)channelPermutation[0]].outputChannel[phase]); else val=ch[(unsigned int)channelPermutation[0]].quiescentCurrent;
			if(val>=maxBuffer[phase]){ 	val=val-maxBuffer[phase]+phaseOffset[phase];
										if((val+pulseError[phase])>(T2PERIOD_DEFAULT-pulseError[phase]))val=T2PERIOD_DEFAULT+1;
							  		 }
			if((ch[(unsigned int)channelPermutation[0]].mode & ZV_MODE)==0)OC1R=val; else { if(val>zvThreshold)OC1R=ZV_OFF; else OC1R=ZV_ON; }
			OC1RS=OC1R+PULSE_WIDTH;
		
		} else if((ch[(unsigned int)channelPermutation[0]].mode & STROBE_MODE)!=0)
		{
		// here we are in strobe mode for this channel
		if(ch[(unsigned int)channelPermutation[0]].counter<=0){ 
								ch[(unsigned int)channelPermutation[0]].counter=ch[(unsigned int)channelPermutation[0]].strobe & 0x3FFF;
								ch[(unsigned int)channelPermutation[0]].strobe=ch[(unsigned int)channelPermutation[0]].strobe ^ 0x8000;	
								if((ch[(unsigned int)channelPermutation[0]].strobe & 0xC000)==0x8000)
								{
								OC1R=PHASE_STROBE;
								OC1RS=OC1R+PULSE_WIDTH;
								} else 
								{
								OC1R=T2PERIOD_DEFAULT+1;
								OC1RS=OC1R+1;
								}
							} else ch[(unsigned int)channelPermutation[0]].counter--;

		} else
		{
			OC1R=T2PERIOD_DEFAULT+1;
			OC1RS=OC1R+1;
		}
	} else
	{
	OC1R=T2PERIOD_DEFAULT+1;
	OC1RS=OC1R+1;
	}

	if((outputEnable & phaseMask & 0x0022)!=0){

		if((ch[(unsigned int)channelPermutation[1]].mode & (DIRECT_MODE | CONTINUOUS_MODE))!=0){

			if((ch[(unsigned int)channelPermutation[1]].outputChannel[phase])<ch[(unsigned int)channelPermutation[1]].quiescentCurrent)val=(ch[(unsigned int)channelPermutation[1]].outputChannel[phase]); else val=ch[(unsigned int)channelPermutation[1]].quiescentCurrent;
			if(val>=maxBuffer[phase]){ 	val=val-maxBuffer[phase]+phaseOffset[phase];
										if((val+pulseError[phase])>(T2PERIOD_DEFAULT-pulseError[phase]))val=T2PERIOD_DEFAULT+1;
							  		 }
			if((ch[(unsigned int)channelPermutation[1]].mode & ZV_MODE)==0)OC2R=val; else { if(val>zvThreshold)OC2R=ZV_OFF; else OC2R=ZV_ON; }
			OC2RS=OC2R+PULSE_WIDTH;
		
		} else if((ch[(unsigned int)channelPermutation[1]].mode & STROBE_MODE)!=0) 
		{
		// here we are in strobe mode for this channel
		if(ch[(unsigned int)channelPermutation[1]].counter<=0){ 
								ch[(unsigned int)channelPermutation[1]].counter=ch[(unsigned int)channelPermutation[1]].strobe & 0x3FFF;
								ch[(unsigned int)channelPermutation[1]].strobe=ch[(unsigned int)channelPermutation[1]].strobe ^ 0x8000;	
								if((ch[(unsigned int)channelPermutation[1]].strobe & 0xC000)==0x8000)
								{
								OC2R=PHASE_STROBE;
								OC2RS=OC2R+PULSE_WIDTH;
								} else 
								{
								OC2R=T2PERIOD_DEFAULT+1;
								OC2RS=OC2R+1;
								}
						} else ch[(unsigned int)channelPermutation[1]].counter--;
		} else 
		{
			OC2R=T2PERIOD_DEFAULT+1;
			OC2RS=OC2R+1;
		}
	} else
	{
	OC2R=T2PERIOD_DEFAULT+1;
	OC2RS=OC2R+1;
	}

	if((outputEnable & phaseMask & 0x0044)!=0){

		if((ch[(unsigned int)channelPermutation[2]].mode & (DIRECT_MODE | CONTINUOUS_MODE))!=0){

			if((ch[(unsigned int)channelPermutation[2]].outputChannel[phase])<ch[(unsigned int)channelPermutation[2]].quiescentCurrent)val=(ch[(unsigned int)channelPermutation[2]].outputChannel[phase]); else val=ch[(unsigned int)channelPermutation[2]].quiescentCurrent;
			if(val>=maxBuffer[phase]){ 	val=val-maxBuffer[phase]+phaseOffset[phase];
										if((val+pulseError[phase])>(T2PERIOD_DEFAULT-pulseError[phase]))val=T2PERIOD_DEFAULT+1;
							  		 }
			if((ch[(unsigned int)channelPermutation[2]].mode & ZV_MODE)==0)OC3R=val; else { if(val>zvThreshold)OC3R=ZV_OFF; else OC3R=ZV_ON; }
			OC3RS=OC3R+PULSE_WIDTH;
		
		} else if((ch[(unsigned int)channelPermutation[2]].mode & STROBE_MODE)!=0)
		{
		// here we are in strobe mode for this channel
		if(ch[(unsigned int)channelPermutation[2]].counter<=0){ 
								ch[(unsigned int)channelPermutation[2]].counter=ch[(unsigned int)channelPermutation[2]].strobe & 0x3FFF;
								ch[(unsigned int)channelPermutation[2]].strobe=ch[(unsigned int)channelPermutation[2]].strobe ^ 0x8000;	
								if((ch[(unsigned int)channelPermutation[2]].strobe & 0xC000)==0x8000)
								{
								OC3R=PHASE_STROBE;
								OC3RS=OC3R+PULSE_WIDTH;
								} else 
								{
								OC3R=T2PERIOD_DEFAULT+1;
								OC3RS=OC3R+1;
								}
		
						} else ch[(unsigned int)channelPermutation[2]].counter--;
		} else {
					OC3R=T2PERIOD_DEFAULT+1;
					OC3RS=OC3R+1;
		}
	} else
	{
	OC3R=T2PERIOD_DEFAULT+1;
	OC3RS=OC3R+1;
	}

	if((outputEnable & phaseMask & 0x0088)!=0){

		if((ch[(unsigned int)channelPermutation[3]].mode & (DIRECT_MODE | CONTINUOUS_MODE))!=0){

			if((ch[(unsigned int)channelPermutation[3]].outputChannel[phase])<ch[(unsigned int)channelPermutation[3]].quiescentCurrent)val=(ch[(unsigned int)channelPermutation[3]].outputChannel[phase]); else val=ch[(unsigned int)channelPermutation[3]].quiescentCurrent;
			if(val>=maxBuffer[phase]){ 	val=val-maxBuffer[phase]+phaseOffset[phase];
										if((val+pulseError[phase])>(T2PERIOD_DEFAULT-pulseError[phase]))val=T2PERIOD_DEFAULT+1;
							  		 }
			if((ch[(unsigned int)channelPermutation[3]].mode & ZV_MODE)==0)OC4R=val; else { if(val>zvThreshold)OC4R=ZV_OFF; else OC4R=ZV_ON; }
			OC4RS=OC4R+PULSE_WIDTH;
		} else if((ch[(unsigned int)channelPermutation[3]].mode & STROBE_MODE)!=0)
		{
		// here we are in strobe mode for this channel
		if(ch[(unsigned int)channelPermutation[3]].counter<=0){ 
								ch[(unsigned int)channelPermutation[3]].counter=ch[(unsigned int)channelPermutation[3]].strobe & 0x3FFF;
								ch[(unsigned int)channelPermutation[3]].strobe=ch[(unsigned int)channelPermutation[3]].strobe ^ 0x8000;	
								if((ch[(unsigned int)channelPermutation[3]].strobe & 0xC000)==0x8000)
								{
								OC4R=PHASE_STROBE;
								OC4RS=OC4R+PULSE_WIDTH;
								} else 
								{
								OC4R=T2PERIOD_DEFAULT+1;
								OC4RS=OC4R+1;
								}
					} else ch[(unsigned int)channelPermutation[3]].counter--;
		} else {
					OC4R=T2PERIOD_DEFAULT+1;
					OC4RS=OC4R+1;
		}
	} else
	{
	OC4R=T2PERIOD_DEFAULT+1;
	OC4RS=OC4R+1;
	}
	
	OC1CON=0x0004;
	OC2CON=0x0004;
	OC3CON=0x0004;
	OC4CON=0x0004;							// turn on output compare channels to trigger TRIACs!
	IFS0bits.T2IF=0;
	
}

int keyPressed(void)
{
	/// returns the instantenously pressed key- does not take into account remote control inputs as do the other key functions.
	int u, i, k;
	u=PORTB;
	u=(u>>4) & 0x001F;
	i=PORTC;
	if((i&0x8000)!=0)u|=0x20;
	if((i&0x2000)!=0)u|=0x40;
	k=NOKEY;
	for(i=0; i<NUM_KEYS; i++)
	{
	if((u&((int)(1<<i)))==0)k=i;
	}
	return k;
}

void __attribute__((interrupt,auto_psv)) _CNInterrupt(void)
{
// this is the external INT0 interrupt service routine used
// to synchronise with the 50Hz mains...
// it is called every time there is a zero crossing, ie. at 100 Hz frequency
// synchronised with the mains...
	int i, u;
	long j;

	u=PORTB;
	u=(u>>4) & 0x001F;
	i=PORTC;
	if((i&0x8000)!=0)u|=0x20;
	if((i&0x2000)!=0)u|=0x40;
	// u now contains the 7 LSBits of the state of the switches when a change occurred...
	for(i=0; i<NUM_KEYS;i++)
	{
	if((u&((int)(1<<i)))==0){
			// a key has been pressed, so add it to the queue only if the time since last adding is big enough
			j=intMasterTimer-lastTimeAdded[i];
			if(j<0)j=j+FULL_INT;
			if(j>=KEY_HOLD_TIME){ 	
								if((displayEnable & DENABLE)!=0)addKey(i, 0);
								resetScreenSaver();
								}
			}
	}
	IFS0bits.CNIF=0;
}

const int equalizerDefaults[EQUALIZERS] __attribute__((space(auto_psv), aligned(2)))=
{ 1.000000*FIXED_DENOMINATOR, 0.950000*FIXED_DENOMINATOR, 0.900000*FIXED_DENOMINATOR, 0.85000*FIXED_DENOMINATOR, 0.800000*FIXED_DENOMINATOR, 0.75000*FIXED_DENOMINATOR, 0.70000*FIXED_DENOMINATOR, 0.65000*FIXED_DENOMINATOR };

const int equalizerFreqLimits[EQUALIZERS+1] __attribute__((space(auto_psv), aligned(2)))=
			{ 0, 250, 500, 1000, 1500, 2000, 5000, 10000, 30000 };

void initEqualizerDefaults(void)
{
		int i;
		for(i=0; i<EQUALIZERS; i++)equalizerCoefficient[i]=equalizerDefaults[i];
}

int freqToEqualizerIndex(int freqq)
{
	int i, j;

	j=-1;
	i=0;
	while((j<0) && (i<EQUALIZERS))
	{
	if((freqq>=equalizerFreqLimits[i])&&(freqq<equalizerFreqLimits[i+1]))j=i;
	i++;
	}
	if(j>0)return j; else return 0;
}

//*****************************************************************************
// Crucial Phase Control Functions
//*****************************************************************************
#if (USE_DIMMING_CURVE!=0)

const int DimmingCurve[256] __attribute__((space(auto_psv), aligned(2)))=
{ 
  1.000000*FIXED_DENOMINATOR, 0.960185*FIXED_DENOMINATOR, 0.943657*FIXED_DENOMINATOR, 0.930949*FIXED_DENOMINATOR, 0.920214*FIXED_DENOMINATOR, 0.910737*FIXED_DENOMINATOR, 0.902153*FIXED_DENOMINATOR, 0.894243*FIXED_DENOMINATOR, 
  0.886866*FIXED_DENOMINATOR, 0.879923*FIXED_DENOMINATOR, 0.873343*FIXED_DENOMINATOR, 0.867072*FIXED_DENOMINATOR, 0.861068*FIXED_DENOMINATOR, 0.855297*FIXED_DENOMINATOR, 0.849733*FIXED_DENOMINATOR, 0.844353*FIXED_DENOMINATOR, 
  0.839139*FIXED_DENOMINATOR, 0.834075*FIXED_DENOMINATOR, 0.829147*FIXED_DENOMINATOR, 0.824345*FIXED_DENOMINATOR, 0.819657*FIXED_DENOMINATOR, 0.815075*FIXED_DENOMINATOR, 0.810592*FIXED_DENOMINATOR, 0.806200*FIXED_DENOMINATOR, 
  0.801894*FIXED_DENOMINATOR, 0.797667*FIXED_DENOMINATOR, 0.793515*FIXED_DENOMINATOR, 0.789433*FIXED_DENOMINATOR, 0.785418*FIXED_DENOMINATOR, 0.781464*FIXED_DENOMINATOR, 0.777570*FIXED_DENOMINATOR, 0.773732*FIXED_DENOMINATOR, 
  0.769947*FIXED_DENOMINATOR, 0.766212*FIXED_DENOMINATOR, 0.762525*FIXED_DENOMINATOR, 0.758883*FIXED_DENOMINATOR, 0.755285*FIXED_DENOMINATOR, 0.751729*FIXED_DENOMINATOR, 0.748213*FIXED_DENOMINATOR, 0.744734*FIXED_DENOMINATOR, 
  0.741292*FIXED_DENOMINATOR, 0.737885*FIXED_DENOMINATOR, 0.734511*FIXED_DENOMINATOR, 0.731169*FIXED_DENOMINATOR, 0.727858*FIXED_DENOMINATOR, 0.724577*FIXED_DENOMINATOR, 0.721325*FIXED_DENOMINATOR, 0.718100*FIXED_DENOMINATOR, 
  0.714901*FIXED_DENOMINATOR, 0.711728*FIXED_DENOMINATOR, 0.708580*FIXED_DENOMINATOR, 0.705455*FIXED_DENOMINATOR, 0.702353*FIXED_DENOMINATOR, 0.699274*FIXED_DENOMINATOR, 0.696215*FIXED_DENOMINATOR, 0.693178*FIXED_DENOMINATOR, 
  0.690160*FIXED_DENOMINATOR, 0.687162*FIXED_DENOMINATOR, 0.684183*FIXED_DENOMINATOR, 0.681221*FIXED_DENOMINATOR, 0.678278*FIXED_DENOMINATOR, 0.675351*FIXED_DENOMINATOR, 0.672440*FIXED_DENOMINATOR, 0.669546*FIXED_DENOMINATOR, 
  0.666667*FIXED_DENOMINATOR, 0.663803*FIXED_DENOMINATOR, 0.660953*FIXED_DENOMINATOR, 0.658117*FIXED_DENOMINATOR, 0.655295*FIXED_DENOMINATOR, 0.652487*FIXED_DENOMINATOR, 0.649691*FIXED_DENOMINATOR, 0.646907*FIXED_DENOMINATOR, 
  0.644136*FIXED_DENOMINATOR, 0.641376*FIXED_DENOMINATOR, 0.638628*FIXED_DENOMINATOR, 0.635891*FIXED_DENOMINATOR, 0.633164*FIXED_DENOMINATOR, 0.630447*FIXED_DENOMINATOR, 0.627741*FIXED_DENOMINATOR, 0.625044*FIXED_DENOMINATOR, 
  0.622357*FIXED_DENOMINATOR, 0.619679*FIXED_DENOMINATOR, 0.617010*FIXED_DENOMINATOR, 0.614350*FIXED_DENOMINATOR, 0.611697*FIXED_DENOMINATOR, 0.609053*FIXED_DENOMINATOR, 0.606417*FIXED_DENOMINATOR, 0.603788*FIXED_DENOMINATOR, 
  0.601166*FIXED_DENOMINATOR, 0.598552*FIXED_DENOMINATOR, 0.595944*FIXED_DENOMINATOR, 0.593344*FIXED_DENOMINATOR, 0.590749*FIXED_DENOMINATOR, 0.588161*FIXED_DENOMINATOR, 0.585578*FIXED_DENOMINATOR, 0.583002*FIXED_DENOMINATOR, 
  0.580431*FIXED_DENOMINATOR, 0.577865*FIXED_DENOMINATOR, 0.575304*FIXED_DENOMINATOR, 0.572749*FIXED_DENOMINATOR, 0.570198*FIXED_DENOMINATOR, 0.567652*FIXED_DENOMINATOR, 0.565110*FIXED_DENOMINATOR, 0.562572*FIXED_DENOMINATOR, 
  0.560038*FIXED_DENOMINATOR, 0.557509*FIXED_DENOMINATOR, 0.554983*FIXED_DENOMINATOR, 0.552460*FIXED_DENOMINATOR, 0.549941*FIXED_DENOMINATOR, 0.547424*FIXED_DENOMINATOR, 0.544911*FIXED_DENOMINATOR, 0.542401*FIXED_DENOMINATOR, 
  0.539893*FIXED_DENOMINATOR, 0.537388*FIXED_DENOMINATOR, 0.534885*FIXED_DENOMINATOR, 0.532384*FIXED_DENOMINATOR, 0.529885*FIXED_DENOMINATOR, 0.527389*FIXED_DENOMINATOR, 0.524893*FIXED_DENOMINATOR, 0.522400*FIXED_DENOMINATOR, 
  0.519907*FIXED_DENOMINATOR, 0.517416*FIXED_DENOMINATOR, 0.514926*FIXED_DENOMINATOR, 0.512437*FIXED_DENOMINATOR, 0.509949*FIXED_DENOMINATOR, 0.507461*FIXED_DENOMINATOR, 0.504974*FIXED_DENOMINATOR, 0.502487*FIXED_DENOMINATOR, 
  0.500000*FIXED_DENOMINATOR, 0.497513*FIXED_DENOMINATOR, 0.495026*FIXED_DENOMINATOR, 0.492539*FIXED_DENOMINATOR, 0.490051*FIXED_DENOMINATOR, 0.487563*FIXED_DENOMINATOR, 0.485074*FIXED_DENOMINATOR, 0.482584*FIXED_DENOMINATOR, 
  0.480093*FIXED_DENOMINATOR, 0.477600*FIXED_DENOMINATOR, 0.475107*FIXED_DENOMINATOR, 0.472611*FIXED_DENOMINATOR, 0.470115*FIXED_DENOMINATOR, 0.467616*FIXED_DENOMINATOR, 0.465115*FIXED_DENOMINATOR, 0.462612*FIXED_DENOMINATOR, 
  0.460107*FIXED_DENOMINATOR, 0.457599*FIXED_DENOMINATOR, 0.455089*FIXED_DENOMINATOR, 0.452576*FIXED_DENOMINATOR, 0.450059*FIXED_DENOMINATOR, 0.447540*FIXED_DENOMINATOR, 0.445017*FIXED_DENOMINATOR, 0.442491*FIXED_DENOMINATOR, 
  0.439962*FIXED_DENOMINATOR, 0.437428*FIXED_DENOMINATOR, 0.434890*FIXED_DENOMINATOR, 0.432348*FIXED_DENOMINATOR, 0.429802*FIXED_DENOMINATOR, 0.427251*FIXED_DENOMINATOR, 0.424696*FIXED_DENOMINATOR, 0.422135*FIXED_DENOMINATOR, 
  0.419569*FIXED_DENOMINATOR, 0.416998*FIXED_DENOMINATOR, 0.414422*FIXED_DENOMINATOR, 0.411839*FIXED_DENOMINATOR, 0.409251*FIXED_DENOMINATOR, 0.406656*FIXED_DENOMINATOR, 0.404056*FIXED_DENOMINATOR, 0.401448*FIXED_DENOMINATOR, 
  0.398834*FIXED_DENOMINATOR, 0.396212*FIXED_DENOMINATOR, 0.393583*FIXED_DENOMINATOR, 0.390947*FIXED_DENOMINATOR, 0.388303*FIXED_DENOMINATOR, 0.385650*FIXED_DENOMINATOR, 0.382990*FIXED_DENOMINATOR, 0.380321*FIXED_DENOMINATOR, 
  0.377643*FIXED_DENOMINATOR, 0.374956*FIXED_DENOMINATOR, 0.372259*FIXED_DENOMINATOR, 0.369553*FIXED_DENOMINATOR, 0.366836*FIXED_DENOMINATOR, 0.364109*FIXED_DENOMINATOR, 0.361372*FIXED_DENOMINATOR, 0.358624*FIXED_DENOMINATOR, 
  0.355864*FIXED_DENOMINATOR, 0.353093*FIXED_DENOMINATOR, 0.350309*FIXED_DENOMINATOR, 0.347513*FIXED_DENOMINATOR, 0.344705*FIXED_DENOMINATOR, 0.341883*FIXED_DENOMINATOR, 0.339047*FIXED_DENOMINATOR, 0.336197*FIXED_DENOMINATOR, 
  0.333333*FIXED_DENOMINATOR, 0.330454*FIXED_DENOMINATOR, 0.327560*FIXED_DENOMINATOR, 0.324649*FIXED_DENOMINATOR, 0.321722*FIXED_DENOMINATOR, 0.318779*FIXED_DENOMINATOR, 0.315817*FIXED_DENOMINATOR, 0.312838*FIXED_DENOMINATOR, 
  0.309840*FIXED_DENOMINATOR, 0.306822*FIXED_DENOMINATOR, 0.303785*FIXED_DENOMINATOR, 0.300726*FIXED_DENOMINATOR, 0.297647*FIXED_DENOMINATOR, 0.294545*FIXED_DENOMINATOR, 0.291420*FIXED_DENOMINATOR, 0.288272*FIXED_DENOMINATOR, 
  0.285099*FIXED_DENOMINATOR, 0.281900*FIXED_DENOMINATOR, 0.278675*FIXED_DENOMINATOR, 0.275423*FIXED_DENOMINATOR, 0.272142*FIXED_DENOMINATOR, 0.268831*FIXED_DENOMINATOR, 0.265489*FIXED_DENOMINATOR, 0.262115*FIXED_DENOMINATOR, 
  0.258708*FIXED_DENOMINATOR, 0.255266*FIXED_DENOMINATOR, 0.251787*FIXED_DENOMINATOR, 0.248271*FIXED_DENOMINATOR, 0.244715*FIXED_DENOMINATOR, 0.241117*FIXED_DENOMINATOR, 0.237475*FIXED_DENOMINATOR, 0.233788*FIXED_DENOMINATOR, 
  0.230053*FIXED_DENOMINATOR, 0.226268*FIXED_DENOMINATOR, 0.222430*FIXED_DENOMINATOR, 0.218536*FIXED_DENOMINATOR, 0.214582*FIXED_DENOMINATOR, 0.210567*FIXED_DENOMINATOR, 0.206485*FIXED_DENOMINATOR, 0.202333*FIXED_DENOMINATOR, 
  0.198106*FIXED_DENOMINATOR, 0.193800*FIXED_DENOMINATOR, 0.189408*FIXED_DENOMINATOR, 0.184925*FIXED_DENOMINATOR, 0.180343*FIXED_DENOMINATOR, 0.175655*FIXED_DENOMINATOR, 0.170853*FIXED_DENOMINATOR, 0.165925*FIXED_DENOMINATOR, 
  0.160861*FIXED_DENOMINATOR, 0.155647*FIXED_DENOMINATOR, 0.150267*FIXED_DENOMINATOR, 0.144703*FIXED_DENOMINATOR, 0.138932*FIXED_DENOMINATOR, 0.132928*FIXED_DENOMINATOR, 0.126657*FIXED_DENOMINATOR, 0.120077*FIXED_DENOMINATOR, 
  0.113134*FIXED_DENOMINATOR, 0.105757*FIXED_DENOMINATOR, 0.097847*FIXED_DENOMINATOR, 0.089263*FIXED_DENOMINATOR, 0.079786*FIXED_DENOMINATOR, 0.069051*FIXED_DENOMINATOR, 0.056343*FIXED_DENOMINATOR, 0.039815*FIXED_DENOMINATOR };
#endif

#if (USE_DIMMING_CURVE==0)
DOUBLE returnLevel(int level)
{
	// every setting of output channels should go through this function to compensate
	// for the non-linearity of the integral under mains waveform (phase control rectification)
	DOUBLE f;
	f=(DOUBLE)level;
	if(f<0.0)f=0.0; else if (f>255.0)f=255.0;
	f=f/128.0;
	f=((acos(f-1.0))/(PI));
	if(f<0.0)f=0.0; if(f>1.0)f=1.0;
	return f;
}
#endif

void setOutputLevelPhase(int level, int zz, int phasenum, int mod)
{
	// level should be an unsigned integer in the range 0-255
	// accounts for the phase control non linearity with an acos function
	// the integral of part of a sine wave.
	int cc;
	cc=phasenum & 0x0001;
#if (USE_DIMMING_CURVE==0)
	if((ch[zz].mode & mod)!=0)ch[zz].outputChannel[cc]=maxPhaseOffset*returnLevel(level);
#else
	if((ch[zz].mode & mod)!=0)ch[zz].outputChannel[cc]=((__builtin_mulss(maxPhaseOffset, DimmingCurve[level & 0x00FF]))>>FIXED_DENOMINATOR_LOG2);
#endif
}

void setOutputLevel(int level, int zz, int mod)
{
	// level should be an unsigned integer in the range 0-255
	// accounts for the phase control non linearity with an acos function
	// the integral of part of a sine wave.
#if (USE_DIMMING_CURVE==0)
	DOUBLE f;
#endif
	int k;
	if(mod==NO_UPDATE_MODE)k=0; else if(zz==CH1)k=LED4; else if(zz==CH2)k=LED5; else if(zz==CH3)k=LED6; else k=LED7;
	level=level & 0x000000FF;
	if(1){
		if((ch[zz].mode & CONTINUOUS_MODE)!=0){ 
			if(level>(ch[zz].outputLevel+CONT_POS_THRESHOLD))
			{ 
				ch[zz].outputLevel+=ch[zz].attack;
			} else
			if(level<(ch[zz].outputLevel-CONT_NEG_THRESHOLD))
			{
				ch[zz].outputLevel-=ch[zz].decay;
			} else
			if(level>ch[zz].outputLevel)ch[zz].outputLevel++;
			else
			if(level<ch[zz].outputLevel)ch[zz].outputLevel--;
			if(ch[zz].outputLevel<0)ch[zz].outputLevel=0; else if(ch[zz].outputLevel>255)ch[zz].outputLevel=255;
		} else ch[zz].outputLevel=level;
		
		if((ch[zz].mode & STROBE_MODE)==0){
#if (USE_DIMMING_CURVE==0)
		f=returnLevel(ch[zz].outputLevel);
		ch[zz].outputChannel[0]=maxPhaseOffset*f;
#else
		ch[zz].outputChannel[0]=((__builtin_mulss(maxPhaseOffset, DimmingCurve[ch[zz].outputLevel]))>>FIXED_DENOMINATOR_LOG2);
#endif
		ch[zz].outputChannel[1]=ch[zz].outputChannel[0];
		FLASHING&=~k;
		if(ch[zz].outputChannel[0]>zvThreshold)LEDS&=~k; else LEDS|=k;
		} else
		{
		if(ch[zz].outputLevel>=silenceThreshold){
			ch[zz].strobe&=0x8000;
			ch[zz].strobe|=(0x00FF & (__builtin_divud(256, level+1)));
			ch[zz].outputLevel=level;
		} else ch[zz].strobe=0x4000;			// for off.
		FLASHING|=k;
		LEDS|=k;
		}
	}
}

int returnSPIPrescalerValue(unsigned int baudratedivider)
{
	// tries to match the U1BRG value to the SPI prescaler for RF6 clock output at 16 x BAUD Rate
	// there are 32 possible values for the SPI prescaler
	// bits 1-0 select one prescaler     at either 00= 64:1 01= 16:1 10 =4:1 11 =1:1
	// bits 4-2 select another prescaler at either 000= 8:1 001= 7:1 ... etc... 111= 1:1
	// so we try to choose values for the prescalers such that U1BRG+1 = the multiplied prescaler values
	// the lowest baud rate we can go down to is 512 times prescaling or 3.6 Kbps.
	unsigned int prescaler1, prescaler2;
	baudratedivider=baudratedivider+1;
	if((baudratedivider>0)&&(baudratedivider<=8))
	{
			prescaler1=0b00000011;			// choose 1:1
			prescaler2=baudratedivider;
	}
	else
	if((baudratedivider>8)&&(baudratedivider<=32))
	{
			prescaler1=0b00000010;			// choose 4:1
			prescaler2=baudratedivider>>2;	// divide by 4
	}
	else
	if((baudratedivider>32)&&(baudratedivider<=128))
	{
			prescaler1=0b00000001;			// choose 16:1
			prescaler2=baudratedivider>>4;	// divide by 16
	}
	else
	if((baudratedivider>128)&&(baudratedivider<=512))
	{
			prescaler1=0b00000000;			// choose 64:1
			prescaler2=baudratedivider>>6;	// divide by 64
	}
	else
	{
			prescaler1=0b00000011;
			prescaler2=1;
	}										// the default is the system clock.
	prescaler2=0b00011100 & ((8-prescaler2)<<2);
	return (0b00011111 & (prescaler1 | prescaler2));
}

void changeRf6Mode(int cxx)
{
	int i;
	clip(&cxx, 0, RF6MODULUS-1);
	rf6Mode=cxx;
	switch(rf6Mode)
	{
		case (OUTPUT_BAUD16):
				//SPI1CON=(0x6C20 | (returnSPIPrescalerValue(U1BRG)));
				//SPI1STATbits.SPIEN=1;
				break;

		case (OUTPUT_SYSTEM_CLK):
				//SPI1CON=0x6C3F;
				//SPI1STATbits.SPIEN=1;
				break;

		case (INPUT_REMOTE):
				//SPI1STAT=0;
				//SPI1CON=0;
				i=TRISF;
				i=i | 0x0040;
				TRISF=i;				// make RF6 and input
				break;

		default:
				//SPI1STAT=0;
				//SPI1CON=0;
				i=TRISF;
				i=i & 0xFFBF;
				TRISF=i;				// make RF6 an output
				break;
	}
}

void setQuiescentLevel(int level, int zz, int mod)
{
	// level should be an unsigned integer in the range 0-255
	// accounts for the phase control non linearity with an acos function
	// the integral of part of a sine wave (inverted)...
#if (USE_DIMMING_CURVE==0)
	DOUBLE f;
#endif

	if(1){
#if (USE_DIMMING_CURVE==0)
	f=returnLevel(level>>2);
	ch[zz].quiescentCurrent=maxPhaseOffset*f;
#else
	ch[zz].quiescentCurrent=((__builtin_mulss(maxPhaseOffset, DimmingCurve[(level>>2) & 0x00FF]))>>FIXED_DENOMINATOR_LOG2);
#endif
	ch[zz].quiescentLevel=level;
	}
}

void allOutputs(int x)
{
	int i;
	for(i=0; i<OUTPUT_CHANNELS; i++)
	{
	if(x==0)setQuiescentLevel(0, i, NORMAL_MODE);
	setOutputLevel(0, i, NORMAL_MODE);
	}
}

void initOutputCompare(void)
{
	// initializes the four output compare channels...
	// using a 16 bit 
	// first initialize Timer 2 to count instruction clocks
	// with 16 bit resolution...
	TMR2=0x0000;
	PR2=T2PERIOD_DEFAULT;
	T2CON=0x8020;			// using 1:64 prescaler and turn on!
	// now setup up the four channels!
	OC1R=0;
	OC2R=0;
	OC3R=0;
	OC4R=0;
	OC1RS=0;
	OC2RS=0;
	OC3RS=0;
	OC4RS=0;
	OC1CON=0x0004;
	OC2CON=0x0004;
	OC3CON=0x0004;
	OC4CON=0x0004;			// disable for now...
	// now enable all the interrupts
	IFS0bits.OC1IF=0;
	IFS0bits.OC2IF=0;
	IFS1bits.OC3IF=0;
	IFS1bits.OC4IF=0;
	IPC0|=(OC1IPRI<<8);
	IPC1|=(OC2IPRI<<4);
	IPC4|=(OC3IPRI<<12);
	IPC5|=OC4IPRI;
	ocTrigger=0;
	IEC0bits.OC1IE=0;
	IEC0bits.OC2IE=0;
	IEC1bits.OC3IE=0;
	IEC1bits.OC4IE=0;
	// now setup the external interrupt on INT0 which is the 50Hz Sync from Mains!
	INTCON2=0x0000;
	IFS0bits.INT0IF=0;				// clear requests
	IPC0|=INT0IPRI;					// priority 6 for INT0 interrupt
	IFS0bits.T2IF=0;				// clear requests
	IPC1|=(T2IPRI<<8);				// priority 7 for T2 interrupt
	IEC0bits.INT0IE=1;				// enable external INT0 interrupt!
	DelayMs(SYNCSTARTUPDELAY);		// to allow a bit of synchronization first
}

void initTimer1(void)
{
	// first set up Timer 1
	TMR1=0x0000;			// clear T1
	PR1=0xFFFF;				// the period to get around 80Hz refresh rate (there are 10 columns remember)
	T1CON=0x8020;			// control register setup to run off system clock at frequency FCY divided by 1:64 prescaler
	// and now enable the interrupt!
	IFS0bits.T1IF=0;
	IPC1|=(T1IPRI<<12); 	// select priority 4 for T1 interrupt
	IEC0bits.T1IE=0;		// do not enable T1 Interrupt...
}

#if (REMOTE_CONTROL==0)

	void initTimer45(void)
	{
	// first set up Timer 4/5
	intMasterTimer=0;
	ledOnTimer=LED_ON_TIMEOUT;
	ledOnTime=1;
	screenOnTime=1;
	screenOnTimer=0;
	chaserTimeOut=CHASER_TIMEOUT_INITIAL;
	screenOnTimeout=SCREEN_ON_TIMEOUT;
	screenOffTimeout=SCREEN_OFF_TIMEOUT;
	intScreenTimer=(long)SCREEN_TIMEOUT_INITIAL;
	intCountDownTimer=INTCOUNTDOWN_TIMER_INITIAL;
	TMR4=0x0000;			// clear T4/5
	TMR5=0x0000;
	PR4=0xFFFF;
	PR5=FCY100H;				// the periods for 100ms timeout
	T5CON=0x8008;			// NB: T5CON is ignored in 32bit Timer operation
	T4CON=0x8008;			// control register setup to run off system clock at frequency FCY divided by 1:1 prescaler
							// and now enable the interrupt! remember that in 32 bit mode T5CON is ignored
	IFS1bits.T4IF=0;
	IFS1bits.T5IF=0;
	IPC5|=(T4IPRI<<4); 		// select priority for T4 interrupt (if enabled)
	IPC5|=(T5IPRI<<8);		// select priority for T5 interrupt (if enabled)
	IEC1bits.T4IE=0;		// do not enable T4 Interrupt!
	IEC1bits.T5IE=1;		// do enable T5 interrupt
	}

#else

	// Here we use Timer 4 and 5 as separate 16 bit Timers Timer 4 is used for the remote control tick
	// whereas Timer 5 is used for the system tick
	void initTimer45(void)
	{
	// first set up Timer 4/5
	initRC5();
	intMasterTimer=0;
	ledOnTimer=LED_ON_TIMEOUT;
	ledOnTime=1;
	screenOnTime=1;
	screenOnTimer=0;
	chaserTimeOut=CHASER_TIMEOUT_INITIAL;
	screenOnTimeout=SCREEN_ON_TIMEOUT;
	screenOffTimeout=SCREEN_OFF_TIMEOUT;
	intScreenTimer=(long)SCREEN_TIMEOUT_INITIAL;
	intCountDownTimer=INTCOUNTDOWN_TIMER_INITIAL;
	TMR4=0x0000;			// clear Timers
	TMR5=0x0000;			
	PR4=DELAY_64US;			// for the remote control Tick
	PR5=DELAY_100MS;		// the periods for 100ms timeout
	T5CON=0x8030;			// 1:256 	prescaler
	T4CON=0x8000;			// 1:1 		prescaler
							// and now enable the interrupt! remember that in 32 bit mode T5CON is ignored
	IFS1bits.T4IF=0;
	IFS1bits.T5IF=0;
	IPC5|=(T4IPRI<<4); 		// select priority for T4 interrupt (if enabled)
	IPC5|=(T5IPRI<<8);		// select priority for T5 interrupt (if enabled)
	IEC1bits.T4IE=1;		// do enable T4 Interrupt
	IEC1bits.T5IE=1;		// do enable T5 interrupt
	}

#endif

void lockAnalog(void)
{
		analogLock=1; 
		if(analogPotMode==2)analogPotMode=1;
}

void unlockAnalog(long val, int bits)
{
	// val= value to try to unlock for, bits= number of bits in val that are significant
	if(analogPotMode==1)
	{
	digitalPot=(val<<ADC_LOG2)>>bits;		// this effectively unlocks the pot when in digital mode 
	rawPotValue=digitalPot;
	analogPotMode=2;
	}
	val=(((long)val<<ADC_LOG2)>>bits)-rawPotValue;
	if(val<0)val=-val;
	if(val<ADAPTIVE_POT_THRESHOLD)analogLock=0;
}

void __attribute__((interrupt,auto_psv)) _ADCInterrupt(void)
{
	// this is the ADC interrupt service routine
	int u;
	long r;
	toggleLED(ADC_ACQUIRE);
	u=0x03FF & ((ADCBUF0)>>6);
	if(u>=0x0200)u=u-0x0200; else u=u+0x0200;
	if(u<=POT_MIN_VALUE)u=0; else if(u>=POT_MAX_VALUE)u=0x3FF; else u=u-POT_MIN_VALUE;
	iavgPotValue=(iavgPotValue+u)>>1; 
	if(avgPotValueTimes>=AVG_POT_TIMES){ avgPotValue=iavgPotValue; avgPotValueTimes=0; } else avgPotValueTimes++;
	r=(oldPotValue-avgPotValue);	
	if(r<0)r=-r;
	if(r>MOVEMENT_POT_THRESHOLD)
	{ 
	oldPotValue=avgPotValue;
	analogPotMode=0;
	avgPotValueTimes=0;
	iavgPotValue=0;
	}
	if(analogPotMode==0)
			rawPotValue=avgPotValue; 
	else 
			rawPotValue=digitalPot;

	if(adcErr==0){
		u=(int)(ADCBUF2);
		if(((u>0)&&(u>CLIP_MAX))||((u<0)&&(-u>CLIP_MIN)))adcStatus|=CLIP_L;
		u=(int)(ADCBUF3);
		if(((u>0)&&(u>CLIP_MAX))||((u<0)&&(-u>CLIP_MIN)))adcStatus|=CLIP_R;
		//adcBlock=1;
		r=__builtin_mulss(ADCBUF1, iC[CHANNELMIC]);
		r+=__builtin_mulss(ADCBUF2, iC[CHANNELL]);
		r+=__builtin_mulss(ADCBUF3, iC[CHANNELR]);
		sigCmpx[adcSampleIndex].real=(int)(r>>FIXED_DENOMINATOR_LOG2_AND1);
		sigCmpx[adcSampleIndex].imag=0x0000;
		adcSampleIndex++;
		r=__builtin_mulss(ADCBUF5, iC[CHANNELMIC]);
		r+=__builtin_mulss(ADCBUF6, iC[CHANNELL]);
		r+=__builtin_mulss(ADCBUF7, iC[CHANNELR]);
		sigCmpx[adcSampleIndex].real=(int)(r>>FIXED_DENOMINATOR_LOG2_AND1);
		sigCmpx[adcSampleIndex].imag=0x0000;
		adcSampleIndex++;
		r=__builtin_mulss(ADCBUF9, iC[CHANNELMIC]);
		r+=__builtin_mulss(ADCBUFA, iC[CHANNELL]);
		r+=__builtin_mulss(ADCBUFB, iC[CHANNELR]);
		sigCmpx[adcSampleIndex].real=(int)(r>>FIXED_DENOMINATOR_LOG2_AND1);
		sigCmpx[adcSampleIndex].imag=0x0000;
		adcSampleIndex++;
		r=__builtin_mulss(ADCBUFD, iC[CHANNELMIC]);
		r+=__builtin_mulss(ADCBUFE, iC[CHANNELL]);
		r+=__builtin_mulss(ADCBUFF, iC[CHANNELR]);
		sigCmpx[adcSampleIndex].real=(int)(r>>FIXED_DENOMINATOR_LOG2_AND1);
		sigCmpx[adcSampleIndex].imag=0x0000;
		adcSampleIndex++;
		//adcBlock=0;
		
	if(adcSampleIndex==FFT_BLOCK_LENGTH){
		if(adcReq!=0)adcErr|=0x01;
		else { 
			adcReq|=0x01;
			adcPtr=&sigCmpx[0];
			 }
	}
	else if(adcSampleIndex==(FFT_BLOCK_LENGTH*2)){
		adcSampleIndex=0;				// wrap around if necessary...
		if(adcReq!=0)adcErr|=0x01;
		else {
			adcReq|=0x01;
			adcPtr=&sigCmpx[FFT_BLOCK_LENGTH];
			 }
		}
 	}
	//adcBlock=0;
	IFS0bits.ADIF=0;
}

void initADC4(DOUBLE frequency, int tads)
{
/* initialize the ADC subsystem to:
   (1) automatically sample channels AN0,AN1,AN2,AN3 at the sampling frequency "frequency"
	NB: assumes that the FCY is around 30MIPS
*/
// As per FRManual(ADC) section 17.5
// ADC Module Configuration
	int i, xx;
// select the port pins as analog inputs
// A pin is configured as analog input when the corresponding PCFGn bit (ADPCFG<n>) is clear.
// The ADPCFG register is clear at Reset, causing the A/D input pins to be configured for analog
// input by default at Reset.
	IEC0bits.ADIE=0;
	ADCON1=0;
	clipDouble(&frequency, ADC_SAMPLING_FREQ_MIN, ADC_SAMPLING_FREQ_MAX);
	adcSamplingFreq=(unsigned int)frequency;
	analogLock=0;
	adcSampleIndex=0;
	adcReq=0;
	adcErr=0;
	adcStatus=NO_STATUS;
	adcPtr=&sigCmpx[adcSampleIndex];
	ADPCFG=0xFFF0;
	i=TRISB;
	i=i | 0x000F;
	TRISB=i;
// select the voltage reference source ADCON2<15:13>
	ADCON2=0;		// select reference AVDD and AVSS
// select the sampling frequency
// 6 bits are significant and TADC (period)= TCY*(ADCS+1)/2 where ADCS is ADCON3<5:0> (6 bits)
// therefore ADCON3<5:0>= 2*FCY/FADC - 1
	xx=floor(( (1.0/(12.0+tads))*( ( (double)fcy)/((double)frequency*2.0) ) )-0.5);  // note 43=31 (SAMC) + 12 (internal delay for convert in TAD)
	if (xx>0x3F)xx=0x3F; 		
	ADCON3=xx;
// determine how many SH (sample hold) channels will be used ADCON2<9:8>
	ADCON2=0;				// choose CH0 only
// determine how sampling will occur ADCON1<3> and ADCSSL<15:0>
	ADCON1=0;				// channels simultaneously!
	ADCSSL=0x000F;			// select the channels for input scan AN0,AN1,AN2,AN3
// determine how inputs will be allocated to SH channels ADCHS<15:0>
	ADCHS=0;
// select the appropriate sample/conversion sequence ADCON1<7:0> and ADCON3<12:8>
	ADCON3|=((0x001F & tads)<<8);			// select 31xTAD for auto conversion
	ADCON1|=0x00E4;			// select auto conversion bits in ADCON1<7:0>
// select the format of conversion results in the buffer	ADCON1<9:8>
	ADCON1|=0x0300;			// select signed fractional format ADCON1<9:8>=11
// select interrupt rate ADCON2<5:2>
	ADCON2|=0x843C;			// one interrupt every 16 sample hold ADC conversions and scan channels 0,1,2,3 CSCNA=1 (bit 10)
// turn on ADC module ADCON1<15>
	ADCON1bits.ADON=1;
// configure the ADC interrupt	clear ADIF and select ADC interrupt priority level
	IFS0bits.ADIF=0;
	IPC2|=(ADCIPRI<<12);	// select priority 6 for ADC interrupt
	IEC0bits.ADIE=1;		// enable ADC interrupt
}

unsigned int unsignedclipBounded(unsigned int y, unsigned int miny, unsigned int maxy)
{
	DOUBLE f;
	unsignedclip(&y, 0, LEVELS_MAX);
	f=((DOUBLE)(y)/LEVELS_MAX);
	f=(DOUBLE)miny + ((DOUBLE)maxy-(DOUBLE)miny)*f;
	return (unsigned int)f;
}

unsigned int unsignedclipBoundedInverse(unsigned int y, unsigned int miny, unsigned int maxy)
{
	DOUBLE f;
	unsignedclip(&y, miny, maxy);
	f=((DOUBLE)y)-((DOUBLE)miny);
	f=f/((DOUBLE)maxy-(DOUBLE)miny);
	f=f*LEVELS_MAX;
	y=(unsigned int)f;
	return y;
}

/*
int detectRemote(void)
{
	int i, k, j, l, m;
	// RF2= PGC = pin 10, 2 of CON3 (also Rx) so is made an input
	// RF3= PGD = pins 6, 7, 8 of CON3 (also Tx) so is made an output temporarily...
	m=SPI1STAT;
	j=U1MODE;
	l=U1STA;
	U1MODE=0;
	U1STA=0;
	SPI1STAT=0;
	i=TRISF;
	i=(i & 0xFFFB) | 0x0008;
	TRISF=i;
	PORTFbits.RF2=0;
	DelayMs(100);
	k=TRUE;
	i=PORTF;
	if((i & 0x08)!=0)k=FALSE;
	PORTFbits.RF2=1;
	DelayMs(100);
	i=PORTF;
	if((i & 0x08)==0)k=FALSE;
	i=TRISF;
	i=i | 0x0004;
	TRISF=i;
	U1STA=l;
	U1MODE=j;
	SPI1STAT=m;
	return k;
}
*/

void initPorts(void)
{
	// initialize the ports
	PORTB=0xFFFF;
	PORTE=0xFFFF;
	PORTF=0xFFFF;
	PORTC=0xFFFF;
	PORTD=0xFFF0;
	TRISD=0xFFF0;
	TRISB=0xFFFF;
	TRISE=0xFFE0;			// RE4 is an output controlling LED 
	TRISF=0xFFFD;			// make RF1 and RF3 outputs the rest inputs...
	TRISC=0xFFFF;	
}

/*
void initLVD(void)
{
	// this is the low voltage detect module init
	// used to detect power off and save settings quickly
	int i;

	i=RCON;
	i=i & 0xF0FF;
	i=i | 0x0C00;			// choose 4.1V trip point.
	IEC2bits.LVDIE=0;		// disable LVD interrupt
	RCON=i;
	RCONbits.LVDEN=1;		// enable the LVD module.
	while(RCONbits.BGST==0)wait();
	IFS2bits.LVDIF=0;
	IPC10|=(LVDIPRI<<8);	// set the priority level.
	IEC2bits.LVDIE=1;		// enable interrupts
}
*/

void initKeys(void)
{
	int i;

	digitalPot=0;
	analogPotMode=0;
	LEDS=0;
	FLASHING=0;
	flushKeys();
	for(i=0; i<NUM_KEYS;i++){ lastTimeAdded[i]=0x0000;  }
	CNPU1=0xFFFF;			// enable all weak internal pull ups
	CNPU2=0xFFFF;			// enable all weak internal pull ups
	CNEN1bits.CN0IE=0;		// enable rotary changes
	CNEN1bits.CN1IE=0;		// enable rotary changes
	CNEN2bits.CN17IE=1;		// enable key detect
	IFS0bits.CNIF=0;
	IPC3|=(CNIPRI<<12);		// priority of the CN interrupt.
	IEC0bits.CNIE=1;		// enable interrupts on Change notification
}

void __attribute__((interrupt,auto_psv)) _MathError(void)
{
	PORTEbits.GBIT=1;
	blink(1);
	INTCON1bits.MATHERR=0;
}

void __attribute__((interrupt,auto_psv)) _StackError(void)
{
	PORTEbits.GBIT=1;
	blink(2);
	INTCON1bits.STKERR=0;
}

void __attribute__((interrupt,auto_psv)) _OscillatorFail(void)
{
	INTCON1bits.OSCFAIL=0;
}

void __attribute__((interrupt,auto_psv)) _ReservedTrap5(void)
{
	PORTEbits.GBIT=1;
	blink(4);
}

void __attribute__((interrupt,auto_psv)) _ReservedTrap6(void)
{
	PORTEbits.GBIT=1;
	blink(5);
}

void __attribute__((interrupt,auto_psv)) _ReservedTrap7(void)
{
	PORTEbits.GBIT=1;
	blink(6);
}

void setmaxPhaseOffset(int freqq)
{
	maxPhaseOffset=((DOUBLE)fcy/(T2PRESCALE*2.0*freqq));
	allOutputs(1);
}

DOUBLE fixedToFloat(int val)
{
		// convert a fixed decimal to floating
		return ((DOUBLE)val/(DOUBLE)FIXED_DENOMINATOR);
}

//DOUBLE analogFloat(void)
//{
//		return ((DOUBLE)rawPotValue/(DOUBLE)ADC_DENOMINATOR);
//}

int floatToFixed(DOUBLE f)
{
	return (int)(f*FIXED_DENOMINATOR);
}

void setGain(DOUBLE g, int chn)
{
	ch[chn].gain=g;
	ch[chn].igain=floatToFixed(ch[chn].gain);
}

DOUBLE detectMainsFreq(void)
{
// detects the mains frequency and sets the MAX_PHASE_OFFSET accordingly.
// max Phase Offset approx ((FCY/(T2PRESCALE*MAINS_FREQ*2))-PULSE_WIDTH-PULSE_OFFSET-PULSE_ERROR)
	int i, j;
	DOUBLE xx;

	xx=0.0;
	i=0;
	outputEnable=OUTPUTENABLE_ALLOFF;
	mainsFreq=MAINSFREQ_DEFAULT;			// default!
	while((i<MAINS_DETECT_TRIES)&&((xx<MAINS_MIN)||(xx>MAINS_MAX))){
						DelayMs(MAINS_DETECT_PAUSE);
						xx=freqObj[MAINS_SYNC].freq;			
						i++;
						}

	if(i<MAINS_DETECT_TRIES){
			for(j=0; j<MAINS_AVERAGING_COUNT; j++)
					{
					while((freqObj[MAINS_SYNC].freqIndex & 0x0003)!=0x0003)wait();
					updateFreqObj(MAINS_SYNC);
					}
			waitForUpdated(MAINS_SYNC);
			xx=freqObj[MAINS_SYNC].freq;
			if(xx<=MAINS_THRESHOLD)mainsFreq=MAINS_50; else mainsFreq=MAINS_60;			// set the frequency!
	}
	setmaxPhaseOffset(mainsFreq);
	if(i>=MAINS_DETECT_TRIES)return -1.00; else { outputEnable=OUTPUTENABLE_ALLON; return xx; }
}

void testOutputs(void)
{
	int i, j, k, l;

	k=LEDS;
	l=FLASHING;
	LEDS=0xFFFF;
	FLASHING=0x0000;
	
	for(i=0; i<DISPLAY_COLUMNS; i++)display[i]=0xFFFF;
	for(j=0x00FF; j!=0xFFFF; j--)
	{
		for(i=0; i< OUTPUT_CHANNELS; i++)
		{
		setOutputLevel(j, i, NORMAL_MODE);
		}
		DelayMs(TEST_OUTPUTS_DELAY_MS);
	}
	LEDS=k;
	FLASHING=l;
	clearDisplayScrolling();
}

int por(void)
{
	// returns the System Boot State.
	// returns an integer such that
	// FIRST_BOOT is true if it is the very first time that the Musicolour is run (uses EEPROM memory to do this)
	// SOFT_POR	  is true if it is a Power On Reset rather than another reset
	int i, j;

	i=NO_BOOT;
	if(RCONbits.POR==1){ 
		i|=POR_BOOT; 
	}
	j=readEEPROMInt(MAGIC_EEPROM_ADDRESS);
	if(j!=MAGIC_VALUE)
	{ 
		i|=FIRST_BOOT;
	}
	j=readEEPROMInt(MAGIC_CALIBRATION_ADDRESS);
	if(j!=MAGIC_CALIBRATION_VALUE)
	{
		i|=NO_CALIBRATION;
	}
	return i;
}

void initFrequencySystem(void)
{
	int i;
	for(i=0; i<PERIODS; i++)
	{
	freqObj[i].period[0]=0;
	freqObj[i].period[1]=0;
	freqObj[i].period[2]=0;
	freqObj[i].period[3]=0;
	freqObj[i].freq=0.0;
	freqObj[i].duty=0.0;
	freqObj[i].posperiod=1.0;
	freqObj[i].freqIndex=0;
	freqObj[i].updated=0;
	}
}

//void initErrorSystem(void)
//{
//	int i;
//	for(i=0; i<16; i++)error[i]=0.0;
//}

void initMaxBuffer(void)
{
	int i;
		for(i=0; i<PHASES; i++)maxBuffer[i]=0;
}

DOUBLE getFloatInverseiC(int index, DOUBLE f)
{
	if(index==CHANNELMIC)
	{
		return f;													// solving for Cm
	}
	else
	if(index==CHANNELL)
	{
		if(Cm<1.0)return (f/(1.0-Cm)); else return Cl;				// solve for Cl
	}
	else
	if(index==CHANNELR)
	{
		if(Cm<1.0)return (1.0-(f/(1.0-Cm)));	else return Cl;			// solve for Cl
	}
	else return 0.0;
}

DOUBLE getFloatiC(int index)
{
	if(index==CHANNELMIC)
	{
		return Cm;
	}
	else
	if(index==CHANNELL)
	{
		return ((1.0-Cm)*Cl);
	}
	else
	if(index==CHANNELR)
	{
		return ((1.0-Cm)*(1.0-Cl));
	}
	else return 0.0;
}

void setCmCl(DOUBLE cm, DOUBLE cl)
{

	if(cm>1.0)cm=1.0; else if(cm<0.0)cm=0.0;
	if(cl>1.0)cl=1.0; else if(cl<0.0)cl=0.0;
	Cm=cm;
	Cl=cl;
	// now we compute iC's
	// as follows...
	iC[CHANNELMIC]=micGain*FIXED_DENOMINATOR * getFloatiC(CHANNELMIC);
	iC[CHANNELL]=leftGain*FIXED_DENOMINATOR * getFloatiC(CHANNELL);
	iC[CHANNELR]=rightGain*FIXED_DENOMINATOR * getFloatiC(CHANNELR);
}

void displayBalance(int cm, int cl, int cr)
{
	// cm corresponds to the mic level
	// cl corresponds to the left audio channel level
	// cr corresponds to the right audio channel level
	// MIC is shown as a gain figure
	// LEFT and RIGHT channels are shown as bars
	int i;

	cursor=0;
	BlankScreen();
	i=convertToBar(cm, FIXED_DENOMINATOR_LOG2)>>1;
	if(i>0x007F)i=0x007F;
	display[0]=i;
	display[3]=i;
	i=((i+1)>>1);
	display[1]=i;
	display[2]=i;
	display[4]=0;
	i=convertToBar(cl, FIXED_DENOMINATOR_LOG2)>>1;
	if(i>0x007F)i=0x007F;
	display[5]=i;
	display[6]=i;
	display[7]=i;
	display[8]=i;
	display[9]=0;
	i=convertToBar(cr, FIXED_DENOMINATOR_LOG2)>>1;
	if(i>0x007F)i=0x007F;
	display[10]=i;
	display[11]=i;
	display[12]=i;
	display[13]=i;
	display[14]=0;
	UnBlankScreen();
}

void displayEqualizer(int x)
{
	int i, j, k;
	
	j=0;
	for(i=0; i<EQUALIZERS; i++)
	{
	k=equalizerCoefficient[i];
	if(j<DISPLAY_COLUMNS)oldisplay[j++]=k;
	if(j<DISPLAY_COLUMNS)oldisplay[j++]=k;
	}
	for(i=0;i<DISPLAY_COLUMNS;i++){
			k=convertToBar(oldisplay[i],FIXED_DENOMINATOR_LOG2_AND1);
			oldisplay[i]=0x003F & (k>>1);
	}
	x=x<<1;
	oldisplay[x]|=0x40;
	if((x+1)<DISPLAY_COLUMNS)oldisplay[x+1]|=0x40;
	BlankScreen();
	for(i=0; i<DISPLAY_COLUMNS; i++)display[i]=oldisplay[i];
	UnBlankScreen();
}

void printChannelAndLevel(int ch, int lev)
{
	int i, j;
	cursor=0;
	buffer[0]=ch;
	buffer[1]=0x00;
	printstringDots(&buffer[0], 1, 4);
	display[4]=0x000A;
	j=0;
	for(i=5; i<DISPLAY_COLUMNS;i++)
	{
	j=j+__builtin_divud(lev, 10);
	display[i]=convertToBar(j, 8)>>1;
	}
}

int channelLED(int xx)
{
	int yy;
	yy=0;
	switch(xx){
		case 0:
			yy=LED4;
			break;
		case 1:
			yy=LED5;
			break;
		case 2:
			yy=LED6;
			break;
		case 3:
			yy=LED7;
			break;
	}
	return yy;
}

void stateSetTriggerDefaults(int y)
{
	triggerMinFreq=TRIGGER_MINFREQ_DEFAULT;
	triggerMaxFreq=TRIGGER_MAXFREQ_DEFAULT;
	triggerThreshold=TRIGGER_THRESHOLD_DEFAULT;
	triggerCount=0;
	trigger=TRIGGER_OFF;
}

void stateSetAudioDefaults(int y)
{
	rightGain=RIGHT_GAIN;
	leftGain=LEFT_GAIN;
	micGain=MIC_GAIN;
	setCmCl(0.0, 0.0);
	adcSamplingFreq=ADC_SAMPLING_FREQ;
	initADC4(adcSamplingFreq, TADS);
	initEqualizerDefaults();
}

void stateSetChannelDefaults(int y)
{
	int i;
	for(i=0; i<OUTPUT_CHANNELS;i++){
				setGain(GAIN_DEFAULT, i);
				ch[i].mode=DEFAULT_CH_MODE;
				ch[i].modeIndex=DEFAULT_CH_MODE_INDEX;
				ch[i].attack=DEFAULT_ATTACK;
				ch[i].decay=DEFAULT_DECAY;
				ch[i].strobe=DEFAULT_STROBE;
				ch[i].counter=0;
				ch[i].bin=0;
			}
	ch[0].minFreq=CH1_MINFREQ_DEFAULT;
	ch[0].maxFreq=CH1_MAXFREQ_DEFAULT;
	ch[1].minFreq=CH2_MINFREQ_DEFAULT;
	ch[1].maxFreq=CH2_MAXFREQ_DEFAULT;
	ch[2].minFreq=CH3_MINFREQ_DEFAULT;
	ch[2].maxFreq=CH3_MAXFREQ_DEFAULT;
	ch[3].minFreq=CH4_MINFREQ_DEFAULT;
	ch[3].maxFreq=CH4_MAXFREQ_DEFAULT;
}

void stateSetOutputsDefaults(int y)
{
	int i;
	for(i=0; i<OUTPUT_CHANNELS;i++)
	{
	channelPermutation[i]=i;
	setQuiescentLevel(0, i, NORMAL_MODE);
	}
	initChaserSystem(&Chaser);
	setChaserProgram(CHASER_PROGRAM_DEFAULT);
	setChaserPointer(&Chaser, chaserProgram);
	silenceThreshold=SILENCE_THRESHOLD_DEFAULT;
	outputTimer=0;
	outputRate=OUTPUT_RATE_DEFAULT;
	zvThreshold=ZV_THRESHOLD_DEFAULT;
	outputEnable=OUTPUTENABLE_ALLON;
	setChaserMode(0);
}

void initScreenSavers(void)
{
	screenSaver=SCREEN_SAVER_DEFAULT;
	screenUpdate=0;
	screenTimes=0;
	screenX=0;
	screenY=0;
}

void stateSetDisplayDefaults(int y)
{
	screenFrequency=SCREEN_FREQ_DEFAULT;
	screenBrightness=SCREEN_BRIGHTNESS;
	setScreenParameters(screenBrightness, screenFrequency);
	screenTimeOut=(long)SCREEN_TIMEOUT_DEFAULT;
	initScreenSavers();
	resetScreenSaver();
}

void stateSetSystemDefaults(int y)
{
	U1BRG=UART_DEFAULT_BAUDRATE;
	changeRf6Mode(DEFAULT_RF6MODE);
	writingMode=0;
}
	
void initDefaults(void)
{
	saved=0;
	oldPotValue=0;
	avgPotValue=0;
	avgPotValueTimes=0;
	iavgPotValue=0;
	fcy=FCY;
	outputEnable=OUTPUTENABLE_ALLOFF;	
	silenceCounter=SILENCE_TIMEOUT;
	phaseOffset[0]=0;
	phaseOffset[1]=0;
	phase0=PHASE_OFFSET0;
	phase1=PHASE_OFFSET1;
	phaseMask=PHASE0_MASK;
	pulseError[0]=PULSE_ERROR0;
	pulseError[1]=PULSE_ERROR1;
	mainMode=MODE_DEFAULT;
	changeValueModulo(&currentChannel, DEFAULT_OUTPUT_CHANNEL, OUTPUT_CHANNELS);			
	peakFrequencyBin=0;		
	peakFrequency=0;			
	mainsFreq=MAINSFREQ_DEFAULT;
	setmaxPhaseOffset(mainsFreq);
	initMaxBuffer();
	stateSetSystemDefaults(0);
	stateSetTriggerDefaults(0);
	stateSetAudioDefaults(0);
	stateSetOutputsDefaults(0);
	stateSetChannelDefaults(0);
	viewMode=0;
	screenUpdate=0;
}

void ledTest(void)
{
	LEDS=LED1;
	FLASHING=0;
	DelayMs(150);
	FLASHING|=LED1;
	LEDS|=LED2;
	DelayMs(150);
	FLASHING|=LED2;
	LEDS|=LED3;
	DelayMs(150);
	FLASHING|=LED3;
	LEDS|=LED4;
	DelayMs(150);
	FLASHING|=LED4;
	LEDS|=LED5;
	DelayMs(150);
	FLASHING|=LED5;
	LEDS|=LED6;
	DelayMs(150);
	FLASHING|=LED6;
	LEDS|=LED7;
	DelayMs(150);
	FLASHING|=LED7;
	DelayMs(150);
	LEDS=0;
	FLASHING=0;
}

void doFFT(int u)
{
	// argument=0 do FFT =1 do FFT and update peak frequency
	// performs the FFT
	/* Perform FFT operation */
	FFTComplexIP (LOG2_BLOCK_LENGTH, adcPtr, (fractcomplex *) __builtin_psvoffset(&twiddleFactors[0]), (int) __builtin_psvpage(&twiddleFactors[0]));
	/* Store output samples in bit-reversed order of their addresses */
	BitReverseComplex (LOG2_BLOCK_LENGTH, adcPtr);
	/* Compute the square magnitude of the complex FFT output array so we have a Real output vetor */
	SquareMagnitudeCplx(FFT_BLOCK_LENGTH, adcPtr, &adcPtr->real);
	//adcPtr->real=0;		// zero the first bin...
	/* Find the frequency Bin ( = index into the SigCmpx[] array) that has the largest energy*/
	/* i.e., the largest spectral component */
	if((u & DOFFT_UPDATE_PEAK)!=0)
	{
	VectorMax(FFT_BLOCK_LENGTH/2, &adcPtr->real, &peakFrequencyBin);
	/* Compute the frequency (in Hz) of the largest spectral component */
	peakFrequency=peakFrequencyBin*(freqObj[ADC_ACQUIRE].freq/FFT_BLOCK_LENGTH_DIVIDED_BY_8);
	}
}

void countOutputs(void)
{
	// this function updates the bins for each channel based on min and max frequencies of each channel
	// it assumes that the FFT data starts at adcPtr->real
	int i, j, l;
	unsigned long k;
	unsigned long f;
	fractional t;
	fractional *m;

	f=0;												// f is the current frequency...
	l=0;
	j=((mainMode>> MODE_CHASER_BIT_SHIFT) & MODE_CHASER_CLEAR);
	if(trigger==TRIGGER_OFF)triggerCount=0;
	m=&adcPtr->real;									// m points to the frequency bins, ie output of FFT...
	for(i=0; i<OUTPUT_CHANNELS;i++){ ch[i].bin=0; ch[i].counter=0; }
	while(f<(adcSamplingFreq>>1)){
	if(l<(FFT_BLOCK_LENGTH>>1)){ t=*m++; l++; }
	if(j!=MODE_CHASER_OFF)
	{
	if((trigger==TRIGGER_OFF)&&(f>=triggerMinFreq)&&(f<=triggerMaxFreq)){
									k=((__builtin_muluu(t, equalizerCoefficient[(freqToEqualizerIndex(f))]))>>(FIXED_DENOMINATOR_LOG2-1));
									if(k>triggerCount)triggerCount=k;
									}
	} else
	{
	for(i=0; i<OUTPUT_CHANNELS;i++)
		{
		if((f>=ch[i].minFreq)&&(f<=ch[i].maxFreq)){
										if((ch[i].mode & EQUALIZER_MODE)!=0)
										{
										k=((__builtin_muluu(t, equalizerCoefficient[(freqToEqualizerIndex(f))]))>>FIXED_DENOMINATOR_LOG2);
										}
										else
										{
										k=t;
										}
										k=((__builtin_muluu(ch[i].igain, k))>> FIXED_DENOMINATOR_LOG2);
										if((ch[i].mode & AVG_MODE)!=0)
										{	
										if(k>AVG_THRESHOLD){ ch[i].bin+=k; ch[i].counter++; }
										} else 
										{
										// this is the PEAK mode
										if(k>ch[i].bin)ch[i].bin=k;
										}
									}
		}
	}
	f+=((unsigned long)adcSamplingFreq>>(LOG2_BLOCK_LENGTH));			// f keeps track of the current frequency bin...	
	}
	
	if(j==MODE_CHASER_OFF)
	{
		for(i=0; i<OUTPUT_CHANNELS; i++)
		{ 
		if(((ch[i].mode & AVG_MODE)!=0)&&(ch[i].counter>0))ch[i].bin=__builtin_divud(ch[i].bin, ch[i].counter);
	 	if(ch[i].bin<0)ch[i].bin=0; else if(ch[i].bin>MAX_BIN)ch[i].bin=MAX_BIN;
		}
	} else 	if((triggerCount<<3)>triggerThreshold)trigger|=TRIGGER_ON;

	if(ch[0].bin<=silenceThreshold)adcStatus|=SILENT1; else adcStatus&=~SILENT1;
	if(ch[1].bin<=silenceThreshold)adcStatus|=SILENT2; else adcStatus&=~SILENT2;
	if(ch[2].bin<=silenceThreshold)adcStatus|=SILENT3;	else adcStatus&=~SILENT3;
	if(ch[3].bin<=silenceThreshold)adcStatus|=SILENT4; else adcStatus&=~SILENT4;
}

/*
void setBinLevels(void)
{
	int i;
	for(i=0; i<OUTPUT_CHANNELS; i++)
	{
	setOutputLevel(ch[i].bin, i, FFT_MODE);
	}
}
*/

void setOutputs(void)
{
	// depending on the chaser mode.
	int i, j;
	
	j=((mainMode>> MODE_CHASER_BIT_SHIFT) & MODE_CHASER_CLEAR);
	if(j==MODE_CHASER_OFF)
	{
		for(i=0; i<OUTPUT_CHANNELS; i++)setOutputLevel(ch[i].bin, i, FFT_MODE);
	}
	else
	{
		// here we service the current chaser object...
		if((j==MODE_CHASER_TRIGGERED)||(j==MODE_CHASER_AUTO))
		{
			// triggered or Auto modes
			if((trigger & TRIGGER_ON)!=0){
				if(Chaser.ip!=NULLP)Chaser.ip=decodeInstructionAndData(&Chaser); else if(j==MODE_CHASER_TRIGGERED)setChaserPointer(&Chaser, Chaser.currentProgram); else setChaserPointer(&Chaser, getRandom());
			}	
		} else
		{
		// here we service the NORMAL mode
				if(Chaser.ip!=NULLP)Chaser.ip=decodeInstructionAndData(&Chaser); else setChaserPointer(&Chaser, Chaser.currentProgram);
		}
	}
	if((trigger & TRIGGER_ON)!=0)trigger=TRIGGER_OFF;				// acknowledge
}
//*************************************************************************************************************************
// Main Loop Display SubRoutines
//*************************************************************************************************************************
void computeSpectrumInternal(int y)
{
	// compute the spectrum into y equal frequency bands
	fractional *m;
	int i, j, k;

	// assumes FFT data
	m=&adcPtr->real;
	k=FFT_BLOCK_LENGTH>>1;
	k=__builtin_divsd(k, y);
	for(i=0; i<y; i++)
	{
		spectrum[i]=0;
		for(j=0; j<k; j++)
		{
		spectrum[i]+=*m++;
		}
		spectrum[i]=__builtin_divsd(spectrum[i], k);
	}
}

void drawSpectrumFine(void)
{
	int i;
	// assumes FFT data
	computeSpectrumInternal(DISPLAY_COLUMNS);
	for(i=0; i<DISPLAY_COLUMNS; i++)
	{
	display[i]=(unsigned int)convertToBar(spectrum[i], 8);
	}
	updownShift=0;
}

void idrawHorizontalLevels(void)
{
	int i, j, k, l, m;

	BlankScreen();
	display[0]=0x007F;
	m=1;
	for(i=1; i<DISPLAY_COLUMNS; i++)
	{
		k=0;
		l=0x0040;
		for(j=0; j<DISPLAY_ROWS;j++)
		{
		if((convertToBar(oldisplay[j], 8) & m)!=0)k|=l;
		l=l>>1;
		}
	display[i]=k;
	m=m<<1;
	}
	UnBlankScreen();
}

void drawChannels(int mod)
{
	int i, k, n;

	k=0;
	for(i=0; i<OUTPUT_CHANNELS; i++)
	{
	if(((mod & DRAWCHANNELS_QUIESCENT)==0)||(ch[i].outputLevel>ch[i].quiescentLevel))n=ch[i].outputLevel; else n=(ch[i].quiescentLevel>>QUIESCENT_DIVISOR_LOG2);
	oldisplay[k++]=n;
	oldisplay[k++]=0;
	}
	if((mod & DRAWCHANNELS_ENVELOPE)!=0){
					for(i=0; i<DISPLAY_ROWS; i+=2)
					{
					oldisplay[1+i]=(oldisplay[i]+oldisplay[i+2])>>1;
					}
	}
	idrawHorizontalLevels();
}

void drawSpectrumCentre(void)
{
	int i;
	// assumes FFT data
	computeSpectrumInternal(8);
	for(i=0; i<8; i++)
	{
	display[i]=(unsigned int)convertToBar(spectrum[i], 8);
	display[14-i]=display[i];
	}
	updownShift=0;
}

void drawSpectrumWide(void)
{
	int i;
	unsigned int u;
	// assumes FFT data
	computeSpectrumInternal(5);
	for(i=0; i<5; i++)
	{
	u=(unsigned int)convertToBar(spectrum[i], 8);
	display[i*3]=u;
	display[i*3+1]=u;
	display[i*3+2]=u;
	}
	updownShift=0;
}

long computeRMS(void)
{
	// compute the RMS of raw data
	// assumes FFT data
	int i;
	long t, f;
	fractional *m;

	m=&adcPtr->real;
	f=0;
	for(i=0; i<(FFT_BLOCK_LENGTH); i++)
	{
		t=*m++;
		if(t<0)f-=t; else f+=t;
	}
	return (f>>RMS_SCALING_FACTOR_LOG2);
}

/*
void drawVUMeterDigital(void)
{
	// assumes ADC (raw) waveform data
	// computes the RMS
	int i;

	if(timeOut()){
		setTimeOut(VUANALOG_TIMEOUT);
		clearDisplay(DISPLAY_OFF);
		cursor=2;
		updownShift=-DISPLAY_ROWS;
		disWDotsdecimal(floor(VUDIGITAL_FACTOR*computeRMS()), 1, 2);
		for(i=0; i<8; i++){ updownShift++; DelayMsInt(UPDOWN_DELAY); }
		}
}
*/

const unsigned char Needle[] __attribute__((space(auto_psv), aligned(2)))=
        {    	
		0x08,0x10,0x20,0x40,0x40,0x40,0x40,0x40,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7F,
		0x00,0x00,0x00,0x00,0x00,0x00,0x78,0x07,
		0x00,0x00,0x00,0x00,0x00,0x30,0x0C,0x03,
		0x00,0x00,0x00,0x00,0x20,0x18,0x06,0x01,
		0x00,0x00,0x00,0x20,0x10,0x08,0x04,0x03,
		0x00,0x00,0x20,0x10,0x08,0x04,0x02,0x01,
		0x00,0x00,0x10,0x08,0x04,0x02,0x01,0x01,
		0x00,0x00,0x08,0x04,0x04,0x02,0x02,0x01,
		0x00,0x08,0x04,0x04,0x02,0x02,0x01,0x01,
		0x00,0x04,0x04,0x02,0x02,0x01,0x01,0x01,				// last needle data
		};

void drawMeter(DOUBLE ff)
{
	int r, i, f;
		updownShift=0;
		f=(int)ff;
		if(f>19)f=19;
		if(f<0)f=0;
		if((f>=0)&&(f<=9)){ r=10-f; f=0; }	else { r=f-9; f=1; }
		for(i=0; i<8; i++)
		{
		if(f==0){ display[14-i]=Needle[i]; display[i]=(Needle[i]|Needle[r*8+i]); }
		else    { display[i]=Needle[i]; display[14-i]=(Needle[i]|Needle[r*8+i]); }
		}
}

void drawVUMeterAnalog(void)
{
	ftemp+=(VUANALOG_FACTOR*rms);
	ftemp/=2.0;
	if(ftemp>temp)temp++; else if(ftemp<temp)temp--;
	if(temp>19)temp=19; else if(temp<0)temp=0;
	drawMeter(temp);
}

void drawOscilloscopeRMS(void)
{
	int i;
	updownShift=0;
	ftemp=(OSC_FACTOR*rms);
	if(ftemp>temp)temp+=16; else if(ftemp<temp)temp-=16;
	if(temp>255)temp=255; else if(temp<0)temp=0;
	BlankScreen();
	for(i=1; i<DISPLAY_COLUMNS; i++)display[i-1]=display[i];
	display[DISPLAY_COLUMNS-1]=(1 | (convertToBar(temp, 8)));
	UnBlankScreen();
}

/*
void drawOscilloscope(void)
{
	DOUBLE f;
	int oxx, xx, dp, i, j;
	fractcomplex *p;
	// assumes raw data.
	p=adcPtr;
	updownShift=0;
	f=(DOUBLE)p->real;
	f=3.0+(1.5+2.0*f/HALF_INT);
	xx=(int)f;
	oxx=xx;
	if(1){
	dp=4;
	if(peakFrequency>3000)dp=2;
	if(peakFrequency>10000)dp=1;
	for(i=0;i<DISPLAY_COLUMNS;i++)
	{
	f=(DOUBLE)p->real;
	f=3.0*(1.5+2.0*f/HALF_INT);
	xx=(int)f;
	p+=dp;
	if(xx==oxx)display[i]=(1<<xx); else if(xx<oxx){
							display[i]=0;
							for(j=xx; j<=oxx; j++)display[i]|=(1<<j);
							} else { 
							display[i]=0;
							for(j=oxx; j<=xx; j++)display[i]|=(1<<j);
							}

		oxx=xx;
		}
	DelayMs(OSCILLOSCOPE_DELAY);
	}
}
*/
	
//***************************************************************************************************************
// Screen Savers 
//***************************************************************************************************************
int drawBlank(int y)
{
	updownShift=0;
	if(intCountDownTimer<=0)
	{
		intCountDownTimer=BLANK_TIMEOUT;
		clearDisplay(DISPLAY_OFF);
		return TRUE;
	} else return FALSE;
}

int drawMessage(int y)
{
	updownShift=0;
	if(intCountDownTimer<=0)
	{
		intCountDownTimer=MESSAGE_TIMEOUT;
		cursor=0;
		disFDotsdecimal(freqObj[MAINS_SYNC].freq, 1, SMALL_FONT, DISPLAY_COLUMNS);
		clearUpTo(cursor, DISPLAY_COLUMNS);
		return TRUE;
	} else return FALSE;
}

int drawChaser(int y)
{
	updownShift=0;
	if(intCountDownTimer<=0)
	{
		intCountDownTimer=MESSAGE_TIMEOUT;
		display[0]=0;
		cursor=1;
		displaySmallDecimal(Chaser.currentProgram);
		return TRUE;
	} else return FALSE;
}

int drawSnow(int y)
{
	int i;

	updownShift=0;
	if(intCountDownTimer<=0){
		intCountDownTimer=SNOW_TIMEOUT;
		for(i=0; i<DISPLAY_COLUMNS; i++)
		{
		display[i]=0x003F & (display[i]>>1);
		}
		i=getRandom();
		i=__builtin_modud(i, DISPLAY_COLUMNS);
		display[i]|=0x0040;
		return TRUE;
		} else return FALSE;
}

int drawLife(int y)
{
	// based on John Conway's game of life
	int i, j, n;
	updownShift=0;
	if(screenUpdate==0){
				clearDisplayScrolling();
				for(i=0; i<LIFE_SEED; i++)		
				{
				screenX=__builtin_modud(getRandom(), DISPLAY_COLUMNS);
				screenY=__builtin_modud(getRandom(), DISPLAY_COLUMNS);
				putXY(screenX,screenY);
				putXY(screenX+1,screenY+1);
				putXY(screenX,screenY+1);
				putXY(screenX+1,screenY);
				}
				screenUpdate=1;
				screenTimes=0;
				return TRUE;
				
	} else
	{
	if(intCountDownTimer<=0){
		intCountDownTimer=LIFE_TIMEOUT;
		screenTimes++;
		for(i=0; i<DISPLAY_COLUMNS; i++)
		{
		oldisplay[i]=display[i];
		}		
		screenUpdate=0;
		for(i=0; i<DISPLAY_COLUMNS; i++)
		{
			for(j=0; j<DISPLAY_ROWS; j++)
			{
			n=(getXY(i-1, j-1))+(getXY(i-1, j))+(getXY(i-1, j+1))+(getXY(i,j+1))+(getXY(i,j-1))+(getXY(i+1,j+1))+(getXY(i+1,j))+(getXY(i+1,j-1));
			if((((n<2)||(n>3))&&((getXY(i,j))==1))||((n==3)&&((getXY(i,j))==0))){ putoXY(i,j); screenUpdate=1; }
			}
		}
		for(i=0; i<DISPLAY_COLUMNS; i++)
		{
		display[i]=oldisplay[i];
		}			
		if(screenTimes>=LIFE_TOTAL_TIMES)screenUpdate=0;
		return TRUE;
		} else return FALSE;
	}
}

/*
void drawRandom(void)
{
	updownShift=0;
	if(timeOut()){
		setTimeOut(RANDOM_TIMEOUT);
		screenX=0xFFFE & __builtin_modud(getRandom(), DISPLAY_COLUMNS);					// mask to make even
		screenY=0xFFFE & __builtin_modud(getRandom(), DISPLAY_COLUMNS); 				// mask to make even
		putXY(screenX,screenY);
		putXY(screenX+1,screenY+1);
		putXY(screenX,screenY+1);
		putXY(screenX+1,screenY);
	}
}

void drawBall(void)
{

	updownShift=0;
	if(oldviewMode!=viewMode){
						ox=-2;
						x=2;
						y=2;
						dx=1;
						dy=1;
						clearDisplayScrolling();
						}

	if(timeOut()){
		putXY(ox , oy);
		putXY(ox+1, oy+1);
		putXY(ox+1, oy);
		putXY(ox, oy+1);
		ox=x; oy=y;
		putXY(x , y);
		putXY(x+1, y+1);
		putXY(x+1, y);
		putXY(x, y+1);
		x+=dx; y+=dy;
		if((x<0)||(x>=(DISPLAY_COLUMNS-2)))dx=-dx;
		if((y<0)||(y>=5))dy=-dy;
		setTimeOut(BALL_TIMEOUT);
		while(!timeOut())wait();
		setTimeOut(BALL_TIMEOUT);
	}
}
*/
//**************************************************************************************************************************
//*************************************************************************************************************
//*************************************************************************************************************
//*************************************************************************************************************
//
// Some calibration Subroutines
//
//*************************************************************************************************************
//*************************************************************************************************************
//*************************************************************************************************************
int getTuning(void)
{
	// returns 4 bit tuning bits from OSCCON for the FRC (fast internal RC oscillator at 7.37MHz)

	return (0x000F & (((OSCCON>>12)&0x0C)|((OSCCON>>10)&0x03)));
}

int putTuning(unsigned char tun)
{
	// puts the 4 bit tuning value tun into OSCCON register to tune the internal fast RC oscillator- use sparingly!
	int i;
	tun=(tun & 0x000F);
	i=readEEPROMInt(TUN_ADDRESS);
	if(tun!=i)writeEEPROMInt(TUN_ADDRESS, tun);
	tun=((0x0033&(OSCCON>>8))|((tun & 0x000C)<<4)|((tun & 0x0003)<<2));
	i=0x00FF & (OSCCON>>8);
	if(i!=tun)__builtin_write_OSCCONH(tun);
	return 0;
}

int calibrateTuning(DOUBLE freqtarget)
{
	// It adjusts the tuning bits for the fast internal RC oscillator compared to the mains line frequency
	// returns the square of the error of the minimum used
	int i, j;
	DOUBLE min;
	DOUBLE error[16];

	fcy=FCY;
	LEDS=0;
	FLASHING=0;
	for(i=0; i<MAINS_AVERAGING_COUNT; i++)waitForUpdated(MAINS_SYNC);
	DelayMs(STARTUP_TIME_DELAY);
	for(i=0; i<16; i++)
	{
	LEDS=channelLED((i & 0x03));
	putTuning((unsigned char)i);
//	waitForUpdated(MAINS_SYNC);
	waitForUpdated(MAINS_SYNC);
	error[i]=(freqObj[MAINS_SYNC].freq-freqtarget);
	error[i]=error[i]*error[i];
	}
	j=0;
	min=error[0];
	for(i=1; i<16; i++)
	{
	if(error[i]<min){
		j=i;
		min=error[i];
		}
	}
	putTuning((unsigned char)j);
	LEDS=0;
	return min;
}

void updateAllSettings(void)
{
	int i;
	setmaxPhaseOffset(mainsFreq);
	initADC4(adcSamplingFreq, TADS);
	setScreenParameters(screenBrightness, screenFrequency);
	setCmCl(Cm, Cl);
	for(i=0; i<OUTPUT_CHANNELS;i++){
			setGain(ch[i].gain, i);
			setQuiescentLevel(ch[i].quiescentLevel, i, NORMAL_MODE);
	}
}

DOUBLE calibrateFCY(DOUBLE freqtarget)
{
	// It adjusts the internal fcy value from the theoretical to bring the measured line frequency with the theoretical value
	// this should be called *after* the calibrateTuning() function
	// returns the correcting factor used
	DOUBLE correcting_factor;
	unsigned int *p;
		
	fcy=FCY;
	waitForUpdated(MAINS_SYNC);
	correcting_factor=1.0;
	if(freqtarget>0.0)
	{ 						correcting_factor=((freqObj[MAINS_SYNC].freq)/freqtarget);
							fcy*=correcting_factor; 
							p=(unsigned int *)&fcy;
							writeEEPROMInt(FCY_ADDRESS, *p++);
							writeEEPROMInt(FCY_ADDRESS+1, *p++);
							updateAllSettings(); 
	}
	// if the measured frequency freqObj[MAINS_SYNC].freq is higher then correcting factor will be > 1.0 and fcy will increase so measured will decrease
	return correcting_factor;
}

/*
DOUBLE calibrateTriacs(void)
{
	int i, k;
	DOUBLE progress;
	int p0store, p1store;
	// this calibrates the phase0 and phase1 values using the users input
	p0store=PHASE0_MIN;
	p1store=PHASE1_MIN;

	outputEnable=OUTPUTENABLE_ALLOFF;
	for(i=0; i<OUTPUT_CHANNELS; i++)
	{
	setOutputLevel(255, i, NORMAL_MODE);
	setQuiescentLevel(0, i, NORMAL_MODE);
	}
	phase0=PHASE0_MAX;
	phase1=PHASE1_MAX;
	printstringDots("   Phase 0: Press Key When Light Turns Off   ",0,0);
	while(getKey()!=KEY6)wait();
	
	outputEnable=PHASE0_MASK;		// turn on all channels in phase 0 only
	k=0;
	while((k!=KEY7)&&(phase0>PHASE0_MIN))
	{
	phase0-=2;
	progress=19.0*((phase0-PHASE0_MIN)/(PHASE0_MAX-PHASE0_MIN));
	drawMeter(progress);
	DelayMs(10);
	k=getKey();
	}
	p0store=phase0;
	outputEnable=OUTPUTENABLE_ALLOFF;
	printstringDots("Phase 0 Done   ",0,0);
	
	phase0=PHASE0_MAX;
	phase1=PHASE1_MAX;
	
	printstringDots("   Phase 1: Press Key When Light Turns Off   ",0,0);
	while(getKey()!=KEY6)wait();
	
	outputEnable=PHASE1_MASK;		// turn on all channels in phase 1 only
	k=0;
	while((k!=KEY7)&&(phase1>PHASE1_MIN))
	{
	phase1-=2;
	progress=19.0*((phase1-PHASE1_MIN)/(PHASE1_MAX-PHASE1_MIN));
	drawMeter(progress);
	DelayMs(10);
	k=getKey();
	}
	p1store=phase1;
	printstringDots("Phase 1 Done   ",0,0);
	outputEnable=OUTPUTENABLE_ALLOFF;
	for(i=0; i<OUTPUT_CHANNELS; i++)
	{
	setOutputLevel(0, i, NORMAL_MODE);
	setQuiescentLevel(0,i, NORMAL_MODE);
	}
	phase0=p0store+PHASE0_CALOFFSET;
	phase1=p1store+PHASE1_CALOFFSET;
	outputEnable=OUTPUTENABLE_ALLON;

	printstringDots("   Results:",0,0);
	waitForKey();
	printstringDots("  0:",0,0);
	disWDotsdecimalSigned(p0store, 0,0);
	printstringDots("  1:",0,0);
	disWDotsdecimalSigned(p1store, 0,0);
	printstringDots("  Done. ",0,0);
	waitForKey();
	return 0;
}

DOUBLE calibrateTriacsAuto(void)
{
	// this calibrates the phase0 and phase1 values using the users input
	printstringDots("  Auto...   ",0,0);
	return 0;
}

DOUBLE calibrateDutyAndFrequency(DOUBLE dutymin, DOUBLE dutymax, DOUBLE freqmin, DOUBLE freqmax)
{
	DOUBLE duty, freqq;
	int p0store, p1store;

	p0store=phase0;
	p1store=phase1;
	outputEnable=OUTPUTENABLE_ALLOFF;
	allOutputs(255);
	printstringDots("   Begin Duty Detect  ",0,0);
	outputEnable=OUTPUTENABLE_ALLON;		// turn on all channels in phase 0 only
	freqq=0.0; 
	duty=0.0;
	while((duty>dutymax)||(duty<dutymin)||(freqq<freqmin)||(freqq>freqmax))
	{
	waitForUpdated(OC1_TRIGGER);
	duty=freqObj[OC1_TRIGGER].duty;
	freqq=freqObj[OC1_TRIGGER].freq;
	if(duty<dutymin)phase0--;
	if(duty>dutymax)phase0++;
	if(freqq<freqmin)phase1--;
	if(freqq>freqmax)phase1++;
	}
	outputEnable=OUTPUTENABLE_ALLOFF;
	printstringDots("   Results:",0,0);
	waitForKey();
	printstringDots("  0:",0,0);
	disWDotsdecimalSigned(phase0, 0,0);
	printstringDots("  1:",0,0);
	disWDotsdecimalSigned(phase1, 0,0);
	printstringDots("  Done.  ",0,0);
	waitForKey();
	phase0=p0store;
	phase1=p1store;
	return 0;
}

*/

DOUBLE calibrateAll(DOUBLE freqtarget)
{
	// freqtarget= the theoretical mains line frequency to try to calibrate to...
	// returns the percentage error...
	DOUBLE error;
	
	error=calibrateTuning(freqtarget);
	error=calibrateFCY(freqtarget);
	return (error);
}


/*
void stateEqualizer(int y)
{ 
	chaserObject cO;
	chaserObject* chobj;
	int k;
	int channelnum;

	channelnum=2;
	LEDS=LED3;
	FLASHING=LED3;
	k=waitForKey();
	if(k==KEY3){
			printstringDots("Starting... ",0,0);
			cO.ip=(int*)&myProgram[0];
			cO.channel=channelnum;
			cO.attack=0;
			cO.decay=0;
			cO.acc=0;
			chaserTimeOut=CHASER_TIMEOUT_INITIAL;
			ch[channelnum].attack=0x0002;
			ch[channelnum].decay=0x004;
			setOutputLevel(channelnum, 0x000, NORMAL_MODE);
			setQuiescentLevel(channelnum, 0x0000, NORMAL_MODE);
			chobj=&cO;
		while(chobj->ip!=NULLP)
		{
		chobj->ip=decodeInstructionAndData(chobj);
		}	
		flushKeys();
		while(noKeys())printstringDots(" Finished... ",0,0);
		LEDS=0;
		
	}
}

void stateDefaults(int y){ 

	testOutputs();
}
*/

/*
void statePhaseControl(int y)
{ 
	unsigned int j, k;
	char buf[2];
	outputEnable=OUTPUTENABLE_ALLON;
	setOutputLevel(255,0, NORMAL_MODE);
	setOutputLevel(255,1, NORMAL_MODE);
	setOutputLevel(255,2, NORMAL_MODE);
	setOutputLevel(255,3, NORMAL_MODE);
	k=NOKEY;
	while(k!=KEY7){
		while((k=getKey())<0);
		if(k==KEY1)phase0+=50; 
		if(k==KEY2)phase0-=50;
		if(k==KEY3)phase1+=50;
		if(k==KEY4)phase1-=50;
		if(k==KEY5){printstringDots("DUT:",0,0); disFDotsdecimalSigned(freqObj[OC3_TRIGGER].duty, 2); printstringDots("FRQ:",0,0); disFDotsdecimalSigned(freqObj[OC3_TRIGGER].freq, 2); printstringDots("POS:",0,0); disFDotsdecimalSigned(freqObj[OC3_TRIGGER].posperiod, 2); }
		if((k==KEY1)||(k==KEY2)||(k==KEY3)||(k=KEY4)){ printstringDots(" 0:",0,0); disWDotsdecimalSigned(phase0,0,0); printstringDots("  1:",0,0); disWDotsdecimalSigned(phase1,0,0); printstringDots(" ",0,0); }
		waitForKey();
	}

}

void stateDimmingCurve(int y){

	int dd, k;
	
outputEnable=OUTPUTENABLE_ALLON;
	dd=0;
	setOutputLevel(dd,0, NORMAL_MODE);
	setOutputLevel(dd,1, NORMAL_MODE);
	setOutputLevel(dd,2, NORMAL_MODE);
	setOutputLevel(dd,3, NORMAL_MODE);
	setQuiescentLevel(0,0, NORMAL_MODE);
	setQuiescentLevel(0,1, NORMAL_MODE);
	setQuiescentLevel(0,2, NORMAL_MODE);
	setQuiescentLevel(0,3, NORMAL_MODE);
	k=NOKEY;
	while(k!=KEY7){
		while(noKeys());
		if(k==KEY1)pulseError[0]+=25; 
		if(k==KEY2)pulseError[0]-=25;
		if(k==KEY3)pulseError[1]+=25;
		if(k==KEY4)pulseError[1]-=25;
		if((k==KEY1)||(k==KEY2)||(k==KEY3)||(k=KEY4)){ printstringDots("  R0:",0,0); disWDotsdecimalSigned(pulseError[0],0,0); printstringDots("  R1:",0,0); disWDotsdecimalSigned(pulseError[1],0,0); }
		while((k=getKey())<0){ analogLock=0; dd=(rawPotValue>>2); setOutputLevel(dd,0, NORMAL_MODE); setOutputLevel(dd,1, NORMAL_MODE); setOutputLevel(dd,2, NORMAL_MODE); setOutputLevel(dd,3, NORMAL_MODE); };
	}

}

void stateChaserMode(int y){ 
		 int k;

			ch[0].mode=STROBE_MODE;		
			setOutputLevel(0,0, NORMAL_MODE);
			while(noKeys())
			{
			disWDots(ch[0].strobe,0);
			k=waitForKey();
			if(k==KEY1)setOutputLevel(ch[0].strobe+1, 0, NORMAL_MODE);
			if(k==KEY2)setOutputLevel(ch[0].strobe-1, 0, NORMAL_MODE);
			}
}
*/

/*
void stateInputBalance(int y){
	
	int k;
	unsigned long u;
	DOUBLE f;
	
	k=NOKEY;
	lockAnalog();
	LEDS=LED2 | LED1;
	FLASHING=LED2 | LED1;
	setTimeOut(0);
	currentPointer=0;
	flashColumns(0, 4);
	while(k!=KEY1)
	{
		
		while((noKeys()))
		{
				if(timeOut()){	displayThreeBars(iC[CHANNELMIC], iC[CHANNELL], iC[CHANNELR], FIXED_DENOMINATOR_LOG2); setTimeOut(DISPLAY_TIMEOUT); }
				if(currentPointer==0)
				{
					if(analogLock==0){
						setCmCl(getFloatInverseiC(CHANNELMIC, analogFloat()), Cl);
					} else { unlockAnalog(iC[CHANNELMIC], FIXED_DENOMINATOR_LOG2); }

				} else
				{
					if(analogLock==0){
						setCmCl(Cm, getFloatInverseiC(CHANNELL, analogFloat()));
					} else { unlockAnalog(iC[CHANNELL], FIXED_DENOMINATOR_LOG2); }
				}
		}
		k=getKey();
		if(k==KEY2){ changeValueModulo(&currentPointer, currentPointer+1, 2); lockAnalog(); 
						if(currentPointer==0)flashColumns(0, 4); else flashColumns(5, DISPLAY_COLUMNS-1);
					}
	}
	flashSet(FLASH_OFF);
}

void stateBalance(int y){

	while(noKeys()){
		printstringDots(" PEAK:",0,0);
		disWDotsdecimal(peakFrequency,0,0);
		DelayMs(500);
	}
}	

void stateSensitivity(int y){
	disWDotsdecimal(TMR4, 0, 0);
}

void stateCalibrate(int y){
	
	//DOUBLE err;
	//err=0.0;
	//err=calibrateAll(mainsFreq);
	//printstringDots("  Done...   ",0,0);
	//disFDotsdecimalSigned(err,3);
	int k;

	k=NOKEY;
	while(k!=KEY7)
	{
		printstringDots("  ADC(Hz)=",0,0);
		disWDotsdecimal(8.0*freqObj[ADC_ACQUIRE].freq, 0, 0);
		flushKeys();
		k=waitForKey();
		if(k==KEY1)initADC4(adcSamplingFreq+1000, TADS);
		if(k==KEY3)initADC4(adcSamplingFreq-1000, TADS);
	}
}

*/
//*****************************************************************************
//
// Finite State Machine Functions
//
//*****************************************************************************
//
void stateInitial(int y)
{ 
	// entering the menu system finite state machine...	
}

void stateMenu(int y)
{
	// empty for now...
}

void stateReset(int y)
{
	// we reset the microcontroller
	asm("reset");
}

void stateMasterReset(int y)
{
	// clears all boot ups too..
	int i;
	i=readEEPROMInt(MAGIC_EEPROM_ADDRESS);
	writeEEPROMInt(MAGIC_EEPROM_ADDRESS,i+1);
	asm("reset");
}

void stateTestOutputs(int y)
{
	testOutputs();	
}
//*************************************************************************************************************************
// Internal State Helper Functions
//*************************************************************************************************************************
int identityFunction(int x)
{
	return x;
}

int internalVary(int *y, int bits, void (*setInternalFunction)(int),  void (*displayInternalFunction)(int), int (*unlockAnalogReturnFunction)(int), int mode, void(*addFunction)(int))
{
	long f, of;
	int k;
	
	clearDisplay(DISPLAY_OFF);
	of=-1;
	lockAnalog();
	setTimeOut(0);
	FLASHING=0;
	LEDS|=LED2;
	k=NOKEY;
	if((mode==2)||(mode==3))LEDS|=(LED1 | LED3);
	while(k!=KEY2)
	{
	while(noKeys())
	{
		if(analogLock==1)FLASHING|=LED2; else FLASHING&=~LED2;
		
		if(timeOut()){
					cursor=0;
					displayInternalFunction(*y);
					setTimeOut(REDRAW_TIMEOUT);
					}
		
		if(analogLock==0)
		{ 
		f=(long)rawPotValue;
		f=f<<bits;
		f=f>>ADC_LOG2;	 
		if(f!=of){ 
				setInternalFunction(f); 
				//displayInternalFunction(*y);
				of=f; 
				}
		} 
		else unlockAnalog(unlockAnalogReturnFunction(*y), bits);
	}
	k=getKey();
	//lockAnalog();
	if((mode==1)&&((k==KEY4)||(k==KEY5)||(k==KEY6)||(k==KEY7)))break;
	if((mode==2)||(mode==3))
		{
		if(k==KEY1){ setTimeOut(0); addFunction(1); DelayMs(KEY_WAIT_DELAY); k=keyPressed(); while(k==KEY1){ FLASHING|=LED1; addFunction(1); displayInternalFunction(*y); DelayMs(KEY_REPEAT_DELAYMS); k=keyPressed(); } k=KEY1; FLASHING&=~LED1; }	
		if(k==KEY3){ setTimeOut(0); addFunction(-1); DelayMs(KEY_WAIT_DELAY); k=keyPressed(); while(k==KEY3){ FLASHING|=LED3; addFunction(-1); displayInternalFunction(*y); DelayMs(KEY_REPEAT_DELAYMS); k=keyPressed(); } k=KEY3; FLASHING&=~LED3; }		
		if(mode==3){ lockAnalog(); }
		}
	}
	return k;
}

//
void displaySmallDecimal(int y)
{
	disWDotsdecimalLimited(y, 1, 0, DISPLAY_COLUMNS);
	clearUpTo(cursor, DISPLAY_COLUMNS);
}

void displayBigDecimal(int y)
{
	disWDotsdecimalLimited(y, 0, 0, DISPLAY_COLUMNS);
	clearUpTo(cursor, DISPLAY_COLUMNS);
}

void displayBigDecimalMemory(int y)
{
	cursor=0;
	printstringDots("M",BIG_FONT,0);
	disWDotsdecimalLimited(y+1, 0, 0, DISPLAY_COLUMNS);
	clearUpTo(cursor, DISPLAY_COLUMNS);
}

int printTimeUnit(DOUBLE f, int totaldigits, char *unit)
{
	DOUBLE m, h;
	int i, k, numdec;

	f=f*((T45TIME_PRESCALE*FCY100H*256.0)/FCY);
	// now f is in seconds
	m=f/60.0;
	// m is in minutes
	h=f/3600.0;
	// h is in hours
	i=NUM_DIGITS;
	if(m<1.0){
		numdec=totaldigits-numberOfDecimalDigits(f)-2;
		clip(&numdec, 0, NUM_DIGITS);
		k=printFDecimalNoRounding(f, numdec, 1);
		if(buffer[i]!='.')i++;
		buffer[i++]=0;
		*unit='s';
	} else
	if(m<60.0)
	{
		numdec=totaldigits-numberOfDecimalDigits(m)-2;
		clip(&numdec, 0, NUM_DIGITS);
		k=printFDecimalNoRounding(m, numdec, 1);
		if(buffer[i]!='.')i++;
		buffer[i++]=0;
		*unit='m';
	}
	else
	{
		numdec=totaldigits-numberOfDecimalDigits(h)-2;
		clip(&numdec, 0, NUM_DIGITS);
		k=printFDecimalNoRounding(h, numdec, 1);
		if(buffer[i]!='.')i++;
		buffer[i++]=0;
		*unit='h';
	}
	return k;
}

void displayTimeUnit(DOUBLE y, int totaldigits, int font, int maxcols)
{
	// y is in Timer 5 units typically 100ms
	int k;
	char unit;
	k=printTimeUnit(y, totaldigits, &unit);
	printstringDots(&buffer[k], font, maxcols-5);
	if(unit=='s')
	{
	sendcolumn(0x08);
	sendcolumn(0x15);
	sendcolumn(0x15);
	sendcolumn(0x02);
	} else
	if(unit=='m')
	{
	sendcolumn(0x0F);
	sendcolumn(0x10);
	sendcolumn(0x0C);
	sendcolumn(0x10);
	sendcolumn(0x0F);
	} else
	{
	sendcolumn(0x1F);
	sendcolumn(0x04);
	sendcolumn(0x04);
	sendcolumn(0x03);
	}
}

void internalVaryChannels(int* y, int bits, void (*setInternalFunction)(int), void (*displayInternalFunction)(int), int (*inverse)(int), void (*sameChannelFunction)(int))
{
	int k;
	k=NOKEY;
	while(k!=KEY2){
		LEDS&=~CHANNEL_LEDS;
		LEDS|=(LED2 | (channelLED(currentChannel)));
		k=internalVary(y, bits, setInternalFunction, displayInternalFunction, inverse, 1, &emptyFunction);
		if(k==KEY4){ if(currentChannel!=CH1){ changeValueModulo(&currentChannel, CH1, OUTPUT_CHANNELS); } else sameChannelFunction(CH1); lockAnalog(); }
		if(k==KEY5){ if(currentChannel!=CH2){ changeValueModulo(&currentChannel, CH2, OUTPUT_CHANNELS); } else sameChannelFunction(CH2); lockAnalog(); }
		if(k==KEY6){ if(currentChannel!=CH3){ changeValueModulo(&currentChannel, CH3, OUTPUT_CHANNELS); } else sameChannelFunction(CH3); lockAnalog(); }
		if(k==KEY7){ if(currentChannel!=CH4){ changeValueModulo(&currentChannel, CH4, OUTPUT_CHANNELS); } else sameChannelFunction(CH4); lockAnalog(); }
	}
	k=getKey();
}

//*************************************************************************************************************************
// Dimmer Functions
//*************************************************************************************************************************
void internalSetDimmerFunction(int y)
{
	setOutputLevel(y, currentChannel, NO_UPDATE_MODE);
}

void internalDisplayDimmerFunction(int y)
{
	displayBar(ch[currentChannel].outputLevel, 0);
	//displayBar(y, 0);
}

int inverseDimmerFunction(int y)
{
	return ch[currentChannel].outputLevel;
}

void sameDimmerFunction(int chn)
{

	FLASHING|=channelLED(chn);
	if(ch[chn].outputLevel>0)
	{
		// dim to zero
		while(ch[chn].outputLevel!=0){
				setOutputLevel(ch[chn].outputLevel-1, chn, NO_UPDATE_MODE);
				displayBar(ch[chn].outputLevel, 1);
				DelayMs(AUTO_DIM_DELAY);
		}
	} else
	{
		// go to full brightness
		while(ch[chn].outputLevel!=0xFF)
			{
				setOutputLevel(ch[chn].outputLevel+1, chn, NO_UPDATE_MODE);
				displayBar(ch[chn].outputLevel, 1);
				DelayMs(AUTO_DIM_DELAY);
			}
	}
	FLASHING&=~channelLED(chn);
}

// State Dimmer Function
void stateDimmer(int y)
{
	internalVaryChannels(&y, 8, &internalSetDimmerFunction, &internalDisplayDimmerFunction, &inverseDimmerFunction, &sameDimmerFunction);
}
//*************************************************************************************************************************
// Quiescent Current Functions
//*************************************************************************************************************************
void internalSetQuiescentFunction(int y)
{
	setQuiescentLevel(y, currentChannel, NO_UPDATE_MODE);
}

void internalDisplayQuiescentFunction(int y)
{
	displayBar(ch[currentChannel].quiescentLevel, 0);
}

int inverseQuiescentFunction(int y)
{
	return ch[currentChannel].quiescentLevel;
}

void stateQuiescent(int y)
{
	allOutputs(1);
	internalVaryChannels(&y, 8, &internalSetQuiescentFunction, &internalDisplayQuiescentFunction, &inverseQuiescentFunction, &emptyFunction);
}
//*************************************************************************************************************************
// State Com Function
//*************************************************************************************************************************
void stateCom(int y)
{
	unsigned int c;
	c=0;
	printstringDots("  Echo:",0,0);
	while((noKeys())&&(c!=ESCAPE_CHAR)){
		c=getFromUart();
		if(c!=UART_ERROR){ printcharDots(c, 0, 0, TO_SCREEN); putToUart(c); }
	}
	c=getKey();	
}

void stateComHex(int y)
{
	unsigned int c;
	c=0;
	printstringDots("  Echo:",0,0);
	while((noKeys())&&(c!=ESCAPE_CHAR)){
		c=getFromUart();
		if(c!=UART_ERROR){ disADots(c, BIG_FONT); printcharDots(' ',BIG_FONT,0,TO_SCREEN); putToUart(c); }
	}
	c=getKey();	
}
//
//
//

void internalSetAndRunEnum(int *y, int dy, int initial, int *enump, int cur, void (*runFunction)(int), void (*displayFunction)(int))
{
	int k, total;
	int index;
	int *t;

	t=enump;
	index=0;
	total=0;
	while((*t)>=0)
	{
		if((*t)<=initial)index=total;
		t++;
		total++;
	}
	*y=*(enump+index);
	LEDS=(LED1 | LED2 | LED3);
	k=NOKEY;
	while(k!=KEY2){
			FLASHING=LED2;
			cursor=cur;
			*y=*(enump+index);
			displayFunction(*y);
			k=waitForKey();
	if(k==KEY1){ changeValueModulo(&index, index+dy, total); DelayMs(KEY_WAIT_DELAY); k=keyPressed(); while(k==KEY1){ FLASHING|=LED1; changeValueModulo(&index, index+dy, total); cursor=cur; *y=*(enump+index); displayFunction(*y); DelayMs(KEY_REPEAT_DELAYMS); k=keyPressed(); } k=KEY1; FLASHING&=~LED1; }	
	if(k==KEY2){ *y=*(enump+index); runFunction(*y); }
	if(k==KEY3){ changeValueModulo(&index, index-dy, total); DelayMs(KEY_WAIT_DELAY); k=keyPressed(); while(k==KEY3){ FLASHING|=LED3; changeValueModulo(&index, index-dy, total); cursor=cur; *y=*(enump+index); displayFunction(*y); DelayMs(KEY_REPEAT_DELAYMS); k=keyPressed(); } k=KEY3; FLASHING&=~LED3; }
	}
}

void internalSetAndRun(int *y, int dy, int modulo, int cur, void (*runFunction)(int), void (*displayFunction)(int), int noblocking)
{
	int k;

	LEDS|=(LED1 | LED2 | LED3);
	k=NOKEY;
	while(k!=KEY2){
			FLASHING|=LED2;
			cursor=cur;
			displayFunction(*y);
			if(noblocking==0)k=waitForKey(); else k=getKey();
	if(k==KEY1){ changeValueModulo(y, (*y)+dy, modulo); DelayMs(KEY_WAIT_DELAY); k=keyPressed(); while(k==KEY1){ FLASHING|=LED1; changeValueModulo(y, (*y)+dy, modulo); cursor=cur; displayFunction(*y); DelayMs(KEY_REPEAT_DELAYMS); k=keyPressed(); } k=KEY1; FLASHING&=~LED1; setTimeOut(0); }	
	if(k==KEY2){ runFunction(*y); }
	if(k==KEY3){ changeValueModulo(y, (*y)-dy, modulo); DelayMs(KEY_WAIT_DELAY); k=keyPressed(); while(k==KEY3){ FLASHING|=LED3; changeValueModulo(y, (*y)-dy, modulo); cursor=cur; displayFunction(*y); DelayMs(KEY_REPEAT_DELAYMS); k=keyPressed(); } k=KEY3; FLASHING&=~LED3; setTimeOut(0); }
	}
}

void internalSetAndRunDy(int *y, int dy, int my, int cur, void (*runFunction)(int), void (*displayFunction)(int))
{
	// dy= delta, my=maximum
	int k;

	LEDS|=(LED1 | LED2 | LED3);
	k=NOKEY;
	while(k!=KEY2){
			FLASHING|=LED2;
			cursor=cur;
			displayFunction(*y);
			k=waitForKey();
	if(k==KEY1){ *y+=dy; clip(y, 0, my); DelayMs(KEY_WAIT_DELAY); k=keyPressed(); while(k==KEY1){ FLASHING|=LED1; *y+=dy; clip(y, 0, my); cursor=cur; displayFunction(*y); DelayMs(KEY_REPEAT_DELAYMS); k=keyPressed(); } k=KEY1; FLASHING&=~LED1; }	
	if(k==KEY2){ runFunction(*y); }
	if(k==KEY3){ *y-=dy; clip(y, 0, my); DelayMs(KEY_WAIT_DELAY); k=keyPressed(); while(k==KEY3){ FLASHING|=LED3; *y-=dy; clip(y, 0, my); cursor=cur; displayFunction(*y); DelayMs(KEY_REPEAT_DELAYMS); k=keyPressed(); } k=KEY3; FLASHING&=~LED3; }
	}
}

void internalSetAndRunDyChannels(int *y, int dy, unsigned int my, int cur, void (*runFunction)(int), void (*displayFunction)(int), void (*addFunction)(int, int), void (*sameChannelFunction)(int))
{
	// dy= delta, my=maximum
	int k, n;

	n=0;
	LEDS|=(LED1 | LED2 | LED3);
	k=NOKEY;
	while(k!=KEY2){
			FLASHING|=LED2;
			LEDS&=~(CHANNEL_LEDS);
			LEDS|=channelLED(currentChannel); 
			cursor=cur;
			displayFunction(*y);
			k=waitForKey();
	if(k==KEY1){ addFunction(dy, my); DelayMs(KEY_WAIT_DELAY); k=keyPressed(); while(k==KEY1){ FLASHING|=LED1; addFunction(dy, my); cursor=cur; displayFunction(*y); DelayMs(KEY_REPEAT_DELAYMS); k=keyPressed(); } k=KEY1; FLASHING&=~LED1; }	
	if(k==KEY2){ runFunction(*y); }
	if(k==KEY3){ addFunction(-dy, my); DelayMs(KEY_WAIT_DELAY); k=keyPressed(); while(k==KEY3){ FLASHING|=LED3; addFunction(-dy, my); cursor=cur; displayFunction(*y); DelayMs(KEY_REPEAT_DELAYMS); k=keyPressed(); } k=KEY3; FLASHING&=~LED3; }
	if(k==KEY4){ if(currentChannel!=CH1){ n=0; changeValueModulo(&currentChannel, CH1, OUTPUT_CHANNELS); } else n++; sameChannelFunction(n); }
	if(k==KEY5){ if(currentChannel!=CH2){ n=0; changeValueModulo(&currentChannel, CH2, OUTPUT_CHANNELS); } else n++; sameChannelFunction(n); }
	if(k==KEY6){ if(currentChannel!=CH3){ n=0; changeValueModulo(&currentChannel, CH3, OUTPUT_CHANNELS); } else n++; sameChannelFunction(n); }
	if(k==KEY7){ if(currentChannel!=CH4){ n=0; changeValueModulo(&currentChannel, CH4, OUTPUT_CHANNELS); } else n++; sameChannelFunction(n); }
	}
}
//
//*************************************************************************************************************************
// Set Display Brightness Functions
//*************************************************************************************************************************
void internalSetDisplayBrightness(int y)
{
	setScreenParameters(y, screenFrequency);
}

void internaldisplayBrightness(int y)
{
	displayBar(y,0);
}

void stateSetDisplayBrightness(int y)
{
	internalVary(&screenBrightness, 8, &internalSetDisplayBrightness, (void*)&internaldisplayBrightness, &identityFunction, 0, &emptyFunction);
}
//*************************************************************************************************************************
// Set Display Frequency Functions
//*************************************************************************************************************************
void internalSetDisplayFrequency(int y)
{ 
	setScreenParameters(screenBrightness, y);
}

void internalSeeDisplayFrequency(int y)
{
	display[0]=0;
	cursor=1;
	updateFreqObj(SCREEN_REFRESH);
	disFDotsdecimal(2.0*freqObj[SCREEN_REFRESH].freq, 1, SMALL_FONT, DISPLAY_COLUMNS);
	clearUpTo(cursor, DISPLAY_COLUMNS);
}

void stateSetDisplayFrequency(int y)
{
	internalVary(&screenFrequency, 8, &internalSetDisplayFrequency, &internalSeeDisplayFrequency, &identityFunction, 0, &emptyFunction);
}
//*************************************************************************************************************************
// Set Display Timeout Functions
//*************************************************************************************************************************
const int DisplayTimeOuts[] __attribute__((space(auto_psv), aligned(2))) =
{	3,				// 30 seconds
	6,				// 1 minute
	30, 			// 5 minutes
 	60,				// 10 minutes
	90,				// 15 minutes
	180,			// 30 minutes
	360,			// 1 hour
	540,			// 1.5 hour
	1080,			// 3 hours
	1800,			// 5 hours
	3600,			// 10 hours
	8640,			// 24 hours
	-1 
};				

void internaldisplayDisplayTimeOut(int y)
{
	cursor=0;
	displayTimeUnit(((DOUBLE)temp*100.0), TOTAL_DIGITS_SMALL, SMALL_FONT, DISPLAY_COLUMNS);	
	clearUpTo(cursor, DISPLAY_COLUMNS);
}

void stateSetDisplayTimeOut(int y)
{
	temp=(int)(screenTimeOut/100.0);
	internalSetAndRunEnum(&temp, 1, temp, (int *)&DisplayTimeOuts, 0, &emptyFunction, &internaldisplayDisplayTimeOut);
	screenTimeOut=((long)temp*100.0);
	resetScreenSaver();
}
//
//*************************************************************************************************************************
// State Output Enable
//*************************************************************************************************************************
void stateSeeOutputEnable(int y)
{
	if((outputEnable & 0xFF)==0xFF)printstringDots("All On",0,0); else if((outputEnable & 0xFF)==0)printstringDots("All Off",0,0); else
	{
	if((outputEnable & 0x11)!=0)printstringDots("CH1 On,",0,0); else printstringDots("CH1 Off,",0,0);
	if((outputEnable & 0x22)!=0)printstringDots("CH2 On,",0,0); else printstringDots("CH2 Off,",0,0);
	if((outputEnable & 0x44)!=0)printstringDots("CH3 On,",0,0); else printstringDots("CH3 Off,",0,0);
	if((outputEnable & 0x88)!=0)printstringDots("CH4 On",0,0); else printstringDots("CH4 Off",0,0);
	}
}

void stateSetOutputEnable(int y)
{
	if(outputEnable==OUTPUTENABLE_ALLOFF)outputEnable=OUTPUTENABLE_ALLON; else outputEnable=OUTPUTENABLE_ALLOFF;	
}
//*************************************************************************************************************************
// See Mains Frequency
//*************************************************************************************************************************
void stateSeeMainsFrequency(int y)
{
	disFDotsdecimal(freqObj[MAINS_SYNC].freq, 1, y, 0);
}
//*************************************************************************************************************************
// See Detected Frequency
//*************************************************************************************************************************
void stateSeeDetectedMainsFrequency(int y)
{
	if(IEC0bits.INT0IE==1)disFDotsdecimal(mainsFreq, 1, y, 0); else printstringDots("N/A",0,0);
}
//*************************************************************************************************************************
// See Screen Frequency
//*************************************************************************************************************************
void stateSeeScreenFrequency(int y)
{
	disFDotsdecimal(2.0*freqObj[SCREEN_REFRESH].freq, 1, y, 0);
}

//*************************************************************************************************************************
// See CRC State
//*************************************************************************************************************************
void stateSeeCRC(int y)
{
	printstringDots("0x", 0, 0);
	disWDots(computeCRC(UPPER_CRC_LIMIT), 0);
}

//*************************************************************************************************************************
// See ADC Frequency
//*************************************************************************************************************************
void stateSeeADCFrequency(int y)
{
	disWDotsdecimal(8.0*freqObj[ADC_ACQUIRE].freq, y, 0);
}
//*************************************************************************************************************************
// See Triacs Frequency
//*************************************************************************************************************************
void stateSeeTriacsFrequency(int y)
{
	disFDotsdecimal(freqObj[TRIACS].freq, 1, y, 0);
}
//*************************************************************************************************************************
// See Mains Duty
//*************************************************************************************************************************
void stateSeeMainsDuty(int y)
{
	disFDotsdecimal(freqObj[MAINS_SYNC].duty, 1, y, 0);
}


//*************************************************************************************************************************
// See ADC Duty
//*************************************************************************************************************************
//void stateSeeADCDuty(int y)
//{
//	disFDotsdecimal(freqObj[ADC_ACQUIRE].duty, 1, y, 0);
//}

void stateSeeSPI(int y)
{
	printstringDots("0x", 0, 0);
	disWDots(SPI1CON,0);
}

//*************************************************************************************************************************
// See Screen Duty
//*************************************************************************************************************************
//void stateSeeScreenDuty(int y)
//{
//	disFDotsdecimal(freqObj[SCREEN_REFRESH].duty, 1, y, 0);

//}

void stateSeeU1MODE(int y)
{
	printstringDots("0x", 0, 0);
	disWDots(U1MODE,0);
}

void stateSeeU1STA(int y)
{
	printstringDots("0x", 0, 0);
	disWDots(U1STA, 0);
}

//*************************************************************************************************************************
// See Triacs Duty
//*************************************************************************************************************************
//void stateSeeTriacsDuty(int y)
//{
//	disFDotsdecimal(freqObj[TRIACS].duty, 1, y, 0);
//}

//*************************************************************************************************************************
// See FCY Instruction frequency
//*************************************************************************************************************************
void stateSeeFcy(int y)
{
	disFDotsdecimal(fcy/1000000.0, 3, y, 0);
}
//*************************************************************************************************************************
// See Accuracy
//*************************************************************************************************************************
void stateSeeAccuracy(int y)
{
	DOUBLE t;
	t=100.0*((freqObj[MAINS_SYNC].freq/mainsFreq)-1.0);
	disFDotsdecimalSigned(t, 2, BIG_FONT, 0);
}
//*************************************************************************************************************************
// See Version
//*************************************************************************************************************************
void stateSeeVersion(int y)
{
	disFDotsdecimal(VERSION, 2, y, 0);
}

//*************************************************************************************************************************
// Set Trigger Threshold
//*************************************************************************************************************************
void internalSetTriggerThreshold(int y)
{
	triggerThreshold=y;
}

void internalDisplayTriggerThreshold(int y)
{
	displayBar(scaleShiftFromTo((unsigned long)y, TRIGGER_THRESHOLD_LOG2, 8), 0);
}

void stateSetTriggerThreshold(int y)
{
	internalVary((int*)&triggerThreshold, TRIGGER_THRESHOLD_LOG2, &internalSetTriggerThreshold, &internalDisplayTriggerThreshold, &identityFunction, 0, &emptyFunction);
}

//*************************************************************************************************************************
// Set Silence Threshold
//*************************************************************************************************************************
void internalSetSilenceThreshold(int y)
{
	silenceThreshold=y;
}

void internalDisplaySilenceThreshold(int y)
{
	displayBar(scaleShiftFromTo((unsigned long)silenceThreshold, SILENCE_THRESHOLD_LOG2, 8), 0);
}

void stateSetSilenceThreshold(int y)
{
	internalVary((int*)&silenceThreshold, SILENCE_THRESHOLD_LOG2, &internalSetSilenceThreshold, &internalDisplaySilenceThreshold, &identityFunction, 0, &emptyFunction);
}

//*************************************************************************************************************************
// Set ZV Threshold
//*************************************************************************************************************************
void internalSetZVThreshold(int y)
{
	zvThreshold=y<<4;
}

void internalDisplayZVThreshold(int y)
{
	displayBar(zvThreshold>>4, 0);
}

int inverseZVFunction(int y)
{
	return (zvThreshold>>4);
}

void stateSetZVThreshold(int y)
{
	temp=zvThreshold>>4;
	internalVary((int*)&temp, 8, &internalSetZVThreshold, &internalDisplayZVThreshold, &inverseZVFunction, 0, &emptyFunction);
}
//*************************************************************************************************************************
// See Trigger Min Freq
//*************************************************************************************************************************
void stateSeeTriggerMinFreq(int y)
{
	disWDotsdecimal(triggerMinFreq, y, 0);
}
//*************************************************************************************************************************
// See Trigger Max Freq
//*************************************************************************************************************************
void stateSeeTriggerMaxFreq(int y)
{
	disWDotsdecimal(triggerMaxFreq, y, 0);

}
//*************************************************************************************************************************
// Set Trigger Min Freq
//*************************************************************************************************************************
void internalDisplayFreq(int y)
{
	// in kiloHertz
	disFDotsdecimal(((DOUBLE)y/1000.0), 3, SMALL_FONT, DISPLAY_COLUMNS);
}

void stateSetTriggerMinFreq(int y)
{
	internalSetAndRunDy(&triggerMinFreq, ((unsigned long)adcSamplingFreq>>(1+LOG2_BLOCK_LENGTH)), MAX_AUDIO_FREQ, 1, &emptyFunction, &internalDisplayFreq);
}
//*************************************************************************************************************************
// Set Trigger Max Freq
//*************************************************************************************************************************
void stateSetTriggerMaxFreq(int y)
{
	internalSetAndRunDy(&triggerMaxFreq, ((unsigned long)adcSamplingFreq>>(1+LOG2_BLOCK_LENGTH)), MAX_AUDIO_FREQ, 1, &emptyFunction, &internalDisplayFreq);
}
//*************************************************************************************************************************
// State Set Serial Settings
//*************************************************************************************************************************
const int UartBaudRates[] __attribute__((space(auto_psv), aligned(2))) =
{ 	0, 					// 1.8432 Mbps
	1, 					// 921.6 Kbps
	3, 					// 460.8 Kbps
	7, 					// 230.4 Kbps
	15, 				// 115.2 Kbps
	31, 				// 57.6 Kbps
	47, 				// 38.4 Kbps
	63, 				// 28.8 Kbps
	95, 				// 19.2 Kbps
	127, 				// 14.4 Kbps
	191, 				// 9.6 Kbps
	383, 				// 4.8 Kbps
	511,				// 3.6 Kbps    NB: We can't go lower than this on the SPI output!
	-1 };				

void internaldisplaySerialSettings(int y)
{
	DOUBLE f;
	f=UART_FREQ16/(U1BRG+1);
	display[0]=0;
	disEngineering(f, TOTAL_DIGITS_SMALL+1, SMALL_FONT, DISPLAY_COLUMNS, INVISIBLE_CHAR, 0);
	changeRf6Mode(rf6Mode);
}

void stateSeeBaudRate(int y)
{
	DOUBLE f;
	f=UART_FREQ16/(U1BRG+1);
	disEngineering(f, TOTAL_DIGITS_BIG, BIG_FONT, 0, ' ', 0);
}

void internalSetSerialSettings(int y)
{
	//the exit function.
	changeRf6Mode(rf6Mode);
}

void stateSetSerialSettings(int y)
{
	internalSetAndRunEnum((int *)&U1BRG, -1, U1BRG, (int *)&UartBaudRates, 1, &internalSetSerialSettings, &internaldisplaySerialSettings);
}
//*************************************************************************************************************************
// Set ADC Sampling Frequency Functions
//*************************************************************************************************************************
void stateSeeSamplingFrequency(int y)
{
	disWDotsdecimal(adcSamplingFreq, y, 0);
}

void internalSetADCFrequency(int y)
{ 
	initADC4(unsignedclipBounded((unsigned int)y, ADC_SAMPLING_FREQ_MIN, ADC_SAMPLING_FREQ_MAX), TADS);
}

void internalSeeSetADCFrequency(int y)
{
	cursor=1;
	display[0]=0;
	disFDotsdecimal(((DOUBLE)adcSamplingFreq/1000.0), 3, SMALL_FONT, DISPLAY_COLUMNS);
}

int internalSetADCFrequencyInverse(int y)
{
	return (int)unsignedclipBoundedInverse(adcSamplingFreq, ADC_SAMPLING_FREQ_MIN, ADC_SAMPLING_FREQ_MAX);
}

void stateSetADCFrequency(int y)
{
	temp=0;
	internalVary((int*)&temp, LEVELS_LOG2, &internalSetADCFrequency, &internalSeeSetADCFrequency, &internalSetADCFrequencyInverse, 0, &emptyFunction);
}

//*************************************************************************************************************************
// Set Output Rate Functions
//*************************************************************************************************************************
void stateSeeOutputFrequency(int y)
{
	ftemp=(OUTPUT_RATE_FREQ/outputRate);
	disWDotsdecimal((int)ftemp, y, 0);
}

void internalSetOutputFrequency(int y)
{ 
	ftemp=unsignedclipBounded((unsigned int)y, OUTPUT_FREQ_MIN, OUTPUT_FREQ_MAX);
	outputRate=(int)(OUTPUT_RATE_FREQ/ftemp);
}

void internalSeeSetOutputFrequency(int y)
{
	cursor=1;
	display[0]=0;
	ftemp=(OUTPUT_RATE_FREQ/outputRate);
	disFDotsdecimal((DOUBLE)ftemp, 3, SMALL_FONT, DISPLAY_COLUMNS);
}

int internalSetOutputFrequencyInverse(int y)
{
	ftemp=(OUTPUT_RATE_FREQ/outputRate);
	return (int)unsignedclipBoundedInverse(ftemp, OUTPUT_FREQ_MIN, OUTPUT_FREQ_MAX);
}

void stateSetOutputFrequency(int y)
{
	temp=0;
	internalVary((int*)&temp, 8, &internalSetOutputFrequency, &internalSeeSetOutputFrequency, &internalSetOutputFrequencyInverse, 0, &emptyFunction);
}
//*************************************************************************************************************************
// Set RF6 Mode state
//*************************************************************************************************************************
void internalstateRF6RunFunction(int y)
{
	changeRf6Mode(rf6Mode);
}

void internalstateRF6DisplayFunction(int y)
{
	changeRf6Mode(rf6Mode);
	displayBigDecimal(rf6Mode);
}

void stateRF6(int y)
{
 	internalSetAndRun(&rf6Mode, 1, RF6MODULUS, 0, &internalstateRF6RunFunction, &internalstateRF6DisplayFunction, 0);
}
//*************************************************************************************************************************
// Set Tuning state
//*************************************************************************************************************************
void internalstateTuningRunFunction(int y)
{
	putTuning((unsigned char)y);
}

void internalstateTuningDisplayFunction(int y)
{
	putTuning((unsigned char)y);
	displayBigDecimal(getTuning());
}

void stateTuning(int y)
{
//	int x;
//	x=rf6Mode;
//	changeRf6Mode(OUTPUT_SYSTEM_CLK);
	temp=getTuning();
 	internalSetAndRun((int *)&temp, 1, 16, 0, &internalstateTuningRunFunction, &internalstateTuningDisplayFunction, 0);
//	changeRf6Mode(x);
}

void stateSeeStartup(int y)
{
	if((mainMode & MODE_FAST_BOOT)==0)printstringDots("Normal",0,0); else printstringDots("Fast",0,0);
}

void stateSetStartup(int y)
{
	mainMode^=MODE_FAST_BOOT;
}

//
// Channel Mode
//
// The Channel Modes are as follows:
// Acquisition: PEAK or AVERAGE
// Output Mode: STROBE, if not strobe then DIRECT or CONTINUOUS with or without ZV.
// In other words:
//	STROBE
// 	DIRECT
//  CONTINUOUS
//  DIRECT+ZV
//  CONTINUOUS+ZV
//  And then the channel can be either FFT or CHASER so that's 20 modes.
//
void stateSeeChannelMode(int y)
{
	if((ch[currentChannel].mode & AUTO_MODE)!=0)
	{
	printstringDots("   Auto",0,0);
	return;
	}
	else
	if((ch[currentChannel].mode & CHASER_MODE)!=0){
	printstringDots("   Chaser",0,0);
	return;
	}
	else
	if((ch[currentChannel].mode & DIRECT_MODE)!=0)printstringDots("   Direct",0,0);
	else
	if((ch[currentChannel].mode & CONTINUOUS_MODE)!=0)printstringDots("   Continuous",0,0);
	else
	if((ch[currentChannel].mode & STROBE_MODE)!=0)printstringDots("   Strobe",0,0); 
	if((ch[currentChannel].mode & ZV_MODE)!=0)printstringDots("+ZV",0,0);
	if((ch[currentChannel].mode & EQUALIZER_MODE)!=0)printstringDots("+EQ",0,0);
	if((ch[currentChannel].mode & AVG_MODE)!=0)printstringDots("(AVG)",0,0); else printstringDots("(PEAK)",0,0);
}

const int ModesSequence[TOTAL_MODES] __attribute__((space(auto_psv), aligned(2)))=
{
AUTO_MODE, 
DIRECT_MODE, 
CONTINUOUS_MODE,
STROBE_MODE
};

//*************************************************************************************************************************
// Set Channel Mode state
//*************************************************************************************************************************
void internalstateDisplayChannelModeFunction(int y)
{
	if(temp!=ch[currentChannel].mode)
	{
		temp=ch[currentChannel].mode;
		stateSeeChannelMode(y);	
	}	
	//displayBigDecimal(ch[currentChannel].mode);
}

void internalChannelModeAddFunction(int dy, int my)
{
	ch[currentChannel].modeIndex+=dy;
	clip((int *)&ch[currentChannel].modeIndex, 0, my);
	ch[currentChannel].mode=ModesSequence[(int)ch[currentChannel].modeIndex];
}

void internalChangeAcquireModeFunction(int y)
{
	int x;
	x=0;
	if((ch[currentChannel].mode & AVG_MODE)!=0)x+=1;
	if((ch[currentChannel].mode & EQUALIZER_MODE)!=0)x+=2;
	if((ch[currentChannel].mode & ZV_MODE)!=0)x+=4;
	if(y>0)y=1;
	changeValueModulo(&y, x+y, 8);
	if(y==0)
	{
	ch[currentChannel].mode &=~AVG_MODE;				// toggle the acquisition mode.
	ch[currentChannel].mode &=~EQUALIZER_MODE;
	ch[currentChannel].mode &=~ZV_MODE;
	} else
	if(y==1)
	{
	ch[currentChannel].mode |=AVG_MODE;				// toggle the acquisition mode.
	ch[currentChannel].mode &=~EQUALIZER_MODE;
	ch[currentChannel].mode &=~ZV_MODE;
	} else
	if(y==2)
	{
	ch[currentChannel].mode &=~AVG_MODE;				// toggle the acquisition mode.
	ch[currentChannel].mode |=EQUALIZER_MODE;
	ch[currentChannel].mode &=~ZV_MODE;
	} else
	if(y==3)
	{
	ch[currentChannel].mode |=AVG_MODE;				// toggle the acquisition mode.
	ch[currentChannel].mode |=EQUALIZER_MODE;
	ch[currentChannel].mode &=~ZV_MODE;
	} else
	if(y==4)
	{
	ch[currentChannel].mode &=~AVG_MODE;				// toggle the acquisition mode.
	ch[currentChannel].mode &=~EQUALIZER_MODE;
	ch[currentChannel].mode |=ZV_MODE;
	} else
	if(y==5)
	{
	ch[currentChannel].mode |=AVG_MODE;				// toggle the acquisition mode.
	ch[currentChannel].mode &=~EQUALIZER_MODE;
	ch[currentChannel].mode |=ZV_MODE;
	} else
	if(y==6)
	{
	ch[currentChannel].mode |=AVG_MODE;				// toggle the acquisition mode.
	ch[currentChannel].mode |=EQUALIZER_MODE;
	ch[currentChannel].mode |=ZV_MODE;
	} else
	if(y==7)
	{
	ch[currentChannel].mode |=AVG_MODE;				// toggle the acquisition mode.
	ch[currentChannel].mode |=EQUALIZER_MODE;
	ch[currentChannel].mode |=ZV_MODE;
	}
}

void stateSetChannelMode(int y)
{
	temp=-1;
	internalSetAndRunDyChannels(&y, -1, TOTAL_MODES-1, 1, &emptyFunction, &internalstateDisplayChannelModeFunction, &internalChannelModeAddFunction, &internalChangeAcquireModeFunction);
}
//*************************************************************************************************************************
// Set Writing Mode state
//*************************************************************************************************************************
void internalstateDisplayWritingModeFunction(int y)
{
	displayBigDecimal(y);
}

void stateSetWritingMode(int y)
{
 	internalSetAndRun((int *)&writingMode, 1, 8, 0, &emptyFunction, &internalstateDisplayWritingModeFunction, 0);
}
//*************************************************************************************************************************
// Channel Gain Functions
//*************************************************************************************************************************
void internalSetChannelGain(int y)
{ 
	setGain(fixedToFloat(unsignedclipBounded((unsigned int)y, GAIN_MIN, GAIN_MAX)), currentChannel);
}

void internalSeeSetChannelGain(int y)
{
	cursor=1;
	display[0]=0;
	disFDotsdecimal(ch[currentChannel].gain, 3, SMALL_FONT, DISPLAY_COLUMNS);
}

int internalSetChannelGainInverse(int y)
{
	return (int)unsignedclipBoundedInverse(ch[currentChannel].igain, GAIN_MIN, GAIN_MAX);
}

void stateSetChannelGain(int y)
{
	temp=0;
	internalVaryChannels((int*)&temp, LEVELS_LOG2, &internalSetChannelGain, &internalSeeSetChannelGain, &internalSetChannelGainInverse, &emptyFunction);
}

//*************************************************************************************************************************
// Input Balance Functions
//*************************************************************************************************************************
void internalSetBalance(int y)
{ 
	setCmCl(fixedToFloat(iC[CHANNELMIC]/micGain), 1.0-fixedToFloat(y));
}

void internalSeeSetBalance(int y)
{
	displayBalance(iC[CHANNELMIC]/micGain, iC[CHANNELL]/leftGain, iC[CHANNELR]/rightGain);
}

int internalSetBalanceInverse(int y)
{
	return (iC[CHANNELR]/rightGain);
}

void internalMicSetFunction(int y)
{
	DOUBLE f;
	if(y<0)f=-0.05; else f=0.05;
	Cm+=f;
	setCmCl(Cm, Cl);
}

void stateSetBalance(int y)
{
	temp=0;
	internalVary((int*)&temp, FIXED_DENOMINATOR_LOG2, &internalSetBalance, &internalSeeSetBalance, &internalSetBalanceInverse, 2, &internalMicSetFunction);
}

void stateSeeBalanceValues(int y)
{
	printstringDots(" Mic(%):",BIG_FONT, 0);
	disFDotsdecimal((100.0/micGain)*fixedToFloat(iC[CHANNELMIC]), 1, BIG_FONT, 0);
	printstringDots(" Left(%):",BIG_FONT, 0);
	disFDotsdecimal((100.0/leftGain)*fixedToFloat(iC[CHANNELL]), 1, BIG_FONT, 0);
	printstringDots(" Right(%):",BIG_FONT, 0);
	disFDotsdecimal((100.0/rightGain)*fixedToFloat(iC[CHANNELR]), 1, BIG_FONT, 0);
	printstringDots(" ",BIG_FONT,0);
}

//*************************************************************************************************************************
// Equalizer Functions
//*************************************************************************************************************************
void internalSetEqualizer(int y)
{ 
	equalizerCoefficient[temp]=y;
}

void internalSeeSetEqualizer(int y)
{
	displayEqualizer(temp);
}

int internalSetEqualizerInverse(int y)
{
	return equalizerCoefficient[temp];
}

void internalEqualizerIndexSetFunction(int y)
{
	if(y>0)changeValueModulo(&temp,temp+1, EQUALIZERS); else changeValueModulo(&temp, temp-1, EQUALIZERS);
}

void stateSetEqualizer(int y)
{
	temp=0;
	newTransition=0;
	internalVary((int*)&y, FIXED_DENOMINATOR_LOG2, &internalSetEqualizer, &internalSeeSetEqualizer, &internalSetEqualizerInverse, 3, &internalEqualizerIndexSetFunction);
}

//*************************************************************************************************************************
// See Channel Min Freq
//*************************************************************************************************************************
void stateSeeChannelMinFreq(int y)
{
	disWDotsdecimal(ch[currentChannel].minFreq, y, 0);
}
//*************************************************************************************************************************
// Set Channel Min Freq Functions
//*************************************************************************************************************************
void internalChannelMinFreqAddFunction(int dy, int my)
{
	ch[currentChannel].minFreq+=dy;
	clip(&ch[currentChannel].minFreq, 0, my);
}

void internalDisplayChannelMinFreqFunction(int y)
{
	internalDisplayFreq(ch[currentChannel].minFreq);
}

void stateSetChannelMinFreq(int y)
{
	internalSetAndRunDyChannels(&y, ((unsigned long)adcSamplingFreq>>(1+LOG2_BLOCK_LENGTH)), MAX_AUDIO_FREQ, 1, &emptyFunction, &internalDisplayChannelMinFreqFunction, &internalChannelMinFreqAddFunction, &emptyFunction);
}
//*************************************************************************************************************************
// Set Channel Max Freq Functions
//*************************************************************************************************************************
void internalChannelMaxFreqAddFunction(int dy, int my)
{
		ch[currentChannel].maxFreq+=dy;
		clip(&ch[currentChannel].maxFreq, 0, my);
}

void internalDisplayChannelMaxFreqFunction(int y)
{
	internalDisplayFreq(ch[currentChannel].maxFreq);
}

void stateSetChannelMaxFreq(int y)
{
	internalSetAndRunDyChannels(&y, ((unsigned long)adcSamplingFreq>>(1+LOG2_BLOCK_LENGTH)), MAX_AUDIO_FREQ, 1, &emptyFunction, &internalDisplayChannelMaxFreqFunction, &internalChannelMaxFreqAddFunction, &emptyFunction);
}

//*************************************************************************************************************************
// Set Channel Freq Functions
//*************************************************************************************************************************
void internalChannelFreqAddFunction(int dy, int my)
{
	int cn, cp;

	cn=currentChannel+1;
	clip(&cn, 0, OUTPUT_CHANNELS-1);
	cp=currentChannel-1;
	clip(&cp, 0, OUTPUT_CHANNELS-1);
	ch[currentChannel].minFreq+=dy;
	clip(&ch[currentChannel].minFreq, 0, my);
	clip(&ch[currentChannel].minFreq, ch[cp].minFreq, ch[cn].minFreq);
}

void internalDisplayChannelFreqFunction(int y)
{
	internalDisplayFreq(ch[currentChannel].minFreq);
}

void internalFixFreqOverlap(int y)
{
	unsigned int i;
	for(i=0; i<(OUTPUT_CHANNELS-1); i++)
	{
	ch[i].maxFreq=ch[i+1].minFreq;
	}
	ch[OUTPUT_CHANNELS-1].maxFreq=((unsigned long)adcSamplingFreq>>1);
}

void stateSetChannelFreq(int y)
{
	internalSetAndRunDyChannels(&y, ((unsigned long)adcSamplingFreq>>(1+LOG2_BLOCK_LENGTH)), ((unsigned long)adcSamplingFreq>>1), 1, &internalFixFreqOverlap, &internalDisplayChannelFreqFunction, &internalChannelFreqAddFunction, &emptyFunction);
}
//
// Calibration State Function
//

int stateCalibration(int y)
{
	DOUBLE err;
	allOutputs(0);
	printstringDots("Starting Automatic Calibration...   ",BIG_FONT, 0);
	if(IEC0bits.INT0IE==1)
	{
		err=calibrateAll(mainsFreq);
		printstringDots("   Done. Error(%):",0,0);
		disFDotsdecimal(err, 2, BIG_FONT, 0);
		return TRUE;
	} else printstringDots("  Aborting: No Mains Detected!  ", BIG_FONT, 0);
	return FALSE;
}

const char *ModeStrings[] __attribute__((space(auto_psv), aligned(2))) = { "Off", "Auto", "Normal", "Triggered" };
//
// Chaser Mode State Function
//
void stateSeeChaserMode(int y)
{
	printstringDots((char *)ModeStrings[getChaserMode()], BIG_FONT, 0);
}

void stateSetChaserMode(int y)
{
	setChaserMode(getChaserMode()+1);
}
//
// Chaser Program State Function
//
void internalSetChaserProgramRunFunction(int y)
{
	setChaserProgram(y);
}

void internalDisplayChaserProgramFunction(int y)
{
	if(y==temp)
	{
		if(outputTimer<=0)
			{
			outputTimer=outputRate;
			if(Chaser.ip!=NULLP)Chaser.ip=decodeInstructionAndData(&Chaser); else setChaserProgram(y);
			}						
	} else
	{
		displaySmallDecimal(y);
		setChaserProgram(y);
		temp=y;
	}		
}

void stateSetChaserProgram(int y)
{
	temp=-1;
	internalSetAndRun(&chaserProgram,1,chaserTotal,0, &internalSetChaserProgramRunFunction, &internalDisplayChaserProgramFunction, 1);
}

//*************************************************************************************************************************
// Set Screen Saver
//*************************************************************************************************************************
int (*ScreenSavers[SCREEN_SAVERS])(int) __attribute__((space(auto_psv), aligned(2))) =
{ 	&drawBlank, 
	&drawSnow,
	&drawLife,   
	&drawChaser,
	&drawMessage
};				

void internalstateSetScreenSaverRunFunction(int y)
{
	
}

void internalstateSetScreenSaverDisplayFunction(int y)
{
	int i;
	int (*screenFunction)(int);
	screenFunction=ScreenSavers[screenSaver];
	i=screenFunction(0);		
}

void stateSetScreenSaver(int y)
{
	setTimeOut(0);
 	internalSetAndRun(&screenSaver, 1, SCREEN_SAVERS, 0, &internalstateSetScreenSaverRunFunction, &internalstateSetScreenSaverDisplayFunction, 1);
}
//*************************************************************************************************************************
// Set Permutation State
//*************************************************************************************************************************
void internalstateDisplayPermutationFunction(int y)
{
	printstringDots("C",BIG_FONT,0);
	displayBigDecimal(channelPermutation[currentChannel]+1);
}

void internalstatePermutationAddFunction(int dy, int my)
{
	int s;
	s=channelPermutation[currentChannel];
	changeValueModulo(&s, s+dy, my);
	channelPermutation[currentChannel]=s;
}

void stateSetPermutation(int y)
{
	internalSetAndRunDyChannels(&y, 1, OUTPUT_CHANNELS, 0, &emptyFunction, &internalstateDisplayPermutationFunction, &internalstatePermutationAddFunction, &emptyFunction);
}
//
// State RC5 Echo
//
void stateRC5Echo(int y)
{
	int k;
	changeRf6Mode(INPUT_REMOTE);
	k=NOKEY;
	LEDS=LED7;
	FLASHING=LED7;
	while(k!=KEY7)
	{
		k=ir_code;
		while((noKeys())&&(k==ir_code))wait();
		k=getKey();
		printcharDots(' ',BIG_FONT,0, TO_SCREEN);
		disWDots((0x07FF & ir_code),0);
		flushKeys();
	}
}

//
// State Define Remote Control
//
void stateSeeRemoteControl(int y)
{
	int i;
	i=readEEPROMInt(REMOTE_CONTROL_DEFS_ADDRESS);
	if(i!=MAGIC_REMOTE_CONTROL_VALUE)printstringDots("Not ",0,0);
	printstringDots("Defined",0,0);
}

void stateDefineRemoteControl(int y)
{
	int k;
	LEDS=0;	
	FLASHING=0;
	changeRf6Mode(INPUT_REMOTE);
	//k=detectRemote();
	//if(k==TRUE){ printstringDots("   Remote Control Detected...   ",0,0); disableUart(); changeRf6Mode(INPUT_REMOTE); } 
	//else printstringDots("   Remote Control Not Detected...   ",0,0);
	printstringDots("   Press SET to define the remote control codes.   ",0,0);
	LEDS=LED2;
	FLASHING=LED2;	
	k=waitForKey();
	if(k==KEY2){
		LEDS=0;
		FLASHING=0;
		printstringDots("   Press your chosen button when the corresponding LED lights...   ",0,0);
		LEDS=LED1;
		k=ir_code;
		while(k==ir_code)wait();
		writeEEPROMInt(REMOTE_CONTROL_DEFS_ADDRESS+1+KEY1, ir_code);
		LEDS=LED2;
		k=ir_code;
		while(k==ir_code)wait();
		writeEEPROMInt(REMOTE_CONTROL_DEFS_ADDRESS+1+KEY2, ir_code);
		LEDS=LED3;
		k=ir_code;
		while(k==ir_code)wait();
		writeEEPROMInt(REMOTE_CONTROL_DEFS_ADDRESS+1+KEY3, ir_code);
		LEDS=LED4;
		k=ir_code;
		while(k==ir_code)wait();
		writeEEPROMInt(REMOTE_CONTROL_DEFS_ADDRESS+1+KEY4, ir_code);
		LEDS=LED5;
		k=ir_code;
		while(k==ir_code)wait();
		writeEEPROMInt(REMOTE_CONTROL_DEFS_ADDRESS+1+KEY5, ir_code);
		LEDS=LED6;
		k=ir_code;
		while(k==ir_code)wait();
		writeEEPROMInt(REMOTE_CONTROL_DEFS_ADDRESS+1+KEY6, ir_code);
		LEDS=LED7;
		k=ir_code;
		while(k==ir_code)wait();
		writeEEPROMInt(REMOTE_CONTROL_DEFS_ADDRESS+1+KEY7, ir_code);
		LEDS=0;
		printstringDots("  Press to define the + control",0,0);
		k=ir_code;
		while(k==ir_code)wait();
		writeEEPROMInt(REMOTE_CONTROL_DEFS_ADDRESS+1+KEYUP, ir_code);
		LEDS=0;
		printstringDots("  Press to define the - control",0,0);
		k=ir_code;
		while(k==ir_code)wait();
		writeEEPROMInt(REMOTE_CONTROL_DEFS_ADDRESS+1+KEYDOWN, ir_code);
		printstringDots("  All remote control codes defined...   ",0,0);
		writeEEPROMInt(REMOTE_CONTROL_DEFS_ADDRESS, MAGIC_REMOTE_CONTROL_VALUE);
		// done!
	} else printstringDots("   Cancelled...   ",0,0);
	flushKeys();
}
//*************************************************************************************************************************
// Set Channel Attack Functions
//*************************************************************************************************************************
void internalSetChannelAttackFunction(int y)
{
	ch[currentChannel].attack=(y>>1);
}

void internalAttackFunction(int y)
{
	displayBar((ch[currentChannel].attack<<1), 0);
	//displayBar(y, 0);
}

int inverseAttackFunction(int y)
{
	return (ch[currentChannel].attack <<1);
}

void stateSetChannelAttack(int y)
{
	internalVaryChannels(&y, 8, &internalSetChannelAttackFunction, &internalAttackFunction, &inverseAttackFunction, &emptyFunction);
}
//*************************************************************************************************************************
// Set Channel Decay Functions
//*************************************************************************************************************************
void internalSetChannelDecayFunction(int y)
{
	ch[currentChannel].decay=(y>>1);
}

void internalDecayFunction(int y)
{
	displayBar((ch[currentChannel].decay<<1), 0);
	//displayBar(y, 0);
}

int inverseDecayFunction(int y)
{
	return (ch[currentChannel].decay <<1);
}

void stateSetChannelDecay(int y)
{
	internalVaryChannels(&y, 8, &internalSetChannelDecayFunction, &internalDecayFunction, &inverseDecayFunction, &emptyFunction);
}

//*************************************************************************************************************************
void stateTestChannel(int y)
{
	int i, k;
	
	LEDS=0;
	FLASHING=0;
	k=NOKEY;
	while(k!=KEY2){
		displayBar(0, 1);
		LEDS&=~CHANNEL_LEDS;
		LEDS|=(LED2 | (channelLED(currentChannel)));
		k=waitForKey();
		if(k==KEY4){ changeValueModulo(&currentChannel, CH1, OUTPUT_CHANNELS); }
		if(k==KEY5){ changeValueModulo(&currentChannel, CH2, OUTPUT_CHANNELS); }
		if(k==KEY6){ changeValueModulo(&currentChannel, CH3, OUTPUT_CHANNELS); }
		if(k==KEY7){ changeValueModulo(&currentChannel, CH4, OUTPUT_CHANNELS); }
		if((k==KEY4)||(k==KEY5)||(k==KEY6)||(k==KEY7))
		{
		LEDS&=~CHANNEL_LEDS;
		LEDS|=(LED2 | (channelLED(currentChannel)));
		for(i=0; i<256; i++)
		{
		setOutputLevel(i, currentChannel, NORMAL_MODE);
		displayBar(ch[currentChannel].outputLevel, 1);	
		DelayMs(TEST_OUTPUTS_DELAY_MS);
		}
		FLASHING|=channelLED(currentChannel);
		for(i=0; i<4; i++)
		{
		setOutputLevel(LEVELS_MAX, currentChannel, NORMAL_MODE);
		displayBar(ch[currentChannel].outputLevel, 1);
		DelayMs(TEST_OUTPUTS_DELAY_MS_LONG);
		setOutputLevel(0, currentChannel, NORMAL_MODE);
		displayBar(ch[currentChannel].outputLevel, 1);
		DelayMs(TEST_OUTPUTS_DELAY_MS_LONG);
		}
		FLASHING&=~channelLED(currentChannel);
		}
	}
	k=getKey();
}
//*****************************************************************************
// Auto Config Function
//*****************************************************************************
void baseDefaults(int y)
{
	int i;
	zvThreshold=ZV_THRESHOLD_DEFAULT;
	outputRate=OUTPUT_RATE_DEFAULT;
	outputTimer=0;
	silenceThreshold=SILENCE_THRESHOLD_DEFAULT;
	setChaserMode(CHASER_MODE_OFF);
	for(i=0; i<OUTPUT_CHANNELS; i++)
	{
	channelPermutation[i]=i;
	}
	adcSamplingFreq=ADC_SAMPLING_FREQ;
	initADC4(adcSamplingFreq, TADS);
	outputEnable=OUTPUTENABLE_ALLON;
	for(i=0; i<OUTPUT_CHANNELS;i++){
		setGain(GAIN_DEFAULT, i);
		ch[i].mode=DEFAULT_CH_MODE;
		ch[i].modeIndex=DEFAULT_CH_MODE_INDEX;
		ch[i].attack=DEFAULT_ATTACK;
		ch[i].decay=DEFAULT_DECAY;
		ch[i].strobe=DEFAULT_STROBE;
		ch[i].counter=0;
		ch[i].bin=0;
		}
	ch[0].minFreq=CH1_MINFREQ_DEFAULT;
	ch[0].maxFreq=CH1_MAXFREQ_DEFAULT;
	ch[1].minFreq=CH2_MINFREQ_DEFAULT;
	ch[1].maxFreq=CH2_MAXFREQ_DEFAULT;
	ch[2].minFreq=CH3_MINFREQ_DEFAULT;
	ch[2].maxFreq=CH3_MAXFREQ_DEFAULT;
	ch[3].minFreq=CH4_MINFREQ_DEFAULT;
	ch[3].maxFreq=CH4_MAXFREQ_DEFAULT;
}

void stateAutoConfig(int y)
{
	baseDefaults(y);	
	printstringDots("   Auto Config Set...   ",0,0);
}
//*****************************************************************************
// High Contrast Config Function
//*****************************************************************************
void stateHighContrastConfig(int y)
{
	int i;
	baseDefaults(y);
	for(i=0; i<OUTPUT_CHANNELS; i++)
	{
		ch[i].attack=64;
		ch[i].decay=32;
		ch[i].mode=CONTINUOUS_MODE;
	}
	printstringDots("   High Contrast Config Set...   ",0,0);
}
//*****************************************************************************
// Strobe Config Function
//*****************************************************************************
void stateStrobeConfig(int y)
{
	baseDefaults(y);
	ch[0].mode=STROBE_MODE;
	printstringDots("   Strobe Config Set...   ",0,0);
}
//*****************************************************************************
// Chaser Config Function
//*****************************************************************************
void stateChaserConfig(int y)
{
	baseDefaults(y);
	initChaserSystem(&Chaser);
	setChaserProgram(CHASER_PROGRAM_DEFAULT);
	setChaserPointer(&Chaser, chaserProgram);
	setChaserMode(CHASER_MODE_AUTO);	
	printstringDots("   Chaser Config Set...   ",0,0);
}
//**************************************************************************************************************************
// See Audio Channel Gains
//**************************************************************************************************************************
void stateSeeRightGain(int y)
{
	disFDotsdecimalSigned(rightGain,2,0,0);
}

void stateSeeLeftGain(int y)
{
	disFDotsdecimalSigned(leftGain,2,0,0);
}

void stateSeeMicGain(int y)
{
	disFDotsdecimalSigned(micGain,2,0,0);
}

//*************************************************************************************************************************
// Set Right Gain Functions
//*************************************************************************************************************************
void internalSetRightGain(int y)
{ 
	rightGain=((DOUBLE)unsignedclipBounded((unsigned int)y, RIGHT_GAIN_MIN, RIGHT_GAIN_MAX)/GAIN_SCALE);
	setCmCl(Cm, Cl);
}

void internalSeeSetRightGain(int y)
{
	cursor=1;
	display[0]=0;
	disFDotsdecimal(rightGain, 3, SMALL_FONT, DISPLAY_COLUMNS);
}

int internalSetRightGainInverse(int y)
{
	return (int)unsignedclipBoundedInverse(rightGain*GAIN_SCALE, RIGHT_GAIN_MIN, RIGHT_GAIN_MAX);
}

void stateSetRightGain(int y)
{
	temp=0;
	internalVary((int*)&temp, LEVELS_LOG2, &internalSetRightGain, &internalSeeSetRightGain, &internalSetRightGainInverse, 0, &emptyFunction);
}
//
//*************************************************************************************************************************
// Set Left Gain Functions
//*************************************************************************************************************************
void internalSetLeftGain(int y)
{ 
	leftGain=((DOUBLE)unsignedclipBounded((unsigned int)y, LEFT_GAIN_MIN, LEFT_GAIN_MAX)/GAIN_SCALE);
	setCmCl(Cm, Cl);
}

void internalSeeSetLeftGain(int y)
{
	cursor=1;
	display[0]=0;
	disFDotsdecimal(leftGain, 3, SMALL_FONT, DISPLAY_COLUMNS);
}

int internalSetLeftGainInverse(int y)
{
	return (int)unsignedclipBoundedInverse(leftGain*GAIN_SCALE, LEFT_GAIN_MIN, LEFT_GAIN_MAX);
}

void stateSetLeftGain(int y)
{
	temp=0;
	internalVary((int*)&temp, LEVELS_LOG2, &internalSetLeftGain, &internalSeeSetLeftGain, &internalSetLeftGainInverse, 0, &emptyFunction);
}
//*************************************************************************************************************************
// Set Mic Gain Functions
//*************************************************************************************************************************
void internalSetMicGain(int y)
{ 
	micGain=((DOUBLE)unsignedclipBounded((unsigned int)y, MIC_GAIN_MIN, MIC_GAIN_MAX)/GAIN_SCALE);
	setCmCl(Cm, Cl);
}

void internalSeeSetMicGain(int y)
{
	cursor=1;
	display[0]=0;
	disFDotsdecimal(micGain, 3, SMALL_FONT, DISPLAY_COLUMNS);
}

int internalSetMicGainInverse(int y)
{
	return (int)unsignedclipBoundedInverse(micGain*GAIN_SCALE, MIC_GAIN_MIN, MIC_GAIN_MAX);
}

void stateSetMicGain(int y)
{
	temp=0;
	internalVary((int*)&temp, LEVELS_LOG2, &internalSetMicGain, &internalSeeSetMicGain, &internalSetMicGainInverse, 0, &emptyFunction);
}

//*****************************************************************************
//
// Finite State Machine Control Functions
//
//*****************************************************************************
char getStateChar(unsigned char s)
{
	switch(s)
	{
		case VIEW_TRANSITION:
		case VIEW_PUSH_TRANSITION:
				s=0x3E;
				break;
				
		case KEY_PUSH_TRANSITION:
		case KEY_TRANSITION:
				s=0xAF;
				break;
				
		case EMPTY_POP_TRANSITION:
		case EMPTY_POP_TRANSITION_FOLLOWON:
		case EMPTY_TRANSITION:
				s=0x20;
				break;	
	}
	return s;
}

void printTitle(int u, int l)
{
	if(timeOut()){ 	setTimeOut(PRINT_TITLE_TIMEOUT);
					if(newTransition!=0){ 	
									printstringDots((machineStates[u].stateTitle)+2, 0, l);
									machineStates[u].stateFunction(0);
									} 
									else 
									{
									buffer[0]=getStateChar(machineStates[u].stateProperty);
									buffer[1]=(*machineStates[u].stateTitle);
									buffer[2]=(*(machineStates[u].stateTitle+1));
									buffer[3]=0x00;
									printstringDots(&buffer[0], 0, l);
									}
									newTransition^=1;
								}
}


int searchStates(int u)
{
	int i, k;
	
	i=0;
	k=SAME_STATE;	
	while(machineStates[i].stateID!=END_STATE)
	{
		if(machineStates[i].stateID==u){ k=i; break; } else i++;
	}		
	return k;
}

void pushState(unsigned char c)
{
	if(stateStackIndex<STATE_STACK_SIZE){
		stateStack[stateStackIndex]=c;
		stateStackIndex++;
	} else stateStackError|=STATE_STACK_OVERFLOW_ERROR;
}

unsigned char popState(void)
{
	if(stateStackIndex>0)
	{
		stateStackIndex--;
		return stateStack[stateStackIndex];
	} 
	else 
	{ 
	stateStackError|=STATE_STACK_UNDERFLOW_ERROR;
	return currentState; 
	}
}

void initStateMachine(void)
{
	newTransition=0;
	stateStackIndex=0;
	currentState=INITIAL_STATE;
}

void updateStateLEDS(int u)
{
	if(machineStates[u].nextState[STATE_KEY1_INDEX]!=SAME_STATE){ LEDS|=LED1; FLASHING&=~LED1; }
	if(machineStates[u].nextState[STATE_KEY2_INDEX]!=SAME_STATE){ LEDS|=LED2; FLASHING|=LED2; }
	if(machineStates[u].nextState[STATE_KEY3_INDEX]!=SAME_STATE){ LEDS|=LED3; FLASHING&=~LED3; }
	LEDS&=~(LED4 | LED5 | LED6);
	FLASHING&=~(LED4 | LED5 | LED6);
	LEDS|=LED7;
	FLASHING|=LED7;
}

int convertKeyToNextState(int u, int k)
{
	if(k==KEY1)k=machineStates[u].nextState[STATE_KEY1_INDEX]; 
	else 
	if(k==KEY2)k=machineStates[u].nextState[STATE_KEY2_INDEX];
	else 
	if(k==KEY3)k=machineStates[u].nextState[STATE_KEY3_INDEX]; 
	else 
	if(k==KEY7)k=POP_STATE; 
	else k=IGNORE_STATE;
	return k;
}

unsigned char doState(unsigned char cstate)
{
	// actually implement the current state until a key is pressed...
	int k;
	unsigned char u, v, s, r;
	
	updownShift=0;
	u=searchStates(cstate);
	s=machineStates[u].stateProperty;
	r=cstate;
	switch(s)
	{
		case VIEW_TRANSITION:
		case KEY_TRANSITION:
		case KEY_PUSH_TRANSITION:
		case VIEW_PUSH_TRANSITION:
				updateStateLEDS(u);
				printTitle(u, 0);
				break;
				
		case EMPTY_POP_TRANSITION:
				machineStates[u].stateFunction(0);
				r=popState();
				newTransition=0;
				intCountDownTimer=0;
				return r;
		case EMPTY_POP_TRANSITION_FOLLOWON:
				machineStates[u].stateFunction(0);
				r=popState();
				intCountDownTimer=0;
				return r;
		case EMPTY_TRANSITION:
				machineStates[u].stateFunction(0);
				r=machineStates[u].nextState[0];
				newTransition=0;
				intCountDownTimer=0;
				return r;
			
		default:
				break;
	}
	
	k=getKey();
	if(k>=0){		s=convertKeyToNextState(u, k);
				    if(s==POP_STATE){
					    //printstringDots("Back--->",0,0);
					    newTransition=0;
					    intCountDownTimer=0;
					    r=popState();
					    if(r==cstate)return cstate;
					    }
				   	else
				   	if(s==SAME_STATE)r=cstate;
				   	else
				   	if(s==IGNORE_STATE)return cstate;
				   	else r=s;
				} else return cstate;
	// so now r is the next transition
   	s=machineStates[u].stateProperty;
   	switch(s){
				case KEY_TRANSITION:
							break;
				case VIEW_TRANSITION:
							if(k==KEY2){ setTimeOut(0); return cstate; }
							break;
				case KEY_PUSH_TRANSITION:
							if(k==KEY2)pushState(cstate);
							break;
				case VIEW_PUSH_TRANSITION:
							if(k==KEY2){ setTimeOut(0); pushState(cstate); LEDS=0; FLASHING=0; return r; }
							break;
				}

	// now we switch to state r
	v=searchStates(r);
	shiftUpLine();
	updownShift=-8;
	newTransition=0;
	cursor=-3;
	setTimeOut(0);
	printTitle(v, 18); 
	for(k=0; k<8; k++){ 
		updownShift++; 
		DelayMsInt(UPDOWN_DELAY); 
		}
	flushKeys();
	LEDS=0;
	FLASHING=0;
	return r;
}

void doMenu(void)
{
	printstringDots("Menu",0, 0);
	stateStackError=STATE_STACK_OK;
	stateStackIndex=0;
	newTransition=0;
	while(stateStackError==STATE_STACK_OK)currentState=doState(currentState);
	clearDisplay(DISPLAY_OFF);
}

void initSequence(void)
{
	// The initializations...
	int i, porState; 
	unsigned int *p;
	IEC0=0;
	IEC1=0;
	IEC2=0;
	IFS0=0;
	IFS1=0;
	IFS2=0;
	INTCON1=0;
	INTCON1bits.NSTDIS=DISABLE_NESTED;
	initPorts();
	//initLVD();
	initDefaults();
	initStateMachine();
	initFrequencySystem();
	initTimer1();
	initTimer45();
	initKeys();
	initDisplay();
	initADC4(adcSamplingFreq, TADS);	
	IEC0bits.ADIE=0;
	initOutputCompare();
	porState=por();

	if((porState & FIRST_BOOT)==0)
	{
		// Not the First Time Boot
		p=(unsigned int *)&fcy;
		*p=readEEPROMInt(FCY_ADDRESS);
		p++;
		*p=readEEPROMInt(FCY_ADDRESS+1);
		p++;
		GetAllSettings(MEMORIES); 
		updateAllSettings();
		} else
		{
		// First Time Boot: put all defaults into the memory
		putTuning(0);
		writeEEPROMInt(VIEWMODE_ADDRESS, 0);
		p=(unsigned int *)&fcy;
		writeEEPROMInt(FCY_ADDRESS, *p++);
		writeEEPROMInt(FCY_ADDRESS+1, *p++);
		PutAllSettings(MEMORIES);
		i=computeCRC(UPPER_CRC_LIMIT);
		writeEEPROMInt(MAGIC_CRC_ADDRESS, i);					// store the CRC.
		writeEEPROMInt(MAGIC_EEPROM_ADDRESS, MAGIC_VALUE);		// acknowledge...
		}
	
	if((porState & NO_CALIBRATION)!=0)
	{
	printstringDots("    Welcome to the Musicolour & Enjoy the show.    ",0,0);
	}

	printstringDots("   ",0,0);
	if((mainMode & MODE_FAST_BOOT)==0){
	printstringDots(SPLASH_STRING, 0, 0);
	stateSeeVersion(0);
	printstringDots(YEAR_STRING, 0, 0);
	} 
	else { 
			printstringDots(FAST_SPLASH_STRING,0,0);
			stateSeeVersion(0);
			printstringDots("   ",0,0);
			DelayMs(STARTUP_TIME_DELAY);		
	}	

	if((mainMode & MODE_FAST_BOOT)==0)
	{
	printstringDots("   Self Checking...   ", 0,0);
	//printstringDots("   Integrity:",0,0);
	//i=readEEPROMInt(INTEGRITY_ADDRESS);
	//disWDots(i,0);
	}

	// Restore the Tuning Value
	i=0x000F & (readEEPROMInt(TUN_ADDRESS));
	putTuning(i);

	ftemp=detectMainsFreq();
    if(ftemp<=0.0){ 
				if((mainMode & MODE_FAST_BOOT)==0)printstringDots("   Warning: No Mains Detected!   ", 0, 0); else printstringDots("   Mains Bad!   ",0,0);
				IEC0bits.INT0IE=0;			// disable external INT0 interrupt!
				IEC0bits.T2IE=0;
				} 
				else 
				{ 
				IEC0bits.T2IE=1;
				IEC0bits.INT0IE=1;
				IEC0bits.OC1IE=1;
				IEC0bits.OC2IE=0;
				IEC1bits.OC3IE=0;
				IEC1bits.OC4IE=0;
				if((mainMode & MODE_FAST_BOOT)==0){ printstringDots("  Mains Detected(Hz):",0,0);	disFDotsdecimal(ftemp, 1, 0, 0); } else printstringDots("   Mains Ok.   ",0,0);  
				}

	if((mainMode & MODE_FAST_BOOT)==0)
	{
				i=readEEPROMInt(MAGIC_CRC_ADDRESS);
				if(i!=computeCRC(UPPER_CRC_LIMIT)){
					printstringDots("   Warning: Flash Bad Checksum.   ",0,0);
				} else printstringDots("   Flash Ok.   ",0,0);
	}

	//i=detectRemote();
	//if(i==TRUE){ if((mainMode & MODE_FAST_BOOT)==0)printstringDots("  Remote Control Detected...   ",0,0);  } 
	//else { 	
	if(1){
			//if((mainMode & MODE_FAST_BOOT)==0)printstringDots("   Uart Enabled...   ",0,0); 
			initUart();
			putToUart('\n');
			printstringUart(SPLASH_STRING);
			disFUart(VERSION, 2);
			printstringUart("\n");		
			}

	viewMode=readEEPROMInt(VIEWMODE_ADDRESS);
	setMainMode(MODE_AUTO);
	screenUpdate=0;
	screenTimes=0;
	ledTest();
	if((IEC0bits.INT0IE==1)&&((porState & NO_CALIBRATION)!=0))
	{
	i=stateCalibration(0);
	if(i==TRUE){ 
			writeEEPROMInt(MAGIC_CALIBRATION_ADDRESS, MAGIC_CALIBRATION_VALUE); 
		}		
		// acknowledge
	}
	resetScreenSaver();
}

unsigned int *VariablePointers[] __attribute__((space(auto_psv), aligned(2)))={
			// note: saved must be the very first Integer here, otherwise any order is ok.
			(unsigned int *)INTP, 			(unsigned int *)&saved,						(unsigned int *)INTP, 			(unsigned int *)&screenBrightness,
			(unsigned int *)INTP,			(unsigned int *)&screenFrequency,			(unsigned int *)UINTP,			(unsigned int *)&adcSamplingFreq,
			(unsigned int *)DOUBLEP,		(unsigned int *)&Cl,						(unsigned int *)DOUBLEP,		(unsigned int *)&Cm,
			(unsigned int *)INTP, 			(unsigned int *)&currentChannel, 			(unsigned int *)UINTP,			(unsigned int *)&mainMode,
			(unsigned int *)INTP, 			(unsigned int *)&chaserProgram, 			(unsigned int *)DOUBLEP,		(unsigned int *)&pulseError[0], 			
			(unsigned int *)DOUBLEP, 		(unsigned int *)&pulseError[1], 			(unsigned int *)DOUBLEP,		(unsigned int *)&screenTimeOut,
			(unsigned int *)INTP, 			(unsigned int *)&phaseOffset[0],  			(unsigned int *)INTP, 			(unsigned int *)&phaseOffset[1], 	
			(unsigned int *)INTP, 			(unsigned int *)&ch[0].minFreq, 			(unsigned int *)INTP, 			(unsigned int *)&ch[0].maxFreq, 		
			(unsigned int *)INTP, 			(unsigned int *)&ch[0].mode, 				(unsigned int *)INTP, 			(unsigned int *)&ch[0].counter, 
			(unsigned int *)INTP, 			(unsigned int *)&ch[0].quiescentLevel,		(unsigned int *)INTP, 			(unsigned int *)&ch[0].attack, 
			(unsigned int *)INTP, 			(unsigned int *)&ch[0].decay, 				(unsigned int *)DOUBLEP,		(unsigned int *)&ch[0].gain,
			(unsigned int *)INTP, 			(unsigned int *)&ch[1].minFreq, 			(unsigned int *)INTP, 			(unsigned int *)&ch[1].maxFreq, 		
			(unsigned int *)INTP, 			(unsigned int *)&ch[1].mode, 				(unsigned int *)INTP, 			(unsigned int *)&ch[1].counter, 
			(unsigned int *)INTP, 			(unsigned int *)&ch[1].quiescentLevel,		(unsigned int *)INTP, 			(unsigned int *)&ch[1].attack, 
			(unsigned int *)INTP, 			(unsigned int *)&ch[1].decay, 				(unsigned int *)DOUBLEP,		(unsigned int *)&ch[1].gain,
			(unsigned int *)INTP, 			(unsigned int *)&ch[2].minFreq, 			(unsigned int *)INTP, 			(unsigned int *)&ch[2].maxFreq, 		
			(unsigned int *)INTP, 			(unsigned int *)&ch[2].mode, 				(unsigned int *)INTP, 			(unsigned int *)&ch[2].counter, 
			(unsigned int *)INTP, 			(unsigned int *)&ch[2].quiescentLevel,		(unsigned int *)INTP, 			(unsigned int *)&ch[2].attack, 
			(unsigned int *)INTP, 			(unsigned int *)&ch[2].decay, 				(unsigned int *)DOUBLEP,		(unsigned int *)&ch[2].gain,
			(unsigned int *)INTP, 			(unsigned int *)&ch[3].minFreq, 			(unsigned int *)INTP, 			(unsigned int *)&ch[3].maxFreq, 		
			(unsigned int *)INTP, 			(unsigned int *)&ch[3].mode, 				(unsigned int *)INTP, 			(unsigned int *)&ch[3].counter, 
			(unsigned int *)INTP, 			(unsigned int *)&ch[3].quiescentLevel,		(unsigned int *)INTP, 			(unsigned int *)&ch[3].attack, 
			(unsigned int *)INTP, 			(unsigned int *)&ch[3].decay, 				(unsigned int *)DOUBLEP,		(unsigned int *)&ch[3].gain,
			(unsigned int *)UINTP,			(unsigned int *)&U1BRG,						(unsigned int *)UINTP,			(unsigned int *)&screenSaver,
			(unsigned int *)INTP,			(unsigned int *)&zvThreshold,				(unsigned int *)UINTP,			(unsigned int *)&triggerThreshold,
			(unsigned int *)UINTP,			(unsigned int *)&triggerMinFreq,			(unsigned int *)UINTP,			(unsigned int *)&triggerMaxFreq,
			(unsigned int *)UINTP,			(unsigned int *)&channelPermutation[0],		(unsigned int *)UINTP,			(unsigned int *)&channelPermutation[2],
			(unsigned int *)UINTP,			(unsigned int *)&writingMode,				(unsigned int *)UINTP,			(unsigned int *)&outputRate,
			(unsigned int *)UINTP,			(unsigned int *)&equalizerCoefficient[0],	(unsigned int *)UINTP,			(unsigned int *)&equalizerCoefficient[1],
			(unsigned int *)UINTP,			(unsigned int *)&equalizerCoefficient[2],	(unsigned int *)UINTP,			(unsigned int *)&equalizerCoefficient[3],
			(unsigned int *)UINTP,			(unsigned int *)&equalizerCoefficient[4],	(unsigned int *)UINTP,			(unsigned int *)&equalizerCoefficient[5],
			(unsigned int *)UINTP,			(unsigned int *)&equalizerCoefficient[6],	(unsigned int *)UINTP,			(unsigned int *)&equalizerCoefficient[7],
			(unsigned int *)INTP,			(unsigned int *)&silenceThreshold,			(unsigned int *)DOUBLEP,		(unsigned int *)&rightGain, 					
			(unsigned int *)DOUBLEP,		(unsigned int *)&leftGain, 					(unsigned int *)DOUBLEP,		(unsigned int *)&micGain,
			(unsigned int *)NULLP, 			(unsigned int*)NULLP 
};

int GetAllSettings(int num_mem)
{
	unsigned int c;
	int i, j, k;
	unsigned int *pr, *pt;
	unsigned int pp;
	// user memories are 0 to MEMORIES-1
	// memory no. MEMORIES is used for saving session 
	clip(&num_mem, 0, MEMORIES);
	resetEEPROMAddressForGet(__builtin_muluu(num_mem, HALFKB_DIVIDED_BY_MEMORIES));
	pp=EPaddress;
	i=0;
	pt=VariablePointers[i++];
	pr=VariablePointers[i++];
	while(pt!=NULLP)
	{
	k=0;
	if(pt==(unsigned int*)INTP)
	{
		k=1;
	} else
	if(pt==(unsigned int*)UINTP)
	{
		k=1;
	} else
	if(pt==(unsigned int*)DOUBLEP)
	{
		k=sizeof(DOUBLE);
		k=k>>1;
	}
	j=0;
	while(j<k)
	{
	c=getNextEEPROMInt();
	*pr++=c;
	j++;
	}
	pt=VariablePointers[i++];
	pr=VariablePointers[i++];
	}
	return (EPaddress-pp);
}

int PutAllSettings(int num_mem)
{
	unsigned int c;
	int i, j, k;
	unsigned int *pr, *pt;
	unsigned int pp;
	// user memories are 0 to MEMORIES-1
	// memory no. MEMORIES is used for saving session 
	clip(&num_mem, 0, MEMORIES);
	resetEEPROMAddressForPut(__builtin_muluu(num_mem, HALFKB_DIVIDED_BY_MEMORIES));
	pp=EPaddress;
	i=0;
	pt=VariablePointers[i++];
	pr=VariablePointers[i++];
	while(pt!=NULLP)
	{
	k=0;
	if(pt==(unsigned int*)INTP)
	{
		k=1;
	} else
	if(pt==(unsigned int*)UINTP)
	{
		k=1;
	} else
	if(pt==(unsigned int*)DOUBLEP)
	{
		k=sizeof(DOUBLE);
		k=k>>1;
	}
	j=0;
	while(j<k)
	{
	c=*pr++;
	putNextEEPROMInt(c);
	putToUart(c>>8);
	putToUart(c);
	j++;
	}
	pt=VariablePointers[i++];
	pr=VariablePointers[i++];
	}
	ClosePut();
	return (EPaddress-pp);
}

//*************************************************************************************************************************
// State Save Settings
//*************************************************************************************************************************
void internalrunSaveSettings(int y)
{
	printstringDots(" Saved(B):", 0, 0); disWDotsdecimal(2*PutAllSettings(saved), 0, 0);
}

void stateSaveSettings(int y)
{
	internalSetAndRun(&saved, 1, MEMORIES, 4, &internalrunSaveSettings, &displayBigDecimalMemory, 0);
}
//*************************************************************************************************************************
// State Recall Settings
//*************************************************************************************************************************
void internalrunRecallSettings(int y)
{
	int i;
	long k;
	k=__builtin_muluu(saved, HALFKB_DIVIDED_BY_MEMORIES);
	i=readEEPROMInt(SAVED_EEPROM_ADDRESS+k);			// i equals the saved value...
	if(i==saved){ 
				printstringDots(" Recalled(B):", 0, 0); 
				disWDotsdecimal(2*GetAllSettings(saved), 0, 0); 
				updateAllSettings();
				}
	else printstringDots(" Memory is Blank. No Settings Recalled.", 0,0);
}

void stateRecallSettings(int y)
{
	internalSetAndRun(&saved, 1, MEMORIES, 4, &internalrunRecallSettings, &displayBigDecimalMemory, 0);
}

void stateLoadDefaults(int y)
{
		stateSetSystemDefaults(0);
		stateSetTriggerDefaults(0);
		stateSetAudioDefaults(0);
		stateSetOutputsDefaults(0);
		stateSetChannelDefaults(0);
		stateSetDisplayDefaults(0);
		updateAllSettings();
		printstringDots("   Defaults Loaded.   ",0,0);
}

int switchToUserSettings(int xx)
{
	int i, k;

	clip(&xx, 0, MEMORIES);
	k=__builtin_muluu(xx, HALFKB_DIVIDED_BY_MEMORIES);
	i=readEEPROMInt(SAVED_EEPROM_ADDRESS+k);			// i equals the saved value...
	if(i==xx){ 
				GetAllSettings(xx);
				updateAllSettings();
				printstringDots("Ok.",0,0);
				return TRUE;
	}
	else { 
			printstringDots("Memory is Blank.", 0,0);
			return FALSE;
		}
}

int main(void) 
{
	int i, k;
	char omode, mmode;
	int (*screenFunction)(int);
	unsigned char x;

#if (USE_EXTENDED_MODE==1)
	unsigned int splim;

	splim=SPLIM;
	SPLIM=UPPERMOST_SPLIM_VALUE;
#endif

//	if((RCONbits.POR==0)&&(RCONbits.BOR==1))
//	{
//	// a brown out has occured so quickly save all settings!
//	writeEEPROMInt(VIEWMODE_ADDRESS, 0);
//	p=(unsigned int *)&fcy;
//	writeEEPROMInt(FCY_ADDRESS, *p++);
//	writeEEPROMInt(FCY_ADDRESS+1, *p++);
//	PutAllSettings(MEMORIES);
//	i=readEEPROMInt(INTEGRITY_ADDRESS);
//	writeEEPROMInt(INTEGRITY_ADDRESS, i+1);		// acknowledge...
//	while(1)wait();								// finish: block.
//	}

	TRISE=0xFFEF;
	PORTE=0xFFFF;
	DelayMs(STARTUP_TIME_DELAY);
	initSequence();
#if (USE_EXTENDED_MODE==1)
	SPLIM=splim;
#endif
	IEC0bits.ADIE=1;			// enable ADC interrupt
	mmode=getMainMode();
	setTimeOut(0);

	while(1){

	while((k=getKey())<0){
		omode=mmode;
		mmode=getMainMode();
		if(mmode==MODE_MENU){
			LEDS=0;
			FLASHING=0;
			printstringDots("   ", 0, 0);
			#if (USE_EXTENDED_MODE==1)
			x=adcErr;
			adcErr|=0x01;									// pause the ADC system memory fill to release the RAM!
			splim=SPLIM;
			SPLIM=UPPERMOST_SPLIM_VALUE;					// enter Extended Mode Operation (when the SigCmpx is not required).
			#endif	
			doMenu();
			setMainMode(omode);
			// here we should save all settings to EEPROM once again.
			#if (USE_EXTENDED_MODE==1)
			SPLIM=splim;					// exit Extended Mode Operation (when SigCmpx is again required)
			adcErr=x;
			#endif
			PutAllSettings(MEMORIES);
		} else 
		{
		if(((displayEnable & DENABLE)!=0)&&(mmode==MODE_USER)){ 
							LEDS|=LED3; LEDS&=~LED1; 
							} else 
							if(mmode==MODE_AUTO){ 
							LEDS|=LED1; LEDS&=~LED3; 
							}
		if(adcReq==0){
						if((displayEnable & DENABLE)!=0){
								if((adcStatus & SILENCE)!=SILENCE)
							 	{ 
								silenceCounter=SILENCE_TIMEOUT;
								FLASHING&=~(LED1 | LED3);
								} else 
								if(silenceCounter<=0)
								{ 
								FLASHING|=(LED1 | LED3); 
								}
								if(((adcStatus & CLIP_L)!=0)||((adcStatus & CLIP_R)!=0))
								{ 
								LEDS|=LED2;
								FLASHING|=LED2;
								adcStatus&=~(CLIP_L | CLIP_R);
								} else 
								if((trigger & TRIGGER_ON)!=0)
								{
								  LEDS|=LED2;
								  FLASHING&=~LED2;
								} else
								{		
								LEDS&=~LED2;
								FLASHING&=~LED2;
								}
						}
					} 
					else 
					{
					if(adcErr!=0)
					{
						adcErr=0;
						adcReq=0;
					}
					else
					{
					doFFT(DOFFT_UPDATE_PEAK);
					if((viewMode==ML_SCROLL_RMS)||(viewMode==ML_ANALOG_VU))rms=computeRMS();
					if(outputTimer<=0){
										outputTimer=outputRate;
										countOutputs();
										setOutputs();
									   }
					if((displayEnable & DENABLE)==0){
							// we service the screen saver function
							screenFunction=ScreenSavers[screenSaver];
							i=screenFunction(0);
					} else
					{
					viewMode=__builtin_modud(viewMode, ML_TOTAL);
					if(screenUpdate==0)
					{
					printstringDots("   ",0,0);
					}
					if(noKeys())
					{
					switch(viewMode)
						{
						case ML_SPEC_FINE:
								if(screenUpdate==0){
												printstringDots("Spectrum Fine",0,0);
												screenUpdate=1;
								} else
								{
								if(timeOut()){ 	
												setTimeOut(ML_SPEC_FINE_TIMEOUT);
												drawSpectrumFine(); 
											}
								}
								break;
					
						case ML_CHN_AVG:
								if(screenUpdate==0)
								{
												printstringDots("Channels Avg",0,0);
												screenUpdate=1;
								} else
								{
								if(timeOut()){ 	
												setTimeOut(ML_CHN_AVG_TIMEOUT);
											   	drawChannels(DRAWCHANNELS_QUIESCENT | DRAWCHANNELS_ENVELOPE);
											 } 
								}
								break;
						case ML_SPEC_CENTRE:
								if(screenUpdate==0)
								{
												printstringDots("Spectrum Centre",0,0);
												screenUpdate=1;
								} else
								{
								if(timeOut()){ 	
												setTimeOut(ML_SPEC_CENTRE_TIMEOUT);
												drawSpectrumCentre();
											 } 
								}
								break;
						case ML_CHN_SINGLE:
								if(screenUpdate==0)
								{
												printstringDots("Channels Single",0,0);
												screenUpdate=1;
								} else
								{
								if(timeOut()){ 	
												setTimeOut(ML_CHN_SINGLE_TIMEOUT);
												drawChannels(DRAWCHANNELS_QUIESCENT);
											 } 
								}
								break;
						case ML_SPEC_WIDE:
								if(screenUpdate==0)
								{
												printstringDots("Spectrum Wide",0,0);
												screenUpdate=1;
												
								} else
								{
								if(timeOut()){ 	
												setTimeOut(ML_SPEC_WIDE_TIMEOUT);
												drawSpectrumWide();
												
											 } 
								}
								break;
						case ML_SCROLL_RMS:
								if(screenUpdate==0)
								{
												printstringDots("Scrolling RMS",0,0);
												screenUpdate=1;
												
								} else
								{
								if(timeOut()){
												setTimeOut(ML_SCROLL_RMS_TIMEOUT);
												drawOscilloscopeRMS();
											 }
								}
								break;
						case ML_ANALOG_VU:
								if(screenUpdate==0)
								{
												printstringDots("Analog VU",0,0);
												screenUpdate=1;
												
								} else
								{
								if(timeOut()){ 	
												setTimeOut(ML_ANALOG_VU_TIMEOUT);
												drawVUMeterAnalog();
											 } 
								}
								break;
						case ML_LAST:
								viewMode++;
								writeEEPROMInt(VIEWMODE_ADDRESS, viewMode);
								break;
							}
						}
						}
						if(adcErr==0)adcReq=0;
					}
				}
		}
	}
	LEDS&=~LED2;
	// here we process the keys pressed in the queue...
	if((k==KEY1)&&(mmode==MODE_AUTO))
			{ 
			viewMode++;
			writeEEPROMInt(VIEWMODE_ADDRESS, viewMode); 
			screenUpdate=0; 
			} 
	else 
	if((k==KEY1)&&(mmode!=MODE_AUTO))
			{ 
			LEDS=LED1;
			FLASHING=LED1;
			printstringDots("Automatic Mode",0,0);
			setMainMode(MODE_AUTO);
			LEDS=0;
			FLASHING=0; 
			screenUpdate=1;
			}
	else
	if(k==KEY2)
			{ 
			setMainMode(MODE_MENU);
			screenUpdate=1;
			}
	else
	if((k==KEY3)&&(mmode==MODE_USER))
			{ 
			viewMode++;
			writeEEPROMInt(VIEWMODE_ADDRESS, viewMode); 
			screenUpdate=0; 
			}
	else 
	if(k==KEY4)
			{ 
			LEDS=LED4;
			FLASHING=LED4;
			printstringDots("User Mode 1:",0,0);
			i=switchToUserSettings(0);
			if(i==TRUE)
				{
				setMainMode(MODE_USER);	
				LEDS=0;
				FLASHING=0;
				screenUpdate=1;
				}
			}
	else
	if(k==KEY5)
			{ 
			LEDS=LED5;
			FLASHING=LED5;
			printstringDots("User Mode 2:",0,0); 
			i=switchToUserSettings(1);
			if(i==TRUE)
				{
				setMainMode(MODE_USER);
				LEDS=0;
				FLASHING=0;
				screenUpdate=1;
				}
			}
	else
	if(k==KEY6)
			{ 
			LEDS=LED6;
			FLASHING=LED6;
			printstringDots("User Mode 3:",0,0);
			i=switchToUserSettings(2);
			if(i==TRUE)
				{
				setMainMode(MODE_USER);
				LEDS=0;
				FLASHING=0;
				screenUpdate=1;
				}
			}
	else
	if(k==KEY7)
			{ 
			LEDS=LED7;
			FLASHING=LED7;
			printstringDots("User Mode 4:",0,0);
			i=switchToUserSettings(3);
			 if(i==TRUE)
			 { 
				setMainMode(MODE_USER);
				LEDS=0;
				FLASHING=0;
				screenUpdate=1;
			 }
			}
	}	
}
